DO
$adjust_sequences$
DECLARE
  rec RECORD;
BEGIN
  FOR rec IN SELECT REGEXP_REPLACE(TABLE_NAME, '_content_repository$', '') AS format
             FROM INFORMATION_SCHEMA.TABLES
             WHERE TABLE_NAME LIKE '%_content_repository'
  LOOP
    EXECUTE FORMAT('SELECT SETVAL(''%1$s_content_repository_repository_id_seq'', (SELECT MAX(repository_id) FROM %1$s_content_repository))', rec.format);
    EXECUTE FORMAT('SELECT SETVAL(''%1$s_component_component_id_seq'', (SELECT MAX(component_id) FROM %1$s_component))', rec.format);
    EXECUTE FORMAT('SELECT SETVAL(''%1$s_asset_blob_asset_blob_id_seq'', (SELECT MAX(asset_blob_id) FROM %1$s_asset_blob))', rec.format);
    EXECUTE FORMAT('SELECT SETVAL(''%1$s_asset_asset_id_seq'', (SELECT MAX(asset_id) from %1$s_asset))', rec.format);
  END LOOP;
  EXECUTE 'SELECT SETVAL(''tag_id_seq'', (SELECT MAX(id) FROM tag))';
END
$adjust_sequences$;
