within ;
package TestDerivative "Test of functions with user defined derivatives" 
  package Functions 
    
    function f1 
    input Real r1;
    input Real r2;
    output Records.TwoRealRecord R1;
    algorithm 
    R1.r1 :=sqrt(r1)*sin(r1);
    R1.r2 :=sqrt(r1)*sqrt(r2)*sin(r1);
    annotation(smoothOrder=2);
    end f1;
    
    function f2 
    input Real r1;
    input Real r2;
    output Records.TwoRealRecord R1;
    algorithm 
    R1.r1 :=sqrt(r1)*sin(r1);
    R1.r2 :=sqrt(r1)*sqrt(r2)*sin(r1);
    annotation(derivative = f2_der);
    end f2;
    
    function f2_der 
    input Real r1;
    input Real r2;
    input Real dr1;
    input Real dr2;
    output Records.TwoRealRecord R1_der;
    algorithm 
    R1_der.r1 :=dr1; //dummy statement
    R1_der.r2 :=dr2; //dummy statement
    end f2_der;
    
    function f3 
    input Real r1;
    input Real r2;
    input Integer i1;
    output Records.MyRecord R1;
    algorithm 
    R1.r1 :=sqrt(r1)*sin(i1*r1);
    R1.r2 :=sqrt(r1)*sqrt(r2)*sin(r1);
    R1.i1 :=i1;
    annotation(smoothOrder=2);
    end f3;
    
    function f3_der 
    input Real r1;
    input Real r2;
    input Integer i1;
    input Real dr1;
    input Real dr2;
    output Records.MyRecord R1_der;
    algorithm 
    R1_der.r1 :=dr1; //dummy
    R1_der.r2 :=dr2; //dummy
    R1_der.i1 :=0;
    end f3_der;
    
    function f4 
    input Real r1;
    input Real r2;
    input Integer i1;
    output Records.TwoRealRecord R1;
    algorithm 
    R1.r1 :=sqrt(r1)*sin(i1*r1);
    R1.r2 :=sqrt(r1)*sqrt(r2)*sin(r1);
    annotation(smoothOrder=2);
    end f4;
    
    function f5_props 
      input Real r1;
      input Real r2;
      input Records.TwoRealRecord properties;
      output Records.TwoRealRecord R1;
    algorithm 
      R1.r1 :=sqrt(r1)*sin(r1);
      R1.r2 :=sqrt(r1)*sqrt(r2)*sin(r1);
    annotation(derivative(noDerivative=properties) = f5_der,
        Inline=false,
        LateInline=true);
    end f5_props;
    
    function f5_der 
      input Real r1;
      input Real r2;
      input Records.TwoRealRecord properties;
      
      input Real dr1;
      input Real dr2;
      
      output Records.TwoRealRecord R1_der;
    algorithm 
      R1_der.r1 := properties.r1 * dr1; //dummy statement
      R1_der.r2 := properties.r1 * dr2; //dummy statement
    end f5_der;
    
    function f5 
      input Real r1;
      input Real r2;
      output Records.TwoRealRecord R1;
    algorithm 
      R1 :=f5_props(
            r1,
            r2,
            TestDerivative.Records.GetRecord());
    end f5;

    function f6 
      input Real r1;
      input Real r2;
      output Records.TwoRealRecord R1;
      output Records.TwoRealRecord R2;
    algorithm 
      R1.r1 :=sqrt(r1)*sin(r1);
      R1.r2 :=sqrt(r1)*sqrt(r2)*sin(r1);
      R2.r1 :=sqrt(r1)*sin(r1);
      R2.r2 :=sqrt(r1)*sqrt(r2)*sin(r1);
    annotation(derivative = f6_der);
    end f6;

    function f6_der 
      input Real r1;
      input Real r2;
      
      input Real dr1;
      input Real dr2;
      
      output Records.TwoRealRecord R1_der;
      output Records.TwoRealRecord R2_der;
    algorithm 
      R1_der.r1 :=dr1; //dummy statement
      R1_der.r2 :=dr2; //dummy statement
      R2_der.r1 :=dr1; //dummy statement
      R2_der.r2 :=dr2; //dummy statement
    end f6_der;
  end Functions;
  
  package Tests 
    model T1 
    Real r1;
    Real r2;
    Records.TwoRealRecord R1;
    equation 
    R1.r1=time;
    der(R1.r2)=R1.r1;
    R1 = Functions.f1(r1,r2);
    end T1;
    
    model T2 
    Real r1;
    Real r2;
    Records.TwoRealRecord R1;
    equation 
    R1.r1=time;
    der(R1.r2)=R1.r1;
    R1 = Functions.f2(r1,r2);
    end T2;
    
    model T3 
    Real r1;
    Real r2;
    Integer i1;
    Records.MyRecord R1(i1=1);
    equation 
    R1.r1=time;
    der(R1.r2)=R1.r1;
    R1 = Functions.f3(r1,r2,i1);
      
    end T3;
    
    model T4 
    Real r1;
    Real r2;
    Integer i1=1;
    Records.TwoRealRecord R1;
    equation 
    R1.r1=time;
    der(R1.r2)=R1.r1;
    R1 = Functions.f4(r1,r2,i1);
      
    end T4;
    
    model T5 
      Real r1( start = 1.0);
      Real r2( start = 1.0);
      Records.TwoRealRecord R1;
    equation 
      R1.r1=time;
      der(R1.r2)=R1.r1;
      R1 = Functions.f5(r1,r2);
    end T5;

    model T6 
    Real r1;
    Real r2;
    Records.TwoRealRecord R1;
    equation 
    R1.r1=time;
    der(R1.r2)=R1.r1;
    R1 = Functions.f6(r1,r2);
    end T6;
  end Tests;
  
  package Records 
    record MyRecord 
    Real r1;
    Real r2;
    Integer i1;
    end MyRecord;
    
    record RealRecord 
    Real M[2,2];
    Real x[2];
    end RealRecord;
    
    record TwoRealRecord 
    Real r1;
      Real r2;
    end TwoRealRecord;
    
    function GetRecord "Simple function returning a record" 
      output TestDerivative.Records.TwoRealRecord res;
    algorithm 
      res.r1 := 1.0;
      res.r2 := 1.0;
    end GetRecord;
  end Records;
  annotation (uses(Modelica(version="3.2.3")));
end TestDerivative;
