/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jacorb.notification.EventTypeSet;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.LogUtil;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.slf4j.Logger;

public class CallbackManager
extends EventTypeSet
implements Disposable {
    private final AtomicInteger callbackIdPool_ = new AtomicInteger(0);
    private final Map callbacks_ = new HashMap();
    private final Logger logger_ = LogUtil.getLogger(this.getClass().getName());

    public int attach_callback(NotifySubscribe subscriber) {
        int id = this.callbackIdPool_.getAndIncrement();
        Integer key = new Integer(id);
        this.callbacks_.put(key, subscriber);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("attach_callback: ID=" + id + " Subscriber=" + subscriber);
        }
        return id;
    }

    public void detach_callback(int id) {
        Object removed = this.callbacks_.remove(new Integer(id));
        if (this.logger_.isInfoEnabled()) {
            boolean success = removed != null;
            this.logger_.info("detach_callback: ID=" + id + " Success=" + success);
        }
    }

    public int[] get_callbacks() {
        Integer[] keys = this.callbacks_.keySet().toArray(new Integer[0]);
        int[] ids = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            ids[i] = keys[i];
        }
        return ids;
    }

    @Override
    protected void actionSetChanged(EventType[] added, EventType[] removed) {
        Iterator i = this.callbacks_.keySet().iterator();
        while (i.hasNext()) {
            NotifySubscribe notifySubscribe = (NotifySubscribe)this.callbacks_.get(i.next());
            try {
                notifySubscribe.subscription_change(added, removed);
            }
            catch (InvalidEventType e) {
                this.logger_.warn("error during subscription_change", (Throwable)((Object)e));
            }
        }
    }

    public void replaceWith(EventType[] replacement) {
        this.changeSet(replacement, this.getAllTypes());
    }

    public void dispose() {
        this.callbacks_.clear();
    }
}

