/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.VisitorException;

public class BoolValue
extends AbstractTCLNode {
    private final boolean value_;
    private final EvaluationResult result_;
    private final String asString_;

    public BoolValue(Token tok) {
        super(tok);
        this.value_ = tok.getText().equals("TRUE");
        this.result_ = this.value_ ? EvaluationResult.BOOL_TRUE : EvaluationResult.BOOL_FALSE;
        this.asString_ = Boolean.toString(this.value_);
        this.setName("BoolValue");
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext context) throws EvaluationException {
        return this.result_;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    public String toString() {
        return this.asString_;
    }

    @Override
    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitBool(this);
    }

    @Override
    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitBool(this);
    }

    @Override
    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitBool(this);
    }
}

