/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.slf4j.Logger;

public class ClientContextTransferInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private int slot_id = -1;
    private Codec codec = null;
    private Logger logger = null;

    public ClientContextTransferInterceptor(Logger logger, int slot_id, Codec codec) {
        this.logger = logger;
        this.slot_id = slot_id;
        this.codec = codec;
    }

    public String name() {
        return "ClientContextTransferInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        try {
            Any any = ri.get_slot(this.slot_id);
            if (any.type().kind().value() != 0) {
                ServiceContext ctx = new ServiceContext(0, this.codec.encode(any));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("adding Transaction Service Context to outgoing request");
                }
                ri.add_request_service_context(ctx, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }
}

