/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.util.Calendar;
import org.jacorb.util.SelectorRequest;
import org.jacorb.util.SelectorRequestCallback;

public class TimerQueueAction
extends SelectorRequest {
    private Object notifyTarget = null;

    public TimerQueueAction(long relative) {
        super(null, TimerQueueAction.toAbsoluteNano(relative));
        this.callback = new Callback();
    }

    public TimerQueueAction(long relative, Object target) {
        super(null, TimerQueueAction.toAbsoluteNano(relative));
        this.notifyTarget = target;
        this.callback = new Callback();
    }

    public TimerQueueAction(Calendar absolute) {
        super(null, TimerQueueAction.toAbsoluteNano(absolute));
        this.callback = new Callback();
    }

    public TimerQueueAction(Calendar absolute, Object target) {
        super(null, TimerQueueAction.toAbsoluteNano(absolute));
        this.notifyTarget = target;
        this.callback = new Callback();
    }

    private static long toAbsoluteNano(Calendar absolute) {
        return absolute.getTimeInMillis() * 1000000L;
    }

    private static long toAbsoluteNano(long relative) {
        long now = System.nanoTime();
        return now + relative * 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        if (this.notifyTarget != null) {
            Object object = this.notifyTarget;
            synchronized (object) {
                this.notifyTarget.notifyAll();
            }
        }
    }

    private class Callback
    extends SelectorRequestCallback {
        private Callback() {
        }

        @Override
        public boolean call(SelectorRequest action) {
            if (action instanceof TimerQueueAction) {
                ((TimerQueueAction)action).expire();
            }
            return false;
        }
    }
}

