/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.buffermanager;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.buffermanager.BufferManagerExpansionPolicy;

public class DefaultExpansionPolicy
implements BufferManagerExpansionPolicy,
Configurable {
    private double scale;
    private double divider;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.scale = configuration.getAttributeAsFloat("jacorb.buffermanager.defaultexpansionpolicy.scale", 4.0);
        this.divider = configuration.getAttributeAsFloat("jacorb.buffermanager.defaultexpansionpolicy.divider", 6.0);
    }

    @Override
    public int getExpandedSize(int requestedSize) {
        double multiplier = this.scale - Math.log(requestedSize) / this.divider;
        multiplier = multiplier < 1.0 ? 1.0 : multiplier;
        return (int)Math.floor(multiplier * (double)requestedSize);
    }
}

