/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.poa.RPPoolManager;
import org.slf4j.Logger;

public class RPPoolManagerFactory {
    private final ORB orb;
    private final Logger logger;
    private final Configuration configuration;
    private final int threadPoolMin;
    private final int threadPoolMax;
    private final int poolThreadTimeout;
    private final FactoryDelegate delegate;

    public RPPoolManagerFactory(ORB orb) throws ConfigurationException {
        this.orb = orb;
        this.configuration = orb.getConfiguration();
        this.logger = this.configuration.getLogger("org.jacorb.poa.controller");
        this.threadPoolMin = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_min", 5);
        if (this.threadPoolMin < 1) {
            throw new ConfigurationException("jacorb.poa.thread_pool_min must be >= 1");
        }
        this.threadPoolMax = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_max", 20);
        if (this.threadPoolMax > 0 && this.threadPoolMax < this.threadPoolMin) {
            throw new ConfigurationException("jacorb.poa.thread_pool_max must be >= " + this.threadPoolMin + "(jacorb.poa.thread_pool_min)");
        }
        boolean poolsShouldBeShared = this.configuration.getAttributeAsBoolean("jacorb.poa.thread_pool_shared", false);
        this.poolThreadTimeout = this.configuration.getAttributeAsInteger("jacorb.poa.threadtimeout", 0);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("RequestProcessorPoolFactory settings: thread_pool_min=" + this.threadPoolMin + " thread_pool_max=" + this.threadPoolMax + " thread_pool_shared=" + poolsShouldBeShared);
        }
        this.delegate = poolsShouldBeShared ? new SharedPoolFactory() : new DefaultPoolFactory();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public RPPoolManager newRPPoolManager(boolean isSingleThreaded) {
        if (isSingleThreaded) {
            return new RPPoolManager(this.orb.getPOACurrent(), 1, 1, this.poolThreadTimeout, this.logger, this.configuration){

                @Override
                void destroy() {
                    this.destroy(true);
                }

                @Override
                protected void warnPoolIsEmpty() {
                }
            };
        }
        return this.delegate.newRPPoolManager();
    }

    private class DefaultPoolFactory
    implements FactoryDelegate {
        private DefaultPoolFactory() {
        }

        @Override
        public RPPoolManager newRPPoolManager() {
            return new RPPoolManager(RPPoolManagerFactory.this.orb.getPOACurrent(), RPPoolManagerFactory.this.threadPoolMin, RPPoolManagerFactory.this.threadPoolMax, RPPoolManagerFactory.this.poolThreadTimeout, RPPoolManagerFactory.this.logger, RPPoolManagerFactory.this.configuration){

                @Override
                void destroy() {
                    this.destroy(true);
                }
            };
        }

        @Override
        public void destroy() {
        }
    }

    private class SharedPoolFactory
    implements FactoryDelegate {
        private final RPPoolManager sharedInstance;

        private SharedPoolFactory() {
            this.sharedInstance = new RPPoolManager(RPPoolManagerFactory.this.orb.getPOACurrent(), RPPoolManagerFactory.this.threadPoolMin, RPPoolManagerFactory.this.threadPoolMax, RPPoolManagerFactory.this.poolThreadTimeout, RPPoolManagerFactory.this.logger, RPPoolManagerFactory.this.configuration){

                @Override
                void destroy() {
                }
            };
        }

        @Override
        public RPPoolManager newRPPoolManager() {
            return this.sharedInstance;
        }

        @Override
        public void destroy() {
            this.sharedInstance.destroy(true);
        }
    }

    private static interface FactoryDelegate {
        public RPPoolManager newRPPoolManager();

        public void destroy();
    }
}

