/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.impl.ClaimsHolder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class PayloadSerializer
extends StdSerializer<ClaimsHolder> {
    public PayloadSerializer() {
        this((Class<ClaimsHolder>)null);
    }

    private PayloadSerializer(Class<ClaimsHolder> t2) {
        super(t2);
    }

    @Override
    public void serialize(ClaimsHolder holder, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        block6: for (Map.Entry<String, Object> e : holder.getClaims().entrySet()) {
            switch (e.getKey()) {
                case "aud": {
                    if (e.getValue() instanceof String) {
                        gen.writeFieldName(e.getKey());
                        gen.writeString((String)e.getValue());
                        continue block6;
                    }
                    String[] audArray = (String[])e.getValue();
                    if (audArray.length == 1) {
                        gen.writeFieldName(e.getKey());
                        gen.writeString(audArray[0]);
                        continue block6;
                    }
                    if (audArray.length <= 1) continue block6;
                    gen.writeFieldName(e.getKey());
                    gen.writeStartArray();
                    for (String aud : audArray) {
                        gen.writeString(aud);
                    }
                    gen.writeEndArray();
                    continue block6;
                }
            }
            gen.writeFieldName(e.getKey());
            if (e.getValue() instanceof Date) {
                gen.writeNumber(this.dateToSeconds((Date)e.getValue()));
                continue;
            }
            gen.writeObject(e.getValue());
        }
        gen.writeEndObject();
    }

    private long dateToSeconds(Date date) {
        return date.getTime() / 1000L;
    }
}

