/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection.closabledictionary;

import com.orientechnologies.common.collection.closabledictionary.OClosableItem;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

public class OClosableEntry<K, V extends OClosableItem> {
    private static final long STATUS_OPEN = 1L;
    private static final long STATUS_CLOSED = 2L;
    private static final long STATUS_RETIRED = 4L;
    private static final long STATUS_DEAD = 5L;
    private static final long ACQUIRED_OFFSET = 32L;
    @GuardedBy(value="lruLock")
    private OClosableEntry<K, V> next;
    @GuardedBy(value="lruLock")
    private OClosableEntry<K, V> prev;
    private final V item;
    @GuardedBy(value="stateLock")
    private volatile long state = 1L;
    private final Lock stateLock = new ReentrantLock();

    @GuardedBy(value="lruLock")
    public OClosableEntry<K, V> getNext() {
        return this.next;
    }

    @GuardedBy(value="lruLock")
    public void setNext(OClosableEntry<K, V> next) {
        this.next = next;
    }

    @GuardedBy(value="lruLock")
    public OClosableEntry<K, V> getPrev() {
        return this.prev;
    }

    @GuardedBy(value="lruLock")
    public void setPrev(OClosableEntry<K, V> prev) {
        this.prev = prev;
    }

    OClosableEntry(V item) {
        this.item = item;
    }

    public V get() {
        return this.item;
    }

    void acquireStateLock() {
        this.stateLock.lock();
    }

    void releaseStateLock() {
        this.stateLock.unlock();
    }

    public static boolean isOpen(long state) {
        return state == 1L;
    }

    @GuardedBy(value="stateLock")
    void makeAcquiredFromClosed(OClosableItem item) {
        long s2 = this.state;
        if (s2 != 2L) {
            throw new IllegalStateException();
        }
        long acquiredState = 0x100000000L;
        item.open();
        this.state = 0x100000000L;
    }

    @GuardedBy(value="stateLock")
    void makeAcquiredFromOpen() {
        if (this.state != 1L) {
            throw new IllegalStateException();
        }
        this.state = 0x100000000L;
    }

    void releaseAcquired() {
        this.stateLock.lock();
        try {
            long acquireCount = this.state >>> 32;
            if (acquireCount < 1L) {
                throw new IllegalStateException("Amount of acquires less than one");
            }
            this.state = --acquireCount < 1L ? 1L : acquireCount << 32;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @GuardedBy(value="stateLock")
    void incrementAcquired() {
        long acquireCount = this.state >>> 32;
        if (acquireCount < 1L) {
            throw new IllegalStateException();
        }
        this.state = ++acquireCount << 32;
    }

    long makeRetired() {
        long oldSate = this.state;
        this.stateLock.lock();
        try {
            this.state = 4L;
        }
        finally {
            this.stateLock.unlock();
        }
        return oldSate;
    }

    void makeDead() {
        this.stateLock.lock();
        try {
            this.state = 5L;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    boolean makeClosed() {
        this.stateLock.lock();
        try {
            if (this.state == 2L) {
                boolean bl = true;
                return bl;
            }
            if (this.state != 1L) {
                boolean bl = false;
                return bl;
            }
            this.item.close();
            this.state = 2L;
        }
        finally {
            this.stateLock.unlock();
        }
        return true;
    }

    boolean isClosed() {
        return this.state == 2L;
    }

    boolean isRetired() {
        return this.state == 4L;
    }

    boolean isDead() {
        return this.state == 5L;
    }

    boolean isOpen() {
        return this.state == 1L;
    }
}

