/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.thread;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OSQLDumper;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class OScheduledThreadPoolExecutorWithLogging
extends ScheduledThreadPoolExecutor {
    public OScheduledThreadPoolExecutorWithLogging(int corePoolSize) {
        super(corePoolSize);
    }

    public OScheduledThreadPoolExecutorWithLogging(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public OScheduledThreadPoolExecutorWithLogging(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public OScheduledThreadPoolExecutorWithLogging(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t2) {
        Future future;
        super.afterExecute(r, t2);
        if (r instanceof Future && (future = (Future)((Object)r)).isDone()) {
            try {
                future.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException ee) {
                t2 = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t2 != null) {
            Thread thread = Thread.currentThread();
            OLogManager logManager = OLogManager.instance();
            if (logManager != null) {
                if (t2 instanceof OutOfMemoryError) {
                    Collection<String> queries = OSQLDumper.dumpAllSQLQueries();
                    if (queries.isEmpty()) {
                        logManager.errorNoDb(this, "Uncaught exception in thread '%s'", t2, thread.getName());
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append("OOM Error was thrown by JVM. OOM can be caused by one of the following queries: \n");
                        sb.append("-----------------------------------------------------------------------------------\n");
                        for (String query2 : queries) {
                            sb.append("- '").append(query2).append("'\n");
                        }
                        sb.append("-----------------------------------------------------------------------------------\n");
                        logManager.errorNoDb(this, sb.toString(), t2, new Object[0]);
                    }
                } else {
                    logManager.errorNoDb(this, "Uncaught exception in thread '%s'", t2, thread.getName());
                }
            }
        }
    }
}

