/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine;

import com.orientechnologies.common.jna.ONative;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMemory;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OMemoryAndLocalPaginatedEnginesInitializer {
    public static final OMemoryAndLocalPaginatedEnginesInitializer INSTANCE = new OMemoryAndLocalPaginatedEnginesInitializer();
    private boolean initialized = false;

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.configureDefaults();
        OMemory.checkDirectMemoryConfiguration();
        OMemory.checkByteBufferPoolConfiguration();
        OMemory.checkCacheMemoryConfiguration();
        OMemory.fixCommonConfigurationProblems();
    }

    private void configureDefaults() {
        this.configureDefaultSoftRefsInSQL();
        OLogManager.instance().infoNoDb(this, "Auto configuration of disk cache size.", new Object[0]);
        if (!OGlobalConfiguration.DISK_CACHE_SIZE.isChanged()) {
            this.configureDefaultDiskCacheSize();
        } else {
            OLogManager.instance().infoNoDb(this, "Disk cache size is directly set by the user to the %d mb", OGlobalConfiguration.DISK_CACHE_SIZE.getValue());
        }
        if (!OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.isChanged()) {
            this.configureDefaultWalRestoreBatchSize();
        }
    }

    private void configureDefaultSoftRefsInSQL() {
        if (OGlobalConfiguration.QUERY_USE_SOFT_REFENCES_IN_RESULT_SET.getValue() == null) {
            long xmxBytes;
            OLogManager.instance().infoNoDb(this, "Configuration of usage of soft references inside of containers of results of SQL execution", new Object[0]);
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> inputArgs = runtimeMXBean.getInputArguments();
            String xms = null;
            String xmx = null;
            for (String inputArg : inputArgs) {
                if (inputArg.matches("-Xms\\d+[gGmMkK]?")) {
                    xms = inputArg;
                    continue;
                }
                if (!inputArg.matches("-Xmx\\d+[gGmMkK]?")) continue;
                xmx = inputArg;
            }
            if (xmx == null || xms == null) {
                OLogManager.instance().infoNoDb(this, "Initial or maximum values of heap memory usage are NOT set, containers of results of SQL executors will NOT use soft references by default", new Object[0]);
                OGlobalConfiguration.QUERY_USE_SOFT_REFENCES_IN_RESULT_SET.setValue(false);
                return;
            }
            long xmsBytes = this.extractMemoryLimitInBytes(xms);
            if (xmsBytes == (xmxBytes = this.extractMemoryLimitInBytes(xmx))) {
                OLogManager.instance().infoNoDb(this, "Initial and maximum values of heap memory usage are equal, containers of results of SQL executors will use soft references by default", new Object[0]);
                OGlobalConfiguration.QUERY_USE_SOFT_REFENCES_IN_RESULT_SET.setValue(true);
            } else {
                OLogManager.instance().infoNoDb(this, "Initial and maximum values of heap memory usage are NOT equal, containers of results of SQL executors will NOT use soft references by default", new Object[0]);
                OGlobalConfiguration.QUERY_USE_SOFT_REFENCES_IN_RESULT_SET.setValue(false);
            }
        }
    }

    private long extractMemoryLimitInBytes(String limit) {
        Pattern pattern = Pattern.compile("((-Xms)|(-Xmx))(\\d+)([gGmMkK]?)");
        Matcher matcher = pattern.matcher(limit);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid value of memory limit was provided '" + limit + "'");
        }
        String value = matcher.group(4);
        String dimension = matcher.group(5);
        long bytes = Long.parseLong(value);
        if (dimension == null || dimension.isEmpty()) {
            return bytes;
        }
        if ((dimension = dimension.toLowerCase(Locale.ENGLISH)).equals("g")) {
            bytes = bytes * 1024L * 1024L * 1024L;
        } else if (dimension.equals("m")) {
            bytes = bytes * 1024L * 1024L;
        } else if (dimension.equals("k")) {
            bytes *= 1024L;
        } else {
            throw new IllegalArgumentException("Invalid dimension of memory limit + '" + dimension + "'");
        }
        return bytes;
    }

    private void configureDefaultWalRestoreBatchSize() {
        long jvmMaxMemory = Runtime.getRuntime().maxMemory();
        if (jvmMaxMemory > 0x80000000L) {
            OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.setValue(50000);
        } else if (jvmMaxMemory > 0x20000000L) {
            OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.setValue(10000);
        }
    }

    private void configureDefaultDiskCacheSize() {
        ONative.MemoryLimitResult osMemory = ONative.instance().getMemoryLimit(true);
        if (osMemory == null) {
            OLogManager.instance().warnNoDb(this, "Can not determine amount of memory installed on machine, default values will be used", new Object[0]);
            return;
        }
        long jvmMaxMemory = OMemory.getCappedRuntimeMaxMemory(0x80000000L);
        long maxDirectMemory = OMemory.getConfiguredMaxDirectMemory();
        if (maxDirectMemory == -1L) {
            long diskCacheInMB = jvmMaxMemory / 1024L / 1024L - 2L;
            OLogManager.instance().infoNoDb(this, "OrientDB auto-config DISKCACHE=%,dMB (heap=%,dMB direct=%,dMB os=%,dMB), assuming maximum direct memory size equals to maximum JVM heap size", diskCacheInMB, jvmMaxMemory / 1024L / 1024L, jvmMaxMemory / 1024L / 1024L, osMemory.memoryLimit / 1024L / 1024L);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(diskCacheInMB);
            OGlobalConfiguration.MEMORY_CHUNK_SIZE.setValue(Math.min(diskCacheInMB * 1024L * 1024L, OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong()));
            return;
        }
        long maxDirectMemoryInMB = maxDirectMemory / 1024L / 1024L;
        long diskCacheInMB = osMemory.insideContainer ? (osMemory.memoryLimit - jvmMaxMemory) / 0x100000L - 512L : (osMemory.memoryLimit - jvmMaxMemory) / 0x100000L - 2048L;
        if (diskCacheInMB > 0L) {
            diskCacheInMB = Math.min(diskCacheInMB, maxDirectMemoryInMB);
            OLogManager.instance().infoNoDb(this, "OrientDB auto-config DISKCACHE=%,dMB (heap=%,dMB direct=%,dMB os=%,dMB)", diskCacheInMB, jvmMaxMemory / 1024L / 1024L, maxDirectMemoryInMB, osMemory.memoryLimit / 1024L / 1024L);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(diskCacheInMB);
            OGlobalConfiguration.MEMORY_CHUNK_SIZE.setValue(Math.min(diskCacheInMB * 1024L * 1024L, OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong()));
        } else {
            diskCacheInMB = Math.min(256L, maxDirectMemoryInMB);
            OLogManager.instance().warnNoDb(this, "Not enough physical memory available for DISKCACHE: %,dMB (heap=%,dMB direct=%,dMB). Set lower Maximum Heap (-Xmx setting on JVM) and restart OrientDB. Now running with DISKCACHE=" + diskCacheInMB + "MB", osMemory.memoryLimit / 1024L / 1024L, jvmMaxMemory / 1024L / 1024L, maxDirectMemoryInMB);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(diskCacheInMB);
            OGlobalConfiguration.MEMORY_CHUNK_SIZE.setValue(Math.min(diskCacheInMB * 1024L * 1024L, OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong()));
            OLogManager.instance().infoNoDb(this, "OrientDB config DISKCACHE=%,dMB (heap=%,dMB direct=%,dMB os=%,dMB)", diskCacheInMB, jvmMaxMemory / 1024L / 1024L, maxDirectMemoryInMB, osMemory.memoryLimit / 1024L / 1024L);
        }
    }
}

