/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OCommandExecutorSQLCreateProperty
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    public static final String KEYWORD_MANDATORY = "MANDATORY";
    public static final String KEYWORD_READONLY = "READONLY";
    public static final String KEYWORD_NOTNULL = "NOTNULL";
    public static final String KEYWORD_MIN = "MIN";
    public static final String KEYWORD_MAX = "MAX";
    public static final String KEYWORD_DEFAULT = "DEFAULT";
    public static final String KEYWORD_COLLATE = "COLLATE";
    public static final String KEYWORD_REGEX = "REGEX";
    private String className;
    private String fieldName;
    private boolean ifNotExists = false;
    private OType type;
    private String linked;
    private boolean readonly = false;
    private boolean mandatory = false;
    private boolean notnull = false;
    private String max = null;
    private String min = null;
    private String defaultValue = null;
    private String collate = null;
    private String regex = null;
    private boolean unsafe = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLCreateProperty parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
                throw new OCommandSQLParsingException("Keyword CREATE not found", this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
                throw new OCommandSQLParsingException("Keyword PROPERTY not found", this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                throw new OCommandSQLParsingException("Expected <class>.<property>", this.parserText, oldPos);
            }
            String[] parts = this.split(word);
            if (parts.length != 2) {
                throw new OCommandSQLParsingException("Expected <class>.<property>", this.parserText, oldPos);
            }
            this.className = this.decodeClassName(parts[0]);
            if (this.className == null) {
                throw new OCommandSQLParsingException("Class not found", this.parserText, oldPos);
            }
            this.fieldName = this.decodeClassName(parts[1]);
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Missed property type", this.parserText, oldPos);
            }
            if ("IF".equalsIgnoreCase(word.toString())) {
                oldPos = pos;
                if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
                    throw new OCommandSQLParsingException("Missed property type", this.parserText, oldPos);
                }
                if (!"NOT".equalsIgnoreCase(word.toString())) {
                    throw new OCommandSQLParsingException("Expected NOT EXISTS after IF", this.parserText, oldPos);
                }
                oldPos = pos;
                if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
                    throw new OCommandSQLParsingException("Missed property type", this.parserText, oldPos);
                }
                if (!"EXISTS".equalsIgnoreCase(word.toString())) {
                    throw new OCommandSQLParsingException("Expected EXISTS after IF NOT", this.parserText, oldPos);
                }
                this.ifNotExists = true;
                oldPos = pos;
                pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            }
            this.type = OType.valueOf(word.toString());
            String rest = this.parserText.substring(pos).trim();
            String pattern = "(`[^`]*`|[^\\(]\\S*)?\\s*(\\(.*\\))?\\s*(UNSAFE)?";
            Pattern r = Pattern.compile(pattern, 2);
            Matcher m4 = r.matcher(rest.trim());
            if (m4.matches()) {
                if (m4.group(1) != null && !m4.group(1).equalsIgnoreCase("UNSAFE")) {
                    this.linked = m4.group(1);
                    if (this.linked.startsWith("`") && this.linked.endsWith("`") && this.linked.length() > 1) {
                        this.linked = this.linked.substring(1, this.linked.length() - 1);
                    }
                }
                if (m4.group(2) != null) {
                    String raw = m4.group(2);
                    String atts = raw.substring(1, raw.length() - 1);
                    this.processAtts(atts);
                }
                if (m4.group(3) != null) {
                    this.unsafe = true;
                }
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    private void processAtts(String atts) {
        String[] split;
        for (String attDef : split = atts.split(",")) {
            String att;
            String[] parts = attDef.trim().split("\\s+");
            if (parts.length > 2) {
                this.onInvalidAttributeDefinition(attDef);
            }
            if ((att = parts[0].trim()).equalsIgnoreCase(KEYWORD_MANDATORY)) {
                this.mandatory = this.getOptionalBoolean(parts);
                continue;
            }
            if (att.equalsIgnoreCase(KEYWORD_READONLY)) {
                this.readonly = this.getOptionalBoolean(parts);
                continue;
            }
            if (att.equalsIgnoreCase(KEYWORD_NOTNULL)) {
                this.notnull = this.getOptionalBoolean(parts);
                continue;
            }
            if (att.equalsIgnoreCase(KEYWORD_MIN)) {
                this.min = this.getRequiredValue(attDef, parts);
                continue;
            }
            if (att.equalsIgnoreCase(KEYWORD_MAX)) {
                this.max = this.getRequiredValue(attDef, parts);
                continue;
            }
            if (att.equalsIgnoreCase(KEYWORD_DEFAULT)) {
                this.defaultValue = this.getRequiredValue(attDef, parts);
                continue;
            }
            if (att.equalsIgnoreCase(KEYWORD_COLLATE)) {
                this.collate = this.getRequiredValue(attDef, parts);
                continue;
            }
            if (att.equalsIgnoreCase(KEYWORD_REGEX)) {
                this.regex = this.getRequiredValue(attDef, parts);
                continue;
            }
            this.onInvalidAttributeDefinition(attDef);
        }
    }

    private void onInvalidAttributeDefinition(String attDef) {
        throw new OCommandSQLParsingException("Invalid attribute definition: '" + attDef + "'");
    }

    private boolean getOptionalBoolean(String[] parts) {
        if (parts.length < 2) {
            return true;
        }
        String trimmed = parts[1].trim();
        if (trimmed.length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(trimmed);
    }

    private String getRequiredValue(String attDef, String[] parts) {
        String value;
        if (parts.length < 2) {
            this.onInvalidAttributeDefinition(attDef);
        }
        if ((value = parts[1].trim()).length() == 0) {
            this.onInvalidAttributeDefinition(attDef);
        }
        if (value.equalsIgnoreCase("null")) {
            value = null;
        }
        if (value != null && this.isQuoted(value)) {
            value = this.removeQuotes(value);
        }
        return value;
    }

    private String[] split(StringBuilder word) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean quoted = false;
        for (char c : word.toString().toCharArray()) {
            if (!quoted) {
                if (c == '`') {
                    quoted = true;
                    continue;
                }
                if (c == '.') {
                    String nextToken = builder.toString().trim();
                    if (nextToken.length() > 0) {
                        result.add(nextToken);
                    }
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '`') {
                quoted = false;
                continue;
            }
            builder.append(c);
        }
        String nextToken = builder.toString().trim();
        if (nextToken.length() > 0) {
            result.add(nextToken);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.type == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateProperty.getDatabase();
        OClassImpl sourceClass = (OClassImpl)database.getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        OPropertyImpl prop = (OPropertyImpl)sourceClass.getProperty(this.fieldName);
        if (prop != null) {
            if (this.ifNotExists) {
                return sourceClass.properties().size();
            }
            throw new OCommandExecutionException("Property '" + this.className + "." + this.fieldName + "' already exists. Remove it before to retry.");
        }
        OClass linkedClass = null;
        OType linkedType = null;
        if (this.linked != null && (linkedClass = database.getMetadata().getSchema().getClass(this.linked)) == null) {
            linkedType = OType.valueOf(this.linked.toUpperCase(Locale.ENGLISH));
        }
        OPropertyImpl internalProp = sourceClass.addPropertyInternal(this.fieldName, this.type, linkedType, linkedClass, this.unsafe);
        if (this.readonly) {
            internalProp.setReadonly(true);
        }
        if (this.mandatory) {
            internalProp.setMandatory(true);
        }
        if (this.notnull) {
            internalProp.setNotNull(true);
        }
        if (this.max != null) {
            internalProp.setMax(this.max);
        }
        if (this.min != null) {
            internalProp.setMin(this.min);
        }
        if (this.defaultValue != null) {
            internalProp.setDefaultValue(this.defaultValue);
        }
        if (this.collate != null) {
            internalProp.setCollate(this.collate);
        }
        if (this.regex != null) {
            internalProp.setRegexp(this.regex);
        }
        return sourceClass.properties().size();
    }

    private String removeQuotes(String s2) {
        s2 = s2.trim();
        return s2.substring(1, s2.length() - 1).replaceAll("\\\\\"", "\"");
    }

    private boolean isQuoted(String s2) {
        if ((s2 = s2.trim()).startsWith("\"") && s2.endsWith("\"")) {
            return true;
        }
        if (s2.startsWith("'") && s2.endsWith("'")) {
            return true;
        }
        return s2.startsWith("`") && s2.endsWith("`");
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public String getUndoCommand() {
        return "drop property " + this.className + "." + this.fieldName;
    }

    @Override
    public String getSyntax() {
        return "CREATE PROPERTY <class>.<property> [IF NOT EXISTS] <type> [<linked-type>|<linked-class>] [(mandatory <true|false>, notnull <true|false>, <true|false>, default <value>, min <value>, max <value>)] [UNSAFE]";
    }
}

