/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.orient.core.sql.query.OBasicResultSet;
import com.orientechnologies.orient.core.sql.query.OResultSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OConcurrentResultSet<T>
implements OResultSet<T> {
    private final transient Object waitForNextItem = new Object();
    private final transient Object waitForCompletion = new Object();
    protected final transient OBasicResultSet<T> wrapped;
    protected volatile transient boolean completed = false;

    public OConcurrentResultSet(String query2) {
        this.wrapped = new OBasicResultSet(query2);
    }

    private OConcurrentResultSet(OBasicResultSet<T> wrapped) {
        this.wrapped = wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OConcurrentResultSet<T> setCompleted() {
        this.completed = true;
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
        object = this.waitForCompletion;
        synchronized (object) {
            this.waitForCompletion.notifyAll();
        }
        return this;
    }

    @Override
    public int getLimit() {
        return this.wrapped.getLimit();
    }

    @Override
    public OResultSet<T> setLimit(int limit) {
        return this.wrapped.setLimit(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet<T> copy() {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            OConcurrentResultSet<T> copy = new OConcurrentResultSet<T>(this.wrapped.copy());
            copy.completed = true;
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmptyNoWait() {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            this.wrapped.add(index, element);
        }
        this.notifyNewItem();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator() {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.listIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator(int index) {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.listIterator(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.subList(fromIndex, toIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.waitForCompletion();
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int currentSize() {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean empty;
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            empty = this.wrapped.isEmpty();
        }
        if (empty) {
            this.waitForNewItemOrCompleted();
            oBasicResultSet = this.wrapped;
            synchronized (oBasicResultSet) {
                empty = this.wrapped.isEmpty();
            }
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.waitForCompletion();
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.contains(o);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                int size;
                OBasicResultSet oBasicResultSet = OConcurrentResultSet.this.wrapped;
                synchronized (oBasicResultSet) {
                    size = OConcurrentResultSet.this.wrapped.size();
                }
                while (!OConcurrentResultSet.this.completed) {
                    if (this.index < size) {
                        return true;
                    }
                    OConcurrentResultSet.this.waitForNewItemOrCompleted();
                    oBasicResultSet = OConcurrentResultSet.this.wrapped;
                    synchronized (oBasicResultSet) {
                        size = OConcurrentResultSet.this.wrapped.size();
                    }
                }
                return this.index < OConcurrentResultSet.this.wrapped.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T next() {
                int size;
                OBasicResultSet oBasicResultSet = OConcurrentResultSet.this.wrapped;
                synchronized (oBasicResultSet) {
                    size = OConcurrentResultSet.this.wrapped.size();
                }
                while (!OConcurrentResultSet.this.completed && this.index >= size) {
                    OConcurrentResultSet.this.waitForNewItemOrCompleted();
                    oBasicResultSet = OConcurrentResultSet.this.wrapped;
                    synchronized (oBasicResultSet) {
                        size = OConcurrentResultSet.this.wrapped.size();
                    }
                }
                if (this.index > size || size == 0) {
                    throw new NoSuchElementException("Error on browsing at element " + this.index + " while the resultset contains only " + size + " items");
                }
                oBasicResultSet = OConcurrentResultSet.this.wrapped;
                synchronized (oBasicResultSet) {
                    return OConcurrentResultSet.this.wrapped.get(this.index++);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("OResultSet.iterator.remove()");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.waitForCompletion();
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T1> T1[] toArray(T1[] a) {
        this.waitForCompletion();
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t2) {
        boolean result;
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            result = this.wrapped.add(t2);
        }
        this.notifyNewItem();
        return result;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result;
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            result = this.wrapped.addAll(c);
        }
        this.notifyNewItem();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result;
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            result = this.wrapped.addAll(index, c);
        }
        this.notifyNewItem();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            this.wrapped.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            this.wrapped.writeExternal(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            this.wrapped.readExternal(in);
        }
        this.completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        OBasicResultSet<T> oBasicResultSet = this.wrapped;
        synchronized (oBasicResultSet) {
            return this.wrapped.equals(obj);
        }
    }

    public String toString() {
        return "size=" + this.wrapped.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion() {
        Object object = this.waitForCompletion;
        synchronized (object) {
            if (!this.completed) {
                try {
                    this.waitForCompletion.wait();
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNewItemOrCompleted() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            if (!this.completed) {
                try {
                    this.waitForNextItem.wait();
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewItem() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
    }
}

