/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.lock.OComparableLockManager;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OHighLevelException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.AtomicLongOProfilerHookValue;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationImpl;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainerSBTree;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.ORidBagDeleter;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerAbstract;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManagerShared;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.exception.OJVMErrorException;
import com.orientechnologies.orient.core.exception.OLowDiskSpaceException;
import com.orientechnologies.orient.core.exception.OPageIsBrokenException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.ORetryQueryException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OStorageExistsException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.engine.OHashTableIndexEngine;
import com.orientechnologies.orient.core.index.engine.OSBTreeIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.query.OQueryAbstract;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OIdentifiableStorage;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.OFullCheckpointRequestListener;
import com.orientechnologies.orient.core.storage.impl.local.OIndexEngineCallback;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.OPageIsBrokenListener;
import com.orientechnologies.orient.core.storage.impl.local.OStorageRecoverListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineCluster;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OOfflineClusterException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedCluster;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordOperationMetadata;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAbstractCheckPointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OAtomicUnitStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileCreatedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFileDeletedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFullCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointEndRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OFuzzyCheckpointStartRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OPaginatedClusterFactory;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OUpdatePageRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTxListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class OAbstractPaginatedStorage
extends OStorageAbstract
implements OLowDiskSpaceListener,
OFullCheckpointRequestListener,
OIdentifiableStorage,
OOrientStartupListener,
OOrientShutdownListener,
OBackgroundExceptionListener,
OPageIsBrokenListener {
    private static final int RECORD_LOCK_TIMEOUT = OGlobalConfiguration.STORAGE_RECORD_LOCK_TIMEOUT.getValueAsInteger();
    private static final int WAL_RESTORE_REPORT_INTERVAL = 30000;
    private final OComparableLockManager<ORID> lockManager;
    private final OLockManager<ORID> recordVersionManager;
    private final Map<String, OCluster> clusterMap = new HashMap<String, OCluster>();
    private List<OCluster> clusters = new ArrayList<OCluster>();
    private volatile ThreadLocal<OStorageTransaction> transaction = new ThreadLocal();
    private final AtomicBoolean checkpointInProgress = new AtomicBoolean();
    protected final OSBTreeCollectionManagerShared sbTreeCollectionManager;
    private final OPerformanceStatisticManager performanceStatisticManager = new OPerformanceStatisticManager(this, (long)OGlobalConfiguration.STORAGE_PROFILER_SNAPSHOT_INTERVAL.getValueAsInteger() * 1000000L, (long)OGlobalConfiguration.STORAGE_PROFILER_CLEANUP_INTERVAL.getValueAsInteger() * 1000000L);
    protected volatile OWriteAheadLog writeAheadLog;
    private OStorageRecoverListener recoverListener;
    protected volatile OReadCache readCache;
    protected volatile OWriteCache writeCache;
    private volatile ORecordConflictStrategy recordConflictStrategy = (ORecordConflictStrategy)Orient.instance().getRecordConflictStrategy().getDefaultImplementation();
    private volatile int defaultClusterId = -1;
    protected volatile OAtomicOperationsManager atomicOperationsManager;
    private volatile OLowDiskSpaceInformation lowDiskSpace = null;
    private volatile boolean checkpointRequest = false;
    private volatile Throwable dataFlushException = null;
    private final int id;
    private Map<String, OIndexEngine> indexEngineNameMap = new HashMap<String, OIndexEngine>();
    private List<OIndexEngine> indexEngines = new ArrayList<OIndexEngine>();
    private volatile long fullCheckpointCount;
    private final AtomicLong recordCreated = new AtomicLong(0L);
    private final AtomicLong recordUpdated = new AtomicLong(0L);
    private final AtomicLong recordRead = new AtomicLong(0L);
    private final AtomicLong recordDeleted = new AtomicLong(0L);
    private final AtomicLong recordScanned = new AtomicLong(0L);
    private final AtomicLong recordRecycled = new AtomicLong(0L);
    private final AtomicLong recordConflict = new AtomicLong(0L);
    private final AtomicLong txBegun = new AtomicLong(0L);
    private final AtomicLong txCommit = new AtomicLong(0L);
    private final AtomicLong txRollback = new AtomicLong(0L);
    private final AtomicReference<Error> jvmError = new AtomicReference();
    private final Set<OPair<String, Long>> brokenPages = Collections.newSetFromMap(new ConcurrentHashMap());

    public OAbstractPaginatedStorage(String name, String filePath, String mode, int id) {
        super(name, filePath, mode, new OReadersWriterSpinLock());
        this.id = id;
        this.lockManager = new ORIDOLockManager(OGlobalConfiguration.COMPONENTS_LOCK_CACHE.getValueAsInteger());
        this.recordVersionManager = new OPartitionedLockManager<ORID>();
        this.registerProfilerHooks();
        this.sbTreeCollectionManager = new OSBTreeCollectionManagerShared(this);
    }

    private void registerProfilerHooks() {
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".createRecord", "Number of created records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordCreated), "db.*.createRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".readRecord", "Number of read records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordRead), "db.*.readRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".updateRecord", "Number of updated records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordUpdated), "db.*.updateRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".deleteRecord", "Number of deleted records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordDeleted), "db.*.deleteRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".scanRecord", "Number of read scanned", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordScanned), "db.*.scanRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".recyclePosition", "Number of recycled records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordRecycled), "db.*.recyclePosition");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".conflictRecord", "Number of conflicts during updating and deleting records", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.recordConflict), "db.*.conflictRecord");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txBegun", "Number of transactions begun", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.txBegun), "db.*.txBegun");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txCommit", "Number of committed transactions", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.txCommit), "db.*.txCommit");
        Orient.instance().getProfiler().registerHookValue("db." + this.name + ".txRollback", "Number of rolled back transactions", OProfiler.METRIC_TYPE.COUNTER, new AtomicLongOProfilerHookValue(this.txRollback), "db.*.txRollback");
    }

    public void underDistributedStorage() {
        this.sbTreeCollectionManager.prohibitAccess();
    }

    private void handleJVMError(Error e) {
        this.jvmError.compareAndSet(null, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        try {
            this.stateLock.acquireReadLock();
            try {
                if (this.status == OStorage.STATUS.OPEN) {
                    return;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
            this.stateLock.acquireWriteLock();
            try {
                if (this.status == OStorage.STATUS.OPEN) {
                    return;
                }
                if (!this.exists()) {
                    throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
                }
                ((OStorageConfigurationImpl)this.configuration).load(iProperties);
                this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
                this.preOpenSteps();
                try {
                    this.performanceStatisticManager.registerMBean(this.name, this.id);
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for profiler cannot be registered.", e, new Object[0]);
                }
                this.initWalAndDiskCache();
                this.atomicOperationsManager = new OAtomicOperationsManager(this);
                try {
                    this.atomicOperationsManager.registerMBean();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for atomic operations manager cannot be registered", e, new Object[0]);
                }
                this.recoverIfNeeded();
                this.openClusters();
                this.openIndexes();
                this.writeCache.startFuzzyCheckpoints();
                this.status = OStorage.STATUS.OPEN;
                String cs = this.configuration.getConflictStrategy();
                if (cs != null) {
                    this.setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(cs));
                }
                this.readCache.loadCacheState(this.writeCache);
            }
            catch (Exception e) {
                for (OCluster c : this.clusters) {
                    try {
                        if (c == null) continue;
                        c.close(false);
                    }
                    catch (IOException e1) {
                        OLogManager.instance().error(this, "Cannot close cluster after exception on open", e1, new Object[0]);
                    }
                }
                try {
                    this.status = OStorage.STATUS.OPEN;
                    this.close(true, false);
                }
                catch (RuntimeException re) {
                    OLogManager.instance().error(this, "Error during storage close", re, new Object[0]);
                }
                this.status = OStorage.STATUS.CLOSED;
                throw OException.wrapException(new OStorageException("Cannot open local storage '" + this.url + "' with mode=" + this.mode), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        OLogManager.instance().infoNoDb(this, "Storage '%s' is opened under OrientDB distribution : %s", this.getURL(), OConstants.getVersion());
    }

    protected void openIndexes() {
        OCurrentStorageComponentsFactory cf = this.componentsFactory;
        if (cf == null) {
            throw new OStorageException("Storage '" + this.name + "' is not properly initialized");
        }
        Set<String> indexNames = this.configuration.indexEngines();
        for (String indexName : indexNames) {
            OStorageConfigurationImpl.IndexEngineData engineData = this.configuration.getIndexEngine(indexName);
            OIndexEngine engine = OIndexes.createIndexEngine(engineData.getName(), engineData.getAlgorithm(), engineData.getIndexType(), engineData.getDurableInNonTxMode(), this, engineData.getVersion(), engineData.getEngineProperties(), null);
            try {
                engine.load(engineData.getName(), cf.binarySerializerFactory.getObjectSerializer(engineData.getValueSerializerId()), engineData.isAutomatic(), cf.binarySerializerFactory.getObjectSerializer(engineData.getKeySerializedId()), engineData.getKeyTypes(), engineData.isNullValuesSupport(), engineData.getKeySize(), engineData.getEngineProperties());
                this.indexEngineNameMap.put(engineData.getName().toLowerCase(this.configuration.getLocaleInstance()), engine);
                this.indexEngines.add(engine);
            }
            catch (RuntimeException e) {
                OLogManager.instance().error(this, "Index '" + engineData.getName() + "' cannot be created and will be removed from configuration", e, new Object[0]);
                engine.deleteWithoutLoad(engineData.getName());
            }
        }
    }

    protected void openClusters() throws IOException {
        this.addDefaultClusters();
        List<OStorageClusterConfiguration> configurationsClusters = this.configuration.getClusters();
        for (int i = 0; i < configurationsClusters.size(); ++i) {
            OStorageClusterConfiguration clusterConfig = configurationsClusters.get(i);
            if (clusterConfig != null) {
                int pos = this.createClusterFromConfig(clusterConfig);
                try {
                    if (pos == -1) {
                        this.clusters.get(i).open();
                        continue;
                    }
                    if (clusterConfig.getName().equals("default")) {
                        this.defaultClusterId = pos;
                    }
                    this.clusters.get(pos).open();
                }
                catch (FileNotFoundException e) {
                    OLogManager.instance().warn((Object)this, "Error on loading cluster '" + this.clusters.get(i).getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", e, new Object[0]);
                    this.clusterMap.remove(this.clusters.get(i).getName().toLowerCase(this.configuration.getLocaleInstance()));
                    this.setCluster(i, null);
                }
                continue;
            }
            this.setCluster(i, null);
        }
    }

    public void open(OToken iToken, Map<String, Object> iProperties) {
        try {
            this.open(iToken.getUserName(), "", iProperties);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        try {
            this.stateLock.acquireWriteLock();
            try {
                String encryptionKey;
                if (this.status != OStorage.STATUS.CLOSED) {
                    throw new OStorageExistsException("Cannot create new storage '" + this.getURL() + "' because it is not closed");
                }
                if (this.exists()) {
                    throw new OStorageExistsException("Cannot create new storage '" + this.getURL() + "' because it already exists");
                }
                if (!this.configuration.getContextConfiguration().getContextKeys().contains(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getKey())) {
                    String compression;
                    String string = compression = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getKey().toLowerCase(this.configuration.getLocaleInstance())) : null;
                    if (compression != null) {
                        this.configuration.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, (Object)compression);
                    } else {
                        this.configuration.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getValue());
                    }
                }
                if (!this.configuration.getContextConfiguration().getContextKeys().contains(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD.getKey())) {
                    String encryption;
                    String string = encryption = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD.getKey().toLowerCase(this.configuration.getLocaleInstance())) : null;
                    if (encryption != null) {
                        this.configuration.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, (Object)encryption);
                    } else {
                        this.configuration.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD.getValue());
                    }
                }
                String string = encryptionKey = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getKey().toLowerCase(this.configuration.getLocaleInstance())) : null;
                if (encryptionKey != null) {
                    this.configuration.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, (Object)encryptionKey);
                } else {
                    this.configuration.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getValue());
                }
                this.componentsFactory = new OCurrentStorageComponentsFactory(this.configuration);
                try {
                    this.performanceStatisticManager.registerMBean(this.name, this.id);
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for profiler cannot be registered.", e, new Object[0]);
                }
                this.initWalAndDiskCache();
                this.atomicOperationsManager = new OAtomicOperationsManager(this);
                try {
                    this.atomicOperationsManager.registerMBean();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for atomic operations manager cannot be registered", e, new Object[0]);
                }
                this.preCreateSteps();
                this.status = OStorage.STATUS.OPEN;
                this.doAddCluster("internal", null);
                ((OStorageConfigurationImpl)this.configuration).create();
                ((OStorageConfigurationImpl)this.configuration).setCreationVersion(OConstants.getVersion());
                this.doAddCluster("index", null);
                this.doAddCluster("manindex", null);
                this.defaultClusterId = this.doAddCluster("default", null);
                if (OGlobalConfiguration.STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CREATE.getValueAsBoolean()) {
                    this.makeFullCheckpoint();
                }
                this.clearStorageDirty();
                this.writeCache.startFuzzyCheckpoints();
                this.postCreateSteps();
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw OException.wrapException(new OStorageException("Error on creation of storage '" + this.name + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        OLogManager.instance().infoNoDb(this, "Storage '%s' is created under OrientDB distribution : %s", this.getURL(), OConstants.getVersion());
    }

    @Override
    public boolean isClosed() {
        this.stateLock.acquireReadLock();
        try {
            boolean bl = super.isClosed();
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    @Override
    public void onShutdown() {
        try {
            this.transaction = null;
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public void onStartup() {
        try {
            if (this.transaction == null) {
                this.transaction = new ThreadLocal();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public void close(boolean force, boolean onDelete) {
        try {
            this.doClose(force, onDelete);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public void delete() {
        try {
            this.stateLock.acquireWriteLock();
            try {
                try {
                    this.close(true, true);
                    try {
                        Orient.instance().unregisterStorage(this);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Cannot unregister storage", e, new Object[0]);
                    }
                    if (this.writeAheadLog != null) {
                        this.writeAheadLog.delete();
                    }
                    if (this.writeCache != null) {
                        if (this.readCache != null) {
                            this.readCache.deleteStorage(this.writeCache);
                        } else {
                            this.writeCache.delete();
                        }
                    }
                    this.postDeleteSteps();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Cannot delete database '" + this.name + "'"), e);
                }
            }
            finally {
                this.stateLock.releaseWriteLock();
                Orient.instance().getProfiler().updateCounter("db." + this.name + ".drop", "Drop a database", 1L, "db.*.drop");
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean check(boolean verbose, OCommandOutputListener listener) {
        this.checkOpeness();
        listener.onMessage("Check of storage is started...");
        try {
            this.stateLock.acquireReadLock();
            try {
                long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
                try {
                    this.checkOpeness();
                    long start = System.currentTimeMillis();
                    OPageDataVerificationError[] pageErrors = this.writeCache.checkStoredPages(verbose ? listener : null);
                    listener.onMessage("Check of storage completed in " + (System.currentTimeMillis() - start) + "ms. " + (pageErrors.length > 0 ? pageErrors.length + " with errors." : " without errors."));
                    boolean bl = pageErrors.length == 0;
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    throw throwable;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addCluster(String clusterName, boolean forceListBased, Object ... parameters) {
        try {
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpeness();
                this.makeStorageDirty();
                int n = this.doAddCluster(clusterName, parameters);
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error in creation of new cluster '" + clusterName), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public void compactCluster(String clusterName) {
        try {
            OCluster cluster = this.getClusterByName(clusterName);
            if (cluster == null) {
                throw new OStorageException("Cluster with name `" + clusterName + "` does not exist");
            }
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpeness();
                this.makeStorageDirty();
                cluster.compact();
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error during compaction of new cluster '" + clusterName), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int addCluster(String clusterName, int requestedId, boolean forceListBased, Object ... parameters) {
        try {
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpeness();
                if (requestedId < 0) {
                    throw new OConfigurationException("Cluster id must be positive!");
                }
                if (requestedId < this.clusters.size() && this.clusters.get(requestedId) != null) {
                    throw new OConfigurationException("Requested cluster ID [" + requestedId + "] is occupied by cluster with name [" + this.clusters.get(requestedId).getName() + "]");
                }
                this.makeStorageDirty();
                int n = this.addClusterInternal(clusterName, requestedId, parameters);
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error in creation of new cluster '" + clusterName + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean dropCluster(int clusterId, boolean iTruncate) {
        try {
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpeness();
                if (clusterId < 0) throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                if (clusterId >= this.clusters.size()) {
                    throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                }
                OCluster cluster = this.clusters.get(clusterId);
                if (cluster == null) {
                    boolean bl = false;
                    return bl;
                }
                if (iTruncate) {
                    cluster.truncate();
                }
                cluster.delete();
                this.makeStorageDirty();
                this.clusterMap.remove(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()));
                this.clusters.set(clusterId, null);
                ((OStorageConfigurationImpl)this.configuration).dropCluster(clusterId);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw OException.wrapException(new OStorageException("Error while removing cluster '" + clusterId + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setClusterStatus(int clusterId, OStorageClusterConfiguration.STATUS iStatus) {
        try {
            this.checkOpeness();
            this.stateLock.acquireWriteLock();
            try {
                OCluster newCluster;
                this.checkOpeness();
                if (clusterId < 0) throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                if (clusterId >= this.clusters.size()) {
                    throw new IllegalArgumentException("Cluster id '" + clusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.size() - 1) + ") in database '" + this.name + "'");
                }
                OCluster cluster = this.clusters.get(clusterId);
                if (cluster == null) {
                    boolean bl = false;
                    return bl;
                }
                if (iStatus == OStorageClusterConfiguration.STATUS.OFFLINE && cluster instanceof OOfflineCluster || iStatus == OStorageClusterConfiguration.STATUS.ONLINE && !(cluster instanceof OOfflineCluster)) {
                    boolean bl = false;
                    return bl;
                }
                if (iStatus == OStorageClusterConfiguration.STATUS.OFFLINE) {
                    cluster.close(true);
                    newCluster = new OOfflineCluster(this, clusterId, cluster.getName());
                } else {
                    newCluster = OPaginatedClusterFactory.INSTANCE.createCluster(cluster.getName(), this.configuration.getVersion(), this);
                    newCluster.configure(this, clusterId, cluster.getName(), new Object[0]);
                    newCluster.open();
                }
                this.clusterMap.put(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()), newCluster);
                this.clusters.set(clusterId, newCluster);
                this.makeStorageDirty();
                ((OStorageConfigurationImpl)this.configuration).setClusterStatus(clusterId, iStatus);
                this.makeFullCheckpoint();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw OException.wrapException(new OStorageException("Error while removing cluster '" + clusterId + "'"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.sbTreeCollectionManager;
    }

    public OReadCache getReadCache() {
        return this.readCache;
    }

    public OWriteCache getWriteCache() {
        return this.writeCache;
    }

    @Override
    public long count(int iClusterId) {
        try {
            return this.count(iClusterId, false);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long count(int clusterId, boolean countTombstones) {
        try {
            if (clusterId == -1) {
                throw new OStorageException("Cluster Id " + clusterId + " is invalid in database '" + this.name + "'");
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                OCluster cluster = this.clusters.get(clusterId);
                if (cluster == null) {
                    long l = 0L;
                    return l;
                }
                if (countTombstones) {
                    long l = cluster.getEntries();
                    return l;
                }
                long l = cluster.getEntries() - cluster.getTombstonesCount();
                return l;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] getClusterDataRange(int iClusterId) {
        try {
            if (iClusterId == -1) {
                return new long[]{-1L, -1L};
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                long[] lArray;
                this.checkOpeness();
                if (this.clusters.get(iClusterId) != null) {
                    long[] lArray2 = new long[2];
                    lArray2[0] = this.clusters.get(iClusterId).getFirstPosition();
                    lArray = lArray2;
                    lArray2[1] = this.clusters.get(iClusterId).getLastPosition();
                } else {
                    lArray = OCommonConst.EMPTY_LONG_ARRAY;
                }
                long[] lArray3 = lArray;
                return lArray3;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cannot retrieve information about data range"), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public OLogSequenceNumber getLSN() {
        try {
            if (this.writeAheadLog == null) {
                return null;
            }
            return this.writeAheadLog.end();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public long count(int[] iClusterIds) {
        try {
            return this.count(iClusterIds, false);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OLogSequenceNumber recordsChangedAfterLSN(OLogSequenceNumber lsn, OutputStream stream, Set<String> includeClusterNames, OCommandOutputListener outputListener) {
        try {
            if (!OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getValueAsBoolean()) {
                throw new IllegalStateException("Cannot find records which were changed starting from provided LSN because tracking of rids of changed records in WAL is switched off, to switch it on please set property " + OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getKey() + " to the true value, please note that only records which are stored after this property was set will be retrieved");
            }
            this.stateLock.acquireReadLock();
            try {
                if (this.writeAheadLog == null) {
                    OLogSequenceNumber oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                OLogSequenceNumber endLsn = this.writeAheadLog.end();
                if (endLsn == null || lsn.compareTo(endLsn) > 0) {
                    OLogManager.instance().warn((Object)this, "Cannot find requested LSN=%s for database sync operation. Last available LSN is %s", lsn, endLsn);
                    OLogSequenceNumber oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                if (lsn.equals(endLsn)) {
                    OLogSequenceNumber oLogSequenceNumber = endLsn;
                    return oLogSequenceNumber;
                }
                TreeSet<ORID> sortedRids = new TreeSet<ORID>();
                OLogSequenceNumber startLsn = this.writeAheadLog.next(lsn);
                if (startLsn == null) {
                    OLogManager.instance().info((Object)this, "Cannot find requested LSN=%s for database sync operation (last available LSN is %s)", lsn, endLsn);
                    OLogSequenceNumber oLogSequenceNumber = null;
                    return oLogSequenceNumber;
                }
                OLogSequenceNumber freezeLSN = startLsn;
                this.writeAheadLog.addCutTillLimit(freezeLSN);
                try {
                    startLsn = this.writeAheadLog.next(lsn);
                    if (startLsn == null) {
                        OLogManager.instance().info((Object)this, "Cannot find requested LSN=%s for database sync operation (last available LSN is %s)", lsn, endLsn);
                        OLogSequenceNumber oLogSequenceNumber = null;
                        return oLogSequenceNumber;
                    }
                    OWALRecord walRecord = this.writeAheadLog.read(startLsn);
                    if (walRecord == null) {
                        OLogManager.instance().info((Object)this, "Cannot find requested LSN=%s for database sync operation (record in WAL is absent)", lsn);
                        OLogSequenceNumber oLogSequenceNumber = null;
                        return oLogSequenceNumber;
                    }
                    OLogSequenceNumber currentLsn = startLsn;
                    long read = 0L;
                    while (currentLsn != null && endLsn.compareTo(currentLsn) >= 0) {
                        OAtomicUnitEndRecord atomicUnitEndRecord;
                        walRecord = this.writeAheadLog.read(currentLsn);
                        if (walRecord instanceof OFileCreatedWALRecord) {
                            throw new ODatabaseException("Cannot execute delta-sync because a new file has been added. Filename: '" + ((OFileCreatedWALRecord)walRecord).getFileName() + "' (id=" + ((OFileCreatedWALRecord)walRecord).getFileId() + ")");
                        }
                        if (walRecord instanceof OFileDeletedWALRecord) {
                            throw new ODatabaseException("Cannot execute delta-sync because a file has been deleted. File id: " + ((OFileDeletedWALRecord)walRecord).getFileId());
                        }
                        if (walRecord instanceof OAtomicUnitEndRecord && (atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord).getAtomicOperationMetadata().containsKey("rid")) {
                            ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)atomicUnitEndRecord.getAtomicOperationMetadata().get("rid");
                            Object rids = recordOperationMetadata.getValue();
                            Iterator iterator = rids.iterator();
                            while (iterator.hasNext()) {
                                ORID rid = (ORID)iterator.next();
                                sortedRids.add(rid);
                            }
                        }
                        currentLsn = this.writeAheadLog.next(currentLsn);
                        ++read;
                        if (outputListener == null) continue;
                        outputListener.onMessage("read " + read + " records from WAL and collected " + sortedRids.size() + " records");
                    }
                }
                finally {
                    this.writeAheadLog.removeCutTillLimit(freezeLSN);
                }
                int totalRecords = sortedRids.size();
                OLogManager.instance().info((Object)this, "Exporting records after LSN=%s. Found %d records", lsn, totalRecords);
                long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(stream);
                    try {
                        OCluster cluster;
                        dataOutputStream.writeLong(sortedRids.size());
                        long exportedRecord = 1L;
                        Iterator ridIterator = sortedRids.iterator();
                        while (ridIterator.hasNext()) {
                            ORID rid = (ORID)ridIterator.next();
                            cluster = this.clusters.get(rid.getClusterId());
                            if (cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition())) != null) continue;
                            dataOutputStream.writeInt(rid.getClusterId());
                            dataOutputStream.writeLong(rid.getClusterPosition());
                            dataOutputStream.write(1);
                            OLogManager.instance().debug((Object)this, "Exporting deleted record %s", rid);
                            if (outputListener != null) {
                                outputListener.onMessage("exporting record " + exportedRecord + "/" + totalRecords);
                            }
                            ridIterator.remove();
                            ++exportedRecord;
                        }
                        for (ORID rid : sortedRids) {
                            cluster = this.clusters.get(rid.getClusterId());
                            dataOutputStream.writeInt(rid.getClusterId());
                            dataOutputStream.writeLong(rid.getClusterPosition());
                            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
                            if (ppos == null || ppos == OPaginatedCluster.NO_POSITION) {
                                dataOutputStream.writeBoolean(true);
                                OLogManager.instance().debug((Object)this, "Exporting non existent record %s", rid);
                            } else {
                                ORawBuffer rawBuffer = cluster.readRecord(rid.getClusterPosition(), false);
                                assert (rawBuffer != null);
                                dataOutputStream.writeBoolean(false);
                                dataOutputStream.writeInt(rawBuffer.version);
                                dataOutputStream.write(rawBuffer.recordType);
                                dataOutputStream.writeInt(rawBuffer.buffer.length);
                                dataOutputStream.write(rawBuffer.buffer);
                                OLogManager.instance().debug((Object)this, "Exporting modified record rid=%s type=%d size=%d v=%d - buffer size=%d", rid, rawBuffer.recordType, rawBuffer.buffer.length, rawBuffer.version, dataOutputStream.size());
                            }
                            if (outputListener != null) {
                                outputListener.onMessage("exporting record " + exportedRecord + "/" + totalRecords);
                            }
                            ++exportedRecord;
                        }
                    }
                    finally {
                        dataOutputStream.close();
                    }
                }
                finally {
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                }
                OLogSequenceNumber oLogSequenceNumber = endLsn;
                return oLogSequenceNumber;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error on reading changed records after LSN " + lsn), e);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Set<ORecordId> recordsChangedRecently(int maxEntries, Set<String> includeClusterNames) {
        TreeSet<ORecordId> result = new TreeSet<ORecordId>();
        try {
            if (!OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getValueAsBoolean()) {
                throw new IllegalStateException("Cannot find records which were changed starting from provided LSN because tracking of rids of changed records in WAL is switched off, to switch it on please set property " + OGlobalConfiguration.STORAGE_TRACK_CHANGED_RECORDS_IN_WAL.getKey() + " to the true value, please note that only records which are stored after this property was set will be retrieved");
            }
            this.stateLock.acquireReadLock();
            try {
                OWALRecord walRecord;
                OLogSequenceNumber endLsn;
                OLogSequenceNumber freezeLSN;
                OLogSequenceNumber startLsn;
                block30: {
                    block29: {
                        block28: {
                            if (this.writeAheadLog == null) {
                                OLogManager.instance().warn((Object)this, "No WAL found for database '%s'", this.name);
                                Set<ORecordId> set = null;
                                return set;
                            }
                            startLsn = this.writeAheadLog.begin();
                            if (startLsn == null) {
                                OLogManager.instance().warn((Object)this, "The WAL is empty for database '%s'", this.name);
                                TreeSet<ORecordId> treeSet = result;
                                return treeSet;
                            }
                            freezeLSN = startLsn;
                            this.writeAheadLog.addCutTillLimit(freezeLSN);
                            startLsn = this.writeAheadLog.begin();
                            if (startLsn != null) break block28;
                            OLogManager.instance().warn((Object)this, "The WAL is empty for database '%s'", this.name);
                            TreeSet<ORecordId> treeSet = result;
                            this.writeAheadLog.removeCutTillLimit(freezeLSN);
                            return treeSet;
                        }
                        endLsn = this.writeAheadLog.end();
                        if (endLsn != null) break block29;
                        OLogManager.instance().warn((Object)this, "The WAL is empty for database '%s'", this.name);
                        TreeSet<ORecordId> treeSet = result;
                        this.writeAheadLog.removeCutTillLimit(freezeLSN);
                        return treeSet;
                    }
                    walRecord = this.writeAheadLog.read(startLsn);
                    if (walRecord != null) break block30;
                    OLogManager.instance().info((Object)this, "Cannot find requested LSN=%s for database sync operation (record in WAL is absent)", startLsn);
                    Set<ORecordId> set = null;
                    this.writeAheadLog.removeCutTillLimit(freezeLSN);
                    return set;
                }
                try {
                    OLogSequenceNumber currentLsn = startLsn;
                    LinkedList<OLogSequenceNumber> lastTx = new LinkedList<OLogSequenceNumber>();
                    while (currentLsn != null && endLsn.compareTo(currentLsn) >= 0) {
                        walRecord = this.writeAheadLog.read(currentLsn);
                        if (walRecord instanceof OAtomicUnitEndRecord) {
                            if (lastTx.size() >= maxEntries) {
                                lastTx.remove(0);
                            }
                            lastTx.add(currentLsn);
                        }
                        currentLsn = this.writeAheadLog.next(currentLsn);
                    }
                    for (OLogSequenceNumber lsn : lastTx) {
                        walRecord = this.writeAheadLog.read(lsn);
                        OAtomicUnitEndRecord atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord;
                        if (!atomicUnitEndRecord.getAtomicOperationMetadata().containsKey("rid")) continue;
                        ORecordOperationMetadata recordOperationMetadata = (ORecordOperationMetadata)atomicUnitEndRecord.getAtomicOperationMetadata().get("rid");
                        Object rids = recordOperationMetadata.getValue();
                        Iterator iterator = rids.iterator();
                        while (iterator.hasNext()) {
                            ORID rid = (ORID)iterator.next();
                            result.add((ORecordId)rid);
                        }
                    }
                    OLogManager.instance().info((Object)this, "Found %d records changed in last %d operations", result.size(), lastTx.size());
                    TreeSet<ORecordId> treeSet = result;
                    this.writeAheadLog.removeCutTillLimit(freezeLSN);
                    return treeSet;
                }
                catch (Throwable throwable) {
                    try {
                        this.writeAheadLog.removeCutTillLimit(freezeLSN);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw OException.wrapException(new OStorageException("Error on reading last changed records"), e);
                    }
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds, boolean countTombstones) {
        this.checkOpeness();
        long tot = 0L;
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            for (int iClusterId : iClusterIds) {
                OCluster c;
                if (iClusterId >= this.clusters.size()) {
                    throw new OConfigurationException("Cluster id " + iClusterId + " was not found in database '" + this.name + "'");
                }
                if (iClusterId <= -1 || (c = this.clusters.get(iClusterId)) == null) continue;
                tot += c.getEntries() - (countTombstones ? 0L : c.getTombstonesCount());
            }
            long l = tot;
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageOperationResult<OPhysicalPosition> createRecord(ORecordId rid, byte[] content, int recordVersion, byte recordType, int mode, ORecordCallback<Long> callback) {
        this.checkOpeness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        OPhysicalPosition ppos = new OPhysicalPosition(recordType);
        OCluster cluster = this.getClusterById(rid.getClusterId());
        if (this.transaction.get() != null) {
            return this.doCreateRecord(rid, content, recordVersion, recordType, callback, cluster, ppos, null);
        }
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OStorageOperationResult<OPhysicalPosition> oStorageOperationResult = this.doCreateRecord(rid, content, recordVersion, recordType, callback, cluster, ppos, null);
            this.stateLock.releaseReadLock();
            return oStorageOperationResult;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ORecordMetadata getRecordMetadata(ORID rid) {
        try {
            if (rid.isNew()) {
                throw new OStorageException("Passed record with id " + rid + " is new and cannot be stored.");
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                OCluster cluster = this.getClusterById(rid.getClusterId());
                this.checkOpeness();
                OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
                if (ppos == null) {
                    ORecordMetadata oRecordMetadata = null;
                    return oRecordMetadata;
                }
                ORecordMetadata oRecordMetadata = new ORecordMetadata(rid, ppos.recordVersion);
                return oRecordMetadata;
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Retrieval of record  '" + rid + "' cause: " + ioe.getMessage(), ioe, new Object[0]);
                return null;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, boolean prefetchRecords, ORecordCallback<ORawBuffer> iCallback) {
        try {
            OCluster cluster;
            this.checkOpeness();
            try {
                cluster = this.getClusterById(iRid.getClusterId());
            }
            catch (IllegalArgumentException e) {
                throw OException.wrapException(new ORecordNotFoundException(iRid), e);
            }
            return new OStorageOperationResult<ORawBuffer>(this.readRecord(cluster, iRid, prefetchRecords));
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(ORecordId rid, String fetchPlan, boolean ignoreCache, int recordVersion) throws ORecordNotFoundException {
        try {
            this.checkOpeness();
            return new OStorageOperationResult<ORawBuffer>(this.readRecordIfNotLatest(this.getClusterById(rid.getClusterId()), rid, recordVersion));
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageOperationResult<Integer> updateRecord(ORecordId rid, boolean updateContent, byte[] content, int version, byte recordType, int mode, ORecordCallback<Integer> callback) {
        try {
            OStorageOperationResult<Integer> result;
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            if (this.transaction.get() != null) {
                result = this.doUpdateRecord(rid, updateContent, content, version, recordType, callback, cluster);
            } else {
                this.stateLock.acquireReadLock();
                try {
                    Lock lock = this.recordVersionManager.acquireExclusiveLock(rid);
                    try {
                        this.checkOpeness();
                        result = this.doUpdateRecord(rid, updateContent, content, version, recordType, callback, cluster);
                    }
                    finally {
                        lock.unlock();
                    }
                }
                finally {
                    this.stateLock.releaseReadLock();
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recyclePosition(ORecordId record, byte[] content, int recordVersion, byte recordType) {
        try {
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            ORecordId rid = (ORecordId)record.getIdentity();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            OPhysicalPosition ppos = new OPhysicalPosition(recordType);
            OPhysicalPosition allocated = new OPhysicalPosition(record.getClusterPosition());
            if (this.transaction.get() != null) {
                this.doRecycleRecord(rid, cluster);
                this.doCreateRecord(rid, content, recordVersion, recordType, null, cluster, ppos, allocated);
                return;
            }
            this.stateLock.acquireReadLock();
            try {
                Lock lock = this.recordVersionManager.acquireExclusiveLock(rid);
                try {
                    this.checkOpeness();
                    this.doRecycleRecord(rid, cluster);
                    this.doCreateRecord(rid, content, recordVersion, recordType, null, cluster, ppos, allocated);
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public OStorageTransaction getStorageTransaction() {
        try {
            return this.transaction.get();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public OAtomicOperationsManager getAtomicOperationsManager() {
        return this.atomicOperationsManager;
    }

    public OWriteAheadLog getWALInstance() {
        return this.writeAheadLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageOperationResult<Boolean> deleteRecord(ORecordId rid, int version, int mode, ORecordCallback<Boolean> callback) {
        this.checkOpeness();
        this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
        OCluster cluster = this.getClusterById(rid.getClusterId());
        if (this.transaction.get() != null) {
            return this.doDeleteRecord(rid, version, cluster);
        }
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OStorageOperationResult<Boolean> oStorageOperationResult = this.doDeleteRecord(rid, version, cluster);
            this.stateLock.releaseReadLock();
            return oStorageOperationResult;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public OStorageOperationResult<Boolean> hideRecord(ORecordId rid, int mode, ORecordCallback<Boolean> callback) {
        try {
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            OCluster cluster = this.getClusterById(rid.getClusterId());
            if (this.transaction.get() != null) {
                return this.doHideMethod(rid, cluster);
            }
            this.stateLock.acquireReadLock();
            try {
                Lock lock = this.recordVersionManager.acquireExclusiveLock(rid);
                try {
                    this.checkOpeness();
                    OStorageOperationResult<Boolean> oStorageOperationResult = this.doHideMethod(rid, cluster);
                    lock.unlock();
                    return oStorageOperationResult;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public OPerformanceStatisticManager getPerformanceStatisticManager() {
        return this.performanceStatisticManager;
    }

    public void startGatheringPerformanceStatisticForCurrentThread() {
        try {
            this.performanceStatisticManager.startThreadMonitoring();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public OSessionStoragePerformanceStatistic completeGatheringPerformanceStatisticForCurrentThread() {
        try {
            return this.performanceStatisticManager.stopThreadMonitoring();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        try {
            this.stateLock.acquireReadLock();
            try {
                if (iExclusiveLock) {
                    V v = super.callInLock(iCallable, true);
                    return v;
                }
                V v = super.callInLock(iCallable, false);
                return v;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public Set<String> getClusterNames() {
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.clusterMap.keySet());
            this.stateLock.releaseReadLock();
            return linkedHashSet;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getClusterIdByName(String clusterName) {
        try {
            this.checkOpeness();
            if (clusterName == null) {
                throw new IllegalArgumentException("Cluster name is null");
            }
            if (clusterName.length() == 0) {
                throw new IllegalArgumentException("Cluster name is empty");
            }
            if (Character.isDigit(clusterName.charAt(0))) {
                return Integer.parseInt(clusterName);
            }
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                OCluster segment = this.clusterMap.get(clusterName.toLowerCase(this.configuration.getLocaleInstance()));
                if (segment != null) {
                    int n = segment.getId();
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ORecordOperation> commit(OTransaction clientTx, Runnable callback) {
        try {
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            this.txBegun.incrementAndGet();
            ODatabaseDocumentInternal databaseRecord = (ODatabaseDocumentInternal)clientTx.getDatabase();
            OIndexManagerProxy indexManager = databaseRecord.getMetadata().getIndexManager();
            TreeMap<String, OTransactionIndexChanges> indexesToCommit = this.getSortedIndexEntries(clientTx);
            IdentityHashMap<ORecordOperation, Integer> clusterOverrides = new IdentityHashMap<ORecordOperation, Integer>();
            databaseRecord.getMetadata().makeThreadLocalSchemaSnapshot();
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Committing transaction %d on database '%s' (items=%d thread=%d)...", clientTx.getId(), databaseRecord.getName(), clientTx.getEntryCount(), Thread.currentThread().getId());
            }
            Iterable<? extends ORecordOperation> entries = clientTx.getAllRecordEntries();
            TreeMap<Integer, OCluster> clustersToLock = new TreeMap<Integer, OCluster>();
            TreeSet<ORecordOperation> newRecords = new TreeSet<ORecordOperation>(new Comparator<ORecordOperation>(){

                @Override
                public int compare(ORecordOperation o1, ORecordOperation o2) {
                    return o1.getRecord().getIdentity().compareTo(o2.getRecord().getIdentity());
                }
            });
            for (ORecordOperation oRecordOperation : entries) {
                OImmutableClass oImmutableClass;
                ORecord record;
                if ((oRecordOperation.type == 3 || oRecordOperation.type == 4 || oRecordOperation.type == 1) && (record = oRecordOperation.getRecord()) instanceof ODocument) {
                    ((ODocument)record).validate();
                }
                if (oRecordOperation.type == 1 || oRecordOperation.type == 2) {
                    int clusterId = oRecordOperation.getRecord().getIdentity().getClusterId();
                    clustersToLock.put(clusterId, this.getClusterById(clusterId));
                    continue;
                }
                if (oRecordOperation.type != 3 && oRecordOperation.type != 4) continue;
                newRecords.add(oRecordOperation);
                record = oRecordOperation.getRecord();
                ORID rid = record.getIdentity();
                int clusterId = rid.getClusterId();
                if (record.isDirty() && clusterId == -1 && record instanceof ODocument && (oImmutableClass = ODocumentInternal.getImmutableSchemaClass((ODocument)record)) != null) {
                    clusterId = oImmutableClass.getClusterForNewInstance((ODocument)record);
                    clusterOverrides.put(oRecordOperation, clusterId);
                }
                clustersToLock.put(clusterId, this.getClusterById(clusterId));
            }
            ArrayList<ORecordOperation> result = new ArrayList<ORecordOperation>();
            ArrayList<Lock[]> arrayList = new ArrayList<Lock[]>(indexesToCommit.size());
            this.stateLock.acquireReadLock();
            try {
                try {
                    try {
                        this.checkOpeness();
                        this.lockIndexKeys(indexManager, indexesToCommit, arrayList);
                        this.makeStorageDirty();
                        this.startStorageTx(clientTx);
                        this.lockClusters(clustersToLock);
                        this.lockRidBags(clustersToLock, indexesToCommit);
                        this.lockIndexes(indexesToCommit);
                        IdentityHashMap<ORecordOperation, OPhysicalPosition> positions = new IdentityHashMap<ORecordOperation, OPhysicalPosition>();
                        HashSet<ORecordOperation> itemsToSkip = new HashSet<ORecordOperation>();
                        for (ORecordOperation oRecordOperation : newRecords) {
                            ORecord rec = oRecordOperation.getRecord();
                            ORecordId rid = (ORecordId)rec.getIdentity().copy();
                            ORecordId oldRID = rid.copy();
                            Integer clusterOverride = (Integer)clusterOverrides.get(oRecordOperation);
                            int clusterId = clusterOverride == null ? rid.getClusterId() : clusterOverride.intValue();
                            OCluster cluster = this.getClusterById(clusterId);
                            OPaginatedCluster.RECORD_STATUS recordStatus = rid.getClusterPosition() > -1L ? ((OPaginatedCluster)cluster).getRecordStatus(rid.getClusterPosition()) : OPaginatedCluster.RECORD_STATUS.NOT_EXISTENT;
                            OPhysicalPosition ppos = new OPhysicalPosition(rid.getClusterPosition());
                            if (recordStatus == OPaginatedCluster.RECORD_STATUS.NOT_EXISTENT) {
                                ppos = cluster.allocatePosition(ORecordInternal.getRecordType(rec));
                                if (rid.getClusterPosition() > -1L) {
                                    while (rid.getClusterPosition() > ppos.clusterPosition) {
                                        ppos = cluster.allocatePosition(ORecordInternal.getRecordType(rec));
                                    }
                                    if (rid.getClusterPosition() != ppos.clusterPosition) {
                                        throw new OConcurrentCreateException(rid, new ORecordId(rid.getClusterId(), ppos.clusterPosition));
                                    }
                                }
                            } else if (recordStatus == OPaginatedCluster.RECORD_STATUS.REMOVED) {
                                ORecord record = oRecordOperation.getRecord();
                                record.setDirty();
                                this.recyclePosition(rid, record.toStream(), record.getVersion(), ORecordInternal.getRecordType(record));
                                itemsToSkip.add(oRecordOperation);
                            }
                            positions.put(oRecordOperation, ppos);
                            rid.setClusterId(cluster.getId());
                            rid.setClusterPosition(ppos.clusterPosition);
                            if (oldRID.equals(rid)) continue;
                            clientTx.updateIdentityAfterCommit(oldRID, rid);
                        }
                        for (ORecordOperation oRecordOperation : entries) {
                            if (!itemsToSkip.contains(oRecordOperation)) {
                                this.commitEntry(oRecordOperation, (OPhysicalPosition)positions.get(oRecordOperation));
                            }
                            result.add(oRecordOperation);
                        }
                        this.commitIndexes(indexesToCommit);
                        this.endStorageTx();
                        OTransactionAbstract.updateCacheFromEntries(clientTx, entries, true);
                        this.txCommit.incrementAndGet();
                    }
                    catch (IOException ioe) {
                        this.makeRollback(clientTx, ioe);
                    }
                    catch (RuntimeException e) {
                        this.makeRollback(clientTx, e);
                    }
                    finally {
                        this.unlockIndexKeys(indexesToCommit, arrayList);
                        this.transaction.set(null);
                    }
                }
                finally {
                    this.atomicOperationsManager.ensureThatComponentsUnlocked();
                    databaseRecord.getMetadata().clearThreadLocalSchemaSnapshot();
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Committed transaction %d on database '%s' (result=%s thread=%d)", clientTx.getId(), databaseRecord.getName(), result, Thread.currentThread().getId());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitIndexes(Map<String, OTransactionIndexChanges> indexesToCommit) {
        for (OTransactionIndexChanges changes : indexesToCommit.values()) {
            changes.getAssociatedIndex().preCommit();
        }
        for (OTransactionIndexChanges changes : indexesToCommit.values()) {
            changes.getAssociatedIndex().addTxOperation(changes);
        }
        try {
            for (OTransactionIndexChanges changes : indexesToCommit.values()) {
                changes.getAssociatedIndex().commit();
            }
        }
        finally {
            for (OTransactionIndexChanges changes : indexesToCommit.values()) {
                changes.getAssociatedIndex().postCommit();
            }
        }
    }

    private TreeMap<String, OTransactionIndexChanges> getSortedIndexEntries(OTransaction clientTx) {
        assert (clientTx instanceof OTransactionOptimistic);
        return new TreeMap<String, OTransactionIndexChanges>(((OTransactionOptimistic)clientTx).getIndexEntries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadIndexEngine(String name) {
        try {
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                OIndexEngine engine = this.indexEngineNameMap.get(name.toLowerCase(this.configuration.getLocaleInstance()));
                if (engine == null) {
                    int n = -1;
                    return n;
                }
                int indexId = this.indexEngines.indexOf(engine);
                assert (indexId >= 0);
                int n = indexId;
                return n;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int loadExternalIndexEngine(String engineName, String algorithm, String indexType, OIndexDefinition indexDefinition, OBinarySerializer valueSerializer, boolean isAutomatic, Boolean durableInNonTxMode, int version, Map<String, String> engineProperties) {
        try {
            this.checkOpeness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpeness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                if (this.configuration.getBinaryFormatVersion() > 15) {
                    int n = -1;
                    return n;
                }
                String originalName = engineName;
                if (this.indexEngineNameMap.containsKey(engineName = engineName.toLowerCase(this.configuration.getLocaleInstance()))) {
                    throw new OIndexException("Index with name " + engineName + " already exists");
                }
                this.makeStorageDirty();
                OBinarySerializer keySerializer = this.determineKeySerializer(indexDefinition);
                int keySize = this.determineKeySize(indexDefinition);
                OType[] keyTypes = indexDefinition != null ? indexDefinition.getTypes() : null;
                boolean nullValuesSupport = indexDefinition != null && !indexDefinition.isNullValuesIgnored();
                OStorageConfigurationImpl.IndexEngineData engineData = new OStorageConfigurationImpl.IndexEngineData(originalName, algorithm, indexType, durableInNonTxMode, version, valueSerializer.getId(), keySerializer.getId(), isAutomatic, keyTypes, nullValuesSupport, keySize, engineProperties);
                OIndexEngine engine = OIndexes.createIndexEngine(originalName, algorithm, indexType, durableInNonTxMode, this, version, engineProperties, null);
                engine.load(originalName, valueSerializer, isAutomatic, keySerializer, keyTypes, nullValuesSupport, keySize, engineData.getEngineProperties());
                this.indexEngineNameMap.put(engineName, engine);
                this.indexEngines.add(engine);
                ((OStorageConfigurationImpl)this.configuration).addIndexEngine(engineName, engineData);
                int n = this.indexEngines.size() - 1;
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Cannot add index engine " + engineName + " in storage."), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addIndexEngine(String engineName, String algorithm, String indexType, OIndexDefinition indexDefinition, OBinarySerializer valueSerializer, boolean isAutomatic, Boolean durableInNonTxMode, int version, Map<String, String> engineProperties, Set<String> clustersToIndex, ODocument metadata) {
        try {
            this.checkOpeness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpeness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                String originalName = engineName;
                engineName = engineName.toLowerCase(this.configuration.getLocaleInstance());
                if (this.indexEngineNameMap.containsKey(engineName)) {
                    OLogManager.instance().warn((Object)this, "Index with name '%s' already exists, removing it and re-create the index", engineName);
                    OIndexEngine engine = this.indexEngineNameMap.remove(engineName);
                    if (engine != null) {
                        this.indexEngines.remove(engine);
                        ((OStorageConfigurationImpl)this.configuration).deleteIndexEngine(engineName);
                        engine.delete();
                    }
                }
                this.makeStorageDirty();
                OBinarySerializer keySerializer = this.determineKeySerializer(indexDefinition);
                int keySize = this.determineKeySize(indexDefinition);
                OType[] keyTypes = indexDefinition != null ? indexDefinition.getTypes() : null;
                boolean nullValuesSupport = indexDefinition != null && !indexDefinition.isNullValuesIgnored();
                byte serializerId = valueSerializer != null ? (byte)valueSerializer.getId() : (byte)-1;
                OIndexEngine engine = OIndexes.createIndexEngine(originalName, algorithm, indexType, durableInNonTxMode, this, version, engineProperties, metadata);
                engine.create(valueSerializer, isAutomatic, keyTypes, nullValuesSupport, keySerializer, keySize, clustersToIndex, engineProperties, metadata);
                this.indexEngineNameMap.put(engineName, engine);
                this.indexEngines.add(engine);
                OStorageConfigurationImpl.IndexEngineData engineData = new OStorageConfigurationImpl.IndexEngineData(originalName, algorithm, indexType, durableInNonTxMode, version, serializerId, keySerializer.getId(), isAutomatic, keyTypes, nullValuesSupport, keySize, engineProperties);
                ((OStorageConfigurationImpl)this.configuration).addIndexEngine(engineName, engineData);
                int n = this.indexEngines.size() - 1;
                return n;
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Cannot add index engine " + engineName + " in storage."), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    private int determineKeySize(OIndexDefinition indexDefinition) {
        if (indexDefinition == null || indexDefinition instanceof ORuntimeKeyIndexDefinition) {
            return 1;
        }
        return indexDefinition.getTypes().length;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OBinarySerializer determineKeySerializer(OIndexDefinition indexDefinition) {
        void var2_6;
        if (indexDefinition != null) {
            if (indexDefinition instanceof ORuntimeKeyIndexDefinition) {
                OBinarySerializer oBinarySerializer = ((ORuntimeKeyIndexDefinition)indexDefinition).getSerializer();
                return var2_6;
            } else if (indexDefinition.getTypes().length > 1) {
                OCompositeKeySerializer oCompositeKeySerializer = OCompositeKeySerializer.INSTANCE;
                return var2_6;
            } else {
                OCurrentStorageComponentsFactory currentStorageComponentsFactory = this.componentsFactory;
                if (currentStorageComponentsFactory == null) throw new IllegalStateException("Cannot load binary serializer, storage is not porperly initialized");
                OBinarySerializer oBinarySerializer = currentStorageComponentsFactory.binarySerializerFactory.getObjectSerializer(indexDefinition.getTypes()[0]);
            }
            return var2_6;
        } else {
            OSimpleKeySerializer oSimpleKeySerializer = new OSimpleKeySerializer();
        }
        return var2_6;
    }

    public void deleteIndexEngine(int indexId) throws OInvalidIndexEngineIdException {
        try {
            this.checkOpeness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpeness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.checkIndexId(indexId);
                this.makeStorageDirty();
                OIndexEngine engine = this.indexEngines.get(indexId);
                this.indexEngines.set(indexId, null);
                engine.delete();
                String engineName = engine.getName().toLowerCase(this.configuration.getLocaleInstance());
                this.indexEngineNameMap.remove(engineName);
                ((OStorageConfigurationImpl)this.configuration).deleteIndexEngine(engineName);
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error on index deletion"), e);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    private void checkIndexId(int indexId) throws OInvalidIndexEngineIdException {
        if (indexId < 0 || indexId >= this.indexEngines.size() || this.indexEngines.get(indexId) == null) {
            throw new OInvalidIndexEngineIdException("Engine with id " + indexId + " is not registered inside of storage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexContainsKey(int indexId, Object key) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doIndexContainsKey(indexId, key);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            boolean bl = this.doIndexContainsKey(indexId, key);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private boolean doIndexContainsKey(int indexId, Object key) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKeyFromIndex(int indexId, Object key) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doRemoveKeyFromIndex(indexId, key);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            boolean bl = this.doRemoveKeyFromIndex(indexId, key);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private boolean doRemoveKeyFromIndex(int indexId, Object key) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            this.makeStorageDirty();
            OIndexEngine engine = this.indexEngines.get(indexId);
            return engine.remove(key);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during removal of entry with key " + key + " from index "), e);
        }
    }

    public void clearIndex(int indexId) throws OInvalidIndexEngineIdException {
        try {
            if (this.transaction.get() != null) {
                this.doClearIndex(indexId);
                return;
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.doClearIndex(indexId);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    private void doClearIndex(int indexId) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OIndexEngine engine = this.indexEngines.get(indexId);
            this.makeStorageDirty();
            engine.clear();
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during clearing of index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getIndexValue(int indexId, Object key) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexValue(indexId, key);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            Object object = this.doGetIndexValue(indexId, key);
            this.stateLock.releaseReadLock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private Object doGetIndexValue(int indexId, Object key) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.get(key);
    }

    public OIndexEngine getIndexEngine(int indexId) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            return this.indexEngines.get(indexId);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexEntry(int indexId, Object key, Callable<Object> valueCreator) throws OInvalidIndexEngineIdException {
        try {
            if (this.transaction.get() != null) {
                this.doUpdateIndexEntry(indexId, key, valueCreator);
                return;
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.doUpdateIndexEntry(indexId, key, valueCreator);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T callIndexEngine(boolean atomicOperation, boolean readOperation, int indexId, OIndexEngineCallback<T> callback) throws OInvalidIndexEngineIdException {
        try {
            if (this.transaction.get() != null) {
                return this.doCallIndexEngine(atomicOperation, readOperation, indexId, callback);
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                T t2 = this.doCallIndexEngine(atomicOperation, readOperation, indexId, callback);
                return t2;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t3) {
            throw this.logAndPrepareForRethrow(t3);
        }
    }

    private <T> T doCallIndexEngine(boolean atomicOperation, boolean readOperation, int indexId, OIndexEngineCallback<T> callback) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        try {
            if (atomicOperation) {
                this.atomicOperationsManager.startAtomicOperation((String)null, true);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key value entry in index"), e);
        }
        try {
            if (!readOperation) {
                this.makeStorageDirty();
            }
            OIndexEngine engine = this.indexEngines.get(indexId);
            T result = callback.callEngine(engine);
            if (atomicOperation) {
                this.atomicOperationsManager.endAtomicOperation(false, null, (String)null);
            }
            return result;
        }
        catch (Exception e) {
            try {
                if (atomicOperation) {
                    this.atomicOperationsManager.endAtomicOperation(true, e, (String)null);
                }
                throw OException.wrapException(new OStorageException("Cannot put key value entry in index"), e);
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Error during operation rollback"), ioe);
            }
        }
    }

    private void doUpdateIndexEntry(int indexId, Object key, Callable<Object> valueCreator) throws OInvalidIndexEngineIdException {
        try {
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key value entry in index"), e);
        }
        try {
            this.checkIndexId(indexId);
            OIndexEngine engine = this.indexEngines.get(indexId);
            this.makeStorageDirty();
            Object value = valueCreator.call();
            if (value == null) {
                engine.remove(key);
            } else {
                engine.put(key, value);
            }
            this.atomicOperationsManager.endAtomicOperation(false, null, (String)null);
        }
        catch (OInvalidIndexEngineIdException e) {
            try {
                this.atomicOperationsManager.endAtomicOperation(true, (Exception)e, (String)null);
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Error during operation rollback"), ioe);
            }
            throw e;
        }
        catch (Exception e) {
            try {
                this.atomicOperationsManager.endAtomicOperation(true, e, (String)null);
                throw OException.wrapException(new OStorageException("Cannot put key value entry in index"), e);
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Error during operation rollback"), ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIndexValue(int indexId, Object key, Object value) throws OInvalidIndexEngineIdException {
        try {
            if (this.transaction.get() != null) {
                this.doPutIndexValue(indexId, key, value);
                return;
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
                this.doPutIndexValue(indexId, key, value);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    private void doPutIndexValue(int indexId, Object key, Object value) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OIndexEngine engine = this.indexEngines.get(indexId);
            this.makeStorageDirty();
            engine.put(key, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key " + key + " value " + value + " entry to the index"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validatedPutIndexValue(int indexId, Object key, OIdentifiable value, OIndexEngine.Validator<Object, OIdentifiable> validator) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doValidatedPutIndexValue(indexId, key, value, validator);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            this.checkLowDiskSpaceRequestsAndReadOnlyConditions();
            boolean bl = this.doValidatedPutIndexValue(indexId, key, value, validator);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private boolean doValidatedPutIndexValue(int indexId, Object key, OIdentifiable value, OIndexEngine.Validator<Object, OIdentifiable> validator) throws OInvalidIndexEngineIdException {
        try {
            this.checkIndexId(indexId);
            OIndexEngine engine = this.indexEngines.get(indexId);
            this.makeStorageDirty();
            return engine.validatedPut(key, value, validator);
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Cannot put key " + key + " value " + value + " entry to the index"), e);
        }
    }

    public Object getIndexFirstKey(int indexId) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexFirstKey(indexId);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            Object object = this.doGetIndexFirstKey(indexId);
            this.stateLock.releaseReadLock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private Object doGetIndexFirstKey(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.getFirstKey();
    }

    public Object getIndexLastKey(int indexId) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexFirstKey(indexId);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            Object object = this.doGetIndexLastKey(indexId);
            this.stateLock.releaseReadLock();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private Object doGetIndexLastKey(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.getLastKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor iterateIndexEntriesBetween(int indexId, Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesBetween(indexId, rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OIndexCursor oIndexCursor = this.doIterateIndexEntriesBetween(indexId, rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private OIndexCursor doIterateIndexEntriesBetween(int indexId, Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor iterateIndexEntriesMajor(int indexId, Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesMajor(indexId, fromKey, isInclusive, ascSortOrder, transformer);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OIndexCursor oIndexCursor = this.doIterateIndexEntriesMajor(indexId, fromKey, isInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private OIndexCursor doIterateIndexEntriesMajor(int indexId, Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor iterateIndexEntriesMinor(int indexId, Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doIterateIndexEntriesMinor(indexId, toKey, isInclusive, ascSortOrder, transformer);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OIndexCursor oIndexCursor = this.doIterateIndexEntriesMinor(indexId, toKey, isInclusive, ascSortOrder, transformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private OIndexCursor doIterateIndexEntriesMinor(int indexId, Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.iterateEntriesMinor(toKey, isInclusive, ascSortOrder, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor getIndexCursor(int indexId, OIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexCursor(indexId, valuesTransformer);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OIndexCursor oIndexCursor = this.doGetIndexCursor(indexId, valuesTransformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private OIndexCursor doGetIndexCursor(int indexId, OIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.cursor(valuesTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexCursor getIndexDescCursor(int indexId, OIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexDescCursor(indexId, valuesTransformer);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OIndexCursor oIndexCursor = this.doGetIndexDescCursor(indexId, valuesTransformer);
            this.stateLock.releaseReadLock();
            return oIndexCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private OIndexCursor doGetIndexDescCursor(int indexId, OIndexEngine.ValuesTransformer valuesTransformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.descCursor(valuesTransformer);
    }

    public OIndexKeyCursor getIndexKeyCursor(int indexId) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexKeyCursor(indexId);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OIndexKeyCursor oIndexKeyCursor = this.doGetIndexKeyCursor(indexId);
            this.stateLock.releaseReadLock();
            return oIndexKeyCursor;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private OIndexKeyCursor doGetIndexKeyCursor(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.keyCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIndexSize(int indexId, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doGetIndexSize(indexId, transformer);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            long l = this.doGetIndexSize(indexId, transformer);
            this.stateLock.releaseReadLock();
            return l;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private long doGetIndexSize(int indexId, OIndexEngine.ValuesTransformer transformer) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.size(transformer);
    }

    public boolean hasIndexRangeQuerySupport(int indexId) throws OInvalidIndexEngineIdException {
        if (this.transaction.get() != null) {
            return this.doHasRangeQuerySupport(indexId);
        }
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            boolean bl = this.doHasRangeQuerySupport(indexId);
            this.stateLock.releaseReadLock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    private boolean doHasRangeQuerySupport(int indexId) throws OInvalidIndexEngineIdException {
        this.checkIndexId(indexId);
        OIndexEngine engine = this.indexEngines.get(indexId);
        return engine.hasRangeQuerySupport();
    }

    private void makeRollback(OTransaction clientTx, Exception e) {
        OLogManager.instance().debug((Object)this, "Error during transaction commit, transaction will be rolled back (tx-id=%d)", e, clientTx.getId());
        try {
            this.rollback(clientTx);
        }
        catch (Exception ex) {
            OLogManager.instance().error(this, "Error during transaction rollback, `%08X`", ex, System.identityHashCode(ex));
        }
        if (e instanceof OException) {
            throw (OException)e;
        }
        throw OException.wrapException(new OStorageException("Error during transaction commit"), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(OTransaction clientTx) {
        try {
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                try {
                    this.checkOpeness();
                    if (this.transaction.get() == null) {
                        return;
                    }
                    if (this.transaction.get().getClientTx().getId() != clientTx.getId()) {
                        throw new OStorageException("Passed in and active transaction are different transactions. Passed in transaction cannot be rolled back.");
                    }
                    this.makeStorageDirty();
                    this.rollbackStorageTx();
                    OTransactionAbstract.updateCacheFromEntries(clientTx, clientTx.getAllRecordEntries(), false);
                    this.txRollback.incrementAndGet();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Error during transaction rollback"), e);
                }
                finally {
                    this.transaction.set(null);
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        try {
            return ppos != null && !ORecordVersionHelper.isTombstone(ppos.recordVersion);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synch() {
        try {
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                long timer = Orient.instance().getProfiler().startChrono();
                long lockId = this.atomicOperationsManager.freezeAtomicOperations(null, null);
                try {
                    this.checkOpeness();
                    for (OIndexEngine indexEngine : this.indexEngines) {
                        try {
                            if (indexEngine == null) continue;
                            indexEngine.flush();
                        }
                        catch (Throwable t2) {
                            OLogManager.instance().error(this, "Error while flushing index via index engine of class %s.", t2, indexEngine.getClass().getSimpleName());
                        }
                    }
                    if (this.writeAheadLog != null) {
                        this.makeFullCheckpoint();
                        return;
                    }
                    this.writeCache.flush();
                    this.clearStorageDirty();
                }
                catch (IOException e) {
                    throw OException.wrapException(new OStorageException("Error on synch storage '" + this.name + "'"), e);
                }
                finally {
                    this.atomicOperationsManager.releaseAtomicOperations(lockId);
                    Orient.instance().getProfiler().stopChrono("db." + this.name + ".synch", "Synch a database", timer, "db.*.synch");
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t3) {
            throw this.logAndPrepareForRethrow(t3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        try {
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                if (iClusterId < 0 || iClusterId >= this.clusters.size()) {
                    String string = null;
                    return string;
                }
                String string = this.clusters.get(iClusterId) != null ? this.clusters.get(iClusterId).getName() : null;
                return string;
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        try {
            this.defaultClusterId = defaultClusterId;
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterById(int iClusterId) {
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            this.checkClusterSegmentIndexRange(iClusterId);
            OCluster cluster = this.clusters.get(iClusterId);
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterId + " is null");
            }
            OCluster oCluster = cluster;
            this.stateLock.releaseReadLock();
            return oCluster;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterByName(String clusterName) {
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            OCluster cluster = this.clusterMap.get(clusterName.toLowerCase(this.configuration.getLocaleInstance()));
            if (cluster == null) {
                throw new OStorageException("Cluster " + clusterName + " does not exist in database '" + this.name + "'");
            }
            OCluster oCluster = cluster;
            this.stateLock.releaseReadLock();
            return oCluster;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        try {
            try {
                long size = 0L;
                this.stateLock.acquireReadLock();
                try {
                    for (OCluster c : this.clusters) {
                        if (c == null) continue;
                        size += c.getRecordsSize();
                    }
                }
                finally {
                    this.stateLock.releaseReadLock();
                }
                return size;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cannot calculate records size"), ioe);
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public int getClusters() {
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            int n = this.clusterMap.size();
            this.stateLock.releaseReadLock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OCluster> getClusterInstances() {
        this.checkOpeness();
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            LinkedHashSet<OCluster> result = new LinkedHashSet<OCluster>();
            for (OCluster c : this.clusters) {
                if (c == null) continue;
                result.add(c);
            }
            LinkedHashSet<OCluster> linkedHashSet = result;
            this.stateLock.releaseReadLock();
            return linkedHashSet;
        }
        catch (Throwable throwable) {
            try {
                this.stateLock.releaseReadLock();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Error e) {
                throw this.logAndPrepareForRethrow(e);
            }
            catch (Throwable t2) {
                throw this.logAndPrepareForRethrow(t2);
            }
        }
    }

    public void renameCluster(String oldName, String newName) {
        try {
            this.clusterMap.put(newName.toLowerCase(this.configuration.getLocaleInstance()), this.clusterMap.remove(oldName.toLowerCase(this.configuration.getLocaleInstance())));
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public boolean cleanOutRecord(ORecordId recordId, int recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        try {
            return this.deleteRecord(recordId, recordVersion, iMode, callback).getResult();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public boolean isFrozen() {
        try {
            return !this.isClosed() && this.atomicOperationsManager.isFrozen();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeze(boolean throwException) {
        try {
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                long freezeId = throwException ? this.atomicOperationsManager.freezeAtomicOperations(OModificationOperationProhibitedException.class, "Modification requests are prohibited") : this.atomicOperationsManager.freezeAtomicOperations(null, null);
                ArrayList<OFreezableStorageComponent> frozenIndexes = new ArrayList<OFreezableStorageComponent>(this.indexEngines.size());
                try {
                    for (OIndexEngine indexEngine : this.indexEngines) {
                        if (indexEngine == null || !(indexEngine instanceof OFreezableStorageComponent)) continue;
                        ((OFreezableStorageComponent)((Object)indexEngine)).freeze(false);
                        frozenIndexes.add((OFreezableStorageComponent)((Object)indexEngine));
                    }
                }
                catch (Exception e) {
                    for (OFreezableStorageComponent indexEngine : frozenIndexes) {
                        indexEngine.release();
                    }
                    throw OException.wrapException(new OStorageException("Error on freeze of storage '" + this.name + "'"), e);
                }
                this.synch();
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public void release() {
        try {
            for (OIndexEngine indexEngine : this.indexEngines) {
                if (indexEngine == null || !(indexEngine instanceof OFreezableStorageComponent)) continue;
                ((OFreezableStorageComponent)((Object)indexEngine)).release();
            }
            this.atomicOperationsManager.releaseAtomicOperations(-1L);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public void reload() {
        try {
            this.close();
            this.open(null, null, null);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    public void lowDiskSpace(OLowDiskSpaceInformation information) {
        try {
            this.lowDiskSpace = information;
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public void pageIsBroken(String fileName, long pageIndex) {
        this.brokenPages.add(new OPair<String, Long>(fileName, pageIndex));
    }

    @Override
    public void requestCheckpoint() {
        try {
            this.checkpointRequest = true;
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public Object command(OCommandRequestText iCommand) {
        try {
            while (true) {
                try {
                    OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
                    executor.setContext(iCommand.getContext());
                    executor.setProgressListener(iCommand.getProgressListener());
                    executor.parse(iCommand);
                    String currentThreadName = Thread.currentThread().getName();
                    try {
                        if (currentThreadName == null || !currentThreadName.contains("<query>") && !currentThreadName.contains("<command>")) {
                            if (currentThreadName == null) {
                                currentThreadName = "";
                            }
                            try {
                                Thread.currentThread().setName(currentThreadName + " <command>" + iCommand + "</command>");
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                        Object result = this.executeCommand(iCommand, executor);
                        try {
                            Thread.currentThread().setName(currentThreadName);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        return result;
                    }
                    catch (RuntimeException e) {
                        try {
                            Thread.currentThread().setName(currentThreadName);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        throw e;
                    }
                }
                catch (ORetryQueryException ignore) {
                    if (!(iCommand instanceof OQueryAbstract)) continue;
                    OQueryAbstract query2 = (OQueryAbstract)((Object)iCommand);
                    query2.reset();
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e, false);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeCommand(OCommandRequestText iCommand, OCommandExecutor executor) {
        try {
            ODatabaseDocumentInternal db;
            Iterator iterator;
            if (iCommand.isIdempotent() && !executor.isIdempotent()) {
                throw new OCommandExecutionException("Cannot execute non idempotent command");
            }
            long beginTime = Orient.instance().getProfiler().startChrono();
            try {
                ODatabaseDocumentInternal db2 = ODatabaseRecordThreadLocal.instance().get();
                Iterable<ODatabaseListener> listeners = db2.getListeners();
                for (ODatabaseListener oDatabaseListener : listeners) {
                    oDatabaseListener.onBeforeCommand(iCommand, executor);
                }
                boolean foundInCache = false;
                Object result = null;
                if (iCommand.isCacheableResult() && executor.isCacheable() && iCommand.getParameters() == null && (result = db2.getMetadata().getCommandCache().get(db2.getUser(), iCommand.getText(), iCommand.getLimit())) != null) {
                    foundInCache = true;
                    if (iCommand.getResultListener() != null) {
                        if (result instanceof Collection) {
                            for (Object o : (Collection)result) {
                                iCommand.getResultListener().result(o);
                            }
                        } else {
                            iCommand.getResultListener().result(result);
                        }
                        result = null;
                    }
                }
                if (!foundInCache && (result = executor.execute(iCommand.getParameters())) != null && iCommand.isCacheableResult() && executor.isCacheable() && (iCommand.getParameters() == null || iCommand.getParameters().isEmpty())) {
                    db2.getMetadata().getCommandCache().put(db2.getUser(), iCommand.getText(), result, iCommand.getLimit(), executor.getInvolvedClusters(), System.currentTimeMillis() - beginTime);
                }
                for (ODatabaseListener oDatabaseListener : listeners) {
                    oDatabaseListener.onAfterCommand(iCommand, executor, result);
                }
                iterator = result;
            }
            catch (OException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw OException.wrapException(new OCommandExecutionException("Error on execution of command: " + iCommand), e2);
                    }
                }
                catch (Throwable throwable) {
                    ODatabaseDocumentInternal db3;
                    if (Orient.instance().getProfiler().isRecording() && (db3 = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                        OSecurityUser user = db3.getUser();
                        String userString = user != null ? user.toString() : null;
                        Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.instance().get().getName() + ".command." + iCommand.toString(), "Command executed against the database", beginTime, "db.*.command.*", null, userString);
                    }
                    throw throwable;
                }
            }
            if (Orient.instance().getProfiler().isRecording() && (db = ODatabaseRecordThreadLocal.instance().getIfDefined()) != null) {
                OSecurityUser user = db.getUser();
                String userString = user != null ? user.toString() : null;
                Orient.instance().getProfiler().stopChrono("db." + ODatabaseRecordThreadLocal.instance().get().getName() + ".command." + iCommand.toString(), "Command executed against the database", beginTime, "db.*.command.*", null, userString);
            }
            return iterator;
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e, false);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        try {
            if (currentClusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                OCluster cluster = this.getClusterById(currentClusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.higherPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        try {
            if (clusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                OCluster cluster = this.getClusterById(clusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.ceilingPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition physicalPosition) {
        try {
            if (currentClusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                OCluster cluster = this.getClusterById(currentClusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.lowerPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + currentClusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        try {
            if (clusterId == -1) {
                return new OPhysicalPosition[0];
            }
            this.checkOpeness();
            this.stateLock.acquireReadLock();
            try {
                this.checkOpeness();
                OCluster cluster = this.getClusterById(clusterId);
                OPhysicalPosition[] oPhysicalPositionArray = cluster.floorPositions(physicalPosition);
                return oPhysicalPositionArray;
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Cluster Id " + clusterId + " is invalid in storage '" + this.name + '\''), ioe);
            }
            finally {
                this.stateLock.releaseReadLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public void acquireWriteLock(ORID rid) {
        try {
            this.lockManager.acquireLock(rid, OComparableLockManager.LOCK.EXCLUSIVE, RECORD_LOCK_TIMEOUT);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public void releaseWriteLock(ORID rid) {
        try {
            this.lockManager.releaseLock(this, rid, OComparableLockManager.LOCK.EXCLUSIVE);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public void acquireReadLock(ORID rid) {
        try {
            this.lockManager.acquireLock(rid, OComparableLockManager.LOCK.SHARED, RECORD_LOCK_TIMEOUT);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public void releaseReadLock(ORID rid) {
        try {
            this.lockManager.releaseLock(this, rid, OComparableLockManager.LOCK.SHARED);
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return this.recordConflictStrategy;
    }

    @Override
    public void setConflictStrategy(ORecordConflictStrategy conflictResolver) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            this.recordConflictStrategy = conflictResolver;
            ((OStorageConfigurationImpl)this.configuration).setConflictStrategy(conflictResolver.getName());
            ((OStorageConfigurationImpl)this.configuration).update();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    protected abstract OLogSequenceNumber copyWALToIncrementalBackup(ZipOutputStream var1, long var2) throws IOException;

    protected abstract boolean isWriteAllowedDuringIncrementalBackup();

    public OStorageRecoverListener getRecoverListener() {
        return this.recoverListener;
    }

    public void registerRecoverListener(OStorageRecoverListener recoverListener) {
        try {
            if (recoverListener != null) {
                this.recoverListener = recoverListener;
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    public void unregisterRecoverListener(OStorageRecoverListener recoverListener) {
        try {
            if (this.recoverListener == recoverListener) {
                this.recoverListener = null;
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    protected abstract File createWalTempDirectory();

    protected abstract void addFileToDirectory(String var1, InputStream var2, File var3) throws IOException;

    protected abstract OWriteAheadLog createWalFromIBUFiles(File var1) throws IOException;

    protected void checkOpeness() {
        if (this.status != OStorage.STATUS.OPEN) {
            throw new OStorageException("Storage " + this.name + " is not opened.");
        }
    }

    protected void makeFullCheckpoint() throws IOException {
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startFullCheckpointTimer();
        }
        try {
            if (this.writeAheadLog == null) {
                return;
            }
            try {
                this.writeAheadLog.flush();
                this.writeAheadLog.appendNewSegment();
                this.writeAheadLog.logFullCheckpointStart();
                this.writeCache.flush();
                this.writeAheadLog.logFullCheckpointEnd();
                this.writeAheadLog.flush();
                OLogSequenceNumber lastLSN = this.writeAheadLog.getOldestTxLsn();
                this.writeAheadLog.cutTill(lastLSN);
                this.clearStorageDirty();
            }
            catch (IOException ioe) {
                throw OException.wrapException(new OStorageException("Error during checkpoint creation for storage " + this.name), ioe);
            }
            ++this.fullCheckpointCount;
        }
        finally {
            if (statistic != null) {
                statistic.stopFullCheckpointTimer();
            }
        }
    }

    public long getFullCheckpointCount() {
        return this.fullCheckpointCount;
    }

    protected void preOpenSteps() throws IOException {
    }

    protected void postCreateSteps() {
    }

    protected void preCreateSteps() throws IOException {
    }

    protected abstract void initWalAndDiskCache() throws IOException;

    protected abstract void postCloseSteps(boolean var1, boolean var2) throws IOException;

    protected void preCloseSteps() throws IOException {
    }

    protected void postDeleteSteps() {
    }

    protected void makeStorageDirty() throws IOException {
    }

    protected void clearStorageDirty() throws IOException {
    }

    protected boolean isDirty() throws IOException {
        return false;
    }

    public boolean isIndexRebuildScheduled() {
        return false;
    }

    protected boolean isIndexRebuildScheduledInternal() {
        return false;
    }

    protected void scheduleIndexRebuild() throws IOException {
    }

    public void cancelIndexRebuild() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer readRecordIfNotLatest(OCluster cluster, ORecordId rid, int recordVersion) throws ORecordNotFoundException {
        this.checkOpeness();
        if (!rid.isPersistent()) {
            throw new ORecordNotFoundException(rid, "Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
        }
        if (this.transaction.get() != null) {
            return this.doReadRecordIfNotLatest(cluster, rid, recordVersion);
        }
        this.stateLock.acquireReadLock();
        try {
            ORawBuffer buff;
            this.checkOpeness();
            ORawBuffer oRawBuffer = buff = this.doReadRecordIfNotLatest(cluster, rid, recordVersion);
            return oRawBuffer;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORawBuffer readRecord(OCluster clusterSegment, ORecordId rid, boolean prefetchRecords) {
        this.checkOpeness();
        if (!rid.isPersistent()) {
            throw new ORecordNotFoundException(rid, "Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
        }
        if (this.transaction.get() != null) {
            return this.doReadRecord(clusterSegment, rid, prefetchRecords);
        }
        this.stateLock.acquireReadLock();
        try {
            this.checkOpeness();
            ORawBuffer oRawBuffer = this.doReadRecord(clusterSegment, rid, prefetchRecords);
            return oRawBuffer;
        }
        finally {
            this.stateLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OPair<ORecordId, ORawBuffer>> readRecords(Collection<ORecordId> iRids) {
        try {
            this.checkOpeness();
            ArrayList<OPair<ORecordId, ORawBuffer>> records = new ArrayList<OPair<ORecordId, ORawBuffer>>();
            if (iRids == null || iRids.isEmpty()) {
                return records;
            }
            if (this.transaction.get() != null) {
                for (ORecordId rid : iRids) {
                    if (!rid.isPersistent()) {
                        throw new ORecordNotFoundException(rid, "Cannot read record " + rid + " since the position is invalid in database '" + this.name + '\'');
                    }
                    records.add(new OPair<ORecordId, ORawBuffer>(rid, this.doReadRecord(this.getClusterById(rid.getClusterId()), rid, false)));
                }
                return records;
            }
            Map<Integer, List<ORecordId>> ridsPerCluster = this.getRidsGroupedByCluster(iRids);
            this.stateLock.acquireReadLock();
            try {
                for (Map.Entry<Integer, List<ORecordId>> entry : ridsPerCluster.entrySet()) {
                    int clusterId = entry.getKey();
                    OCluster clusterSegment = this.getClusterById(clusterId);
                    for (ORecordId rid : entry.getValue()) {
                        records.add(new OPair<ORecordId, ORawBuffer>(rid, this.doReadRecord(clusterSegment, rid, false)));
                    }
                }
            }
            finally {
                this.stateLock.releaseReadLock();
            }
            return records;
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkClustersConsistency() {
        int errors = 0;
        try {
            this.checkOpeness();
            this.stateLock.acquireWriteLock();
            try {
                this.checkOpeness();
                OLogManager.instance().info((Object)this, "Start checking clusters consistency\n", new Object[0]);
                for (OCluster cluster : this.clusters) {
                    OPaginatedCluster paginatedCluster = (OPaginatedCluster)cluster;
                    errors += paginatedCluster.checkClusterConsistency();
                }
                OLogManager.instance().info((Object)this, "Clusters consistency check is completed\n", new Object[0]);
            }
            finally {
                this.stateLock.releaseWriteLock();
            }
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        return errors;
    }

    private void endStorageTx() throws IOException {
        this.atomicOperationsManager.endAtomicOperation(false, null, (String)null);
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
    }

    private void startStorageTx(OTransaction clientTx) throws IOException {
        OStorageTransaction storageTx = this.transaction.get();
        if (storageTx != null && storageTx.getClientTx().getId() != clientTx.getId()) {
            this.rollback(clientTx);
        }
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
        this.transaction.set(new OStorageTransaction(clientTx));
        try {
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
        }
        catch (RuntimeException e) {
            this.transaction.set(null);
            throw e;
        }
    }

    private void rollbackStorageTx() throws IOException {
        if (this.transaction.get() == null) {
            return;
        }
        this.atomicOperationsManager.endAtomicOperation(true, null, (String)null);
        assert (this.atomicOperationsManager.getCurrentOperation() == null);
    }

    private void recoverIfNeeded() throws Exception {
        if (this.isDirty()) {
            OLogManager.instance().warn((Object)this, "Storage '" + this.name + "' was not closed properly. Will try to recover from write ahead log...", new Object[0]);
            try {
                this.restoreFromWAL();
                if (this.recoverListener != null) {
                    this.recoverListener.onStorageRecover();
                }
                this.makeFullCheckpoint();
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Exception during storage data restore", e, new Object[0]);
                throw e;
            }
            OLogManager.instance().info((Object)this, "Storage data recover was completed", new Object[0]);
        }
    }

    private OStorageOperationResult<OPhysicalPosition> doCreateRecord(ORecordId rid, byte[] content, int recordVersion, byte recordType, ORecordCallback<Long> callback, OCluster cluster, OPhysicalPosition ppos, OPhysicalPosition allocated) {
        if (content == null) {
            throw new IllegalArgumentException("Record is null");
        }
        try {
            if (recordVersion < 1) {
                recordVersion = 1;
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                ppos = cluster.createRecord(content, recordVersion, recordType, allocated);
                rid.setClusterPosition(ppos.clusterPosition);
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null, (String)null);
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e, (String)null);
                if (e instanceof OOfflineClusterException) {
                    throw (OOfflineClusterException)e;
                }
                OLogManager.instance().error(this, "Error on creating record in cluster: " + cluster, e, new Object[0]);
                try {
                    if (ppos.clusterPosition != -1L) {
                        cluster.deleteRecord(ppos.clusterPosition);
                    }
                }
                catch (IOException ioe) {
                    OLogManager.instance().error(this, "Error on removing record in cluster: " + cluster, ioe, new Object[0]);
                }
                return null;
            }
            if (callback != null) {
                callback.call(rid, ppos.clusterPosition);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Created record %s v.%s size=%d bytes (thread=%d tx=%s)", rid, recordVersion, content.length, Thread.currentThread().getId(), this.getStorageTransaction() != null);
            }
            this.recordCreated.incrementAndGet();
            return new OStorageOperationResult<OPhysicalPosition>(ppos);
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error during record deletion in cluster " + (cluster != null ? cluster.getName() : "")), ioe);
        }
    }

    private OStorageOperationResult<Integer> doUpdateRecord(ORecordId rid, boolean updateContent, byte[] content, int version, byte recordType, ORecordCallback<Integer> callback, OCluster cluster) {
        try {
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
            if (ppos != OPaginatedCluster.NO_POSITION && !this.checkForRecordValidity(ppos)) {
                int recordVersion = -1;
                if (callback != null) {
                    callback.call(rid, -1);
                }
                return new OStorageOperationResult<Integer>(-1);
            }
            boolean contentModified = false;
            if (updateContent) {
                AtomicInteger recVersion = new AtomicInteger(version);
                AtomicInteger dbVersion = new AtomicInteger(ppos.recordVersion);
                byte[] newContent = this.checkAndIncrementVersion(cluster, rid, recVersion, dbVersion, content, recordType);
                ppos.recordVersion = dbVersion.get();
                if (newContent != null) {
                    contentModified = true;
                    content = newContent;
                }
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                ORecordSerializationContext context;
                if (updateContent) {
                    cluster.updateRecord(rid.getClusterPosition(), content, ppos.recordVersion, recordType);
                }
                if ((context = ORecordSerializationContext.getContext()) != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null, (String)null);
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e, (String)null);
                OLogManager.instance().error(this, "Error on updating record " + rid + " (cluster: " + cluster + ")", e, new Object[0]);
                int recordVersion = -1;
                if (callback != null) {
                    callback.call(rid, -1);
                }
                return new OStorageOperationResult<Integer>(-1);
            }
            int newRecordVersion = updateContent ? ppos.recordVersion : version;
            if (callback != null) {
                callback.call(rid, newRecordVersion);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Updated record %s v.%s size=%d (thread=%d tx=%s)", rid, newRecordVersion, content.length, Thread.currentThread().getId(), this.getStorageTransaction() != null);
            }
            this.recordUpdated.incrementAndGet();
            if (contentModified) {
                return new OStorageOperationResult<Integer>(newRecordVersion, content, false);
            }
            return new OStorageOperationResult<Integer>(newRecordVersion);
        }
        catch (OConcurrentModificationException e) {
            this.recordConflict.incrementAndGet();
            throw e;
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error on updating record " + rid + " (cluster: " + cluster.getName() + ")"), ioe);
        }
    }

    private boolean doRecycleRecord(ORecordId rid, OCluster cluster) {
        try {
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                cluster.recycleRecord(rid.getClusterPosition());
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null, (String)null);
            }
            catch (RuntimeException e) {
                this.atomicOperationsManager.endAtomicOperation(true, (Exception)e, (String)null);
                throw e;
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e, (String)null);
                OLogManager.instance().error(this, "Error on recycling record " + rid + " (cluster: " + cluster + ")", e, new Object[0]);
                throw OException.wrapException(new OStorageException("Error on recycling record " + rid + " (cluster: " + cluster + ")"), e);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Recycled record %s (thread=%d tx=%s)", rid, Thread.currentThread().getId(), this.getStorageTransaction() != null);
            }
            this.recordRecycled.incrementAndGet();
            return true;
        }
        catch (IOException ioe) {
            OLogManager.instance().error(this, "Error on recycling record " + rid + " (cluster: " + cluster + ")", ioe, new Object[0]);
            throw OException.wrapException(new OStorageException("Error on recycling record " + rid + " (cluster: " + cluster + ")"), ioe);
        }
    }

    private OStorageOperationResult<Boolean> doDeleteRecord(ORecordId rid, int version, OCluster cluster) {
        try {
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
            if (ppos == null) {
                return new OStorageOperationResult<Boolean>(false);
            }
            if (version > -1 && ppos.recordVersion != version) {
                this.recordConflict.incrementAndGet();
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(rid, ppos.recordVersion, version, 2);
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                cluster.deleteRecord(ppos.clusterPosition);
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null, (String)null);
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e, (String)null);
                OLogManager.instance().error(this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", e, new Object[0]);
                return new OStorageOperationResult<Boolean>(false);
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Deleted record %s v.%s (thread=%d tx=%s)", rid, version, Thread.currentThread().getId(), this.getStorageTransaction() != null);
            }
            this.recordDeleted.incrementAndGet();
            return new OStorageOperationResult<Boolean>(true);
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OStorageException("Error on deleting record " + rid + "( cluster: " + cluster.getName() + ")"), ioe);
        }
    }

    private OStorageOperationResult<Boolean> doHideMethod(ORecordId rid, OCluster cluster) {
        try {
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(rid.getClusterPosition()));
            if (ppos == null) {
                return new OStorageOperationResult<Boolean>(false);
            }
            this.makeStorageDirty();
            this.atomicOperationsManager.startAtomicOperation((String)null, true);
            try {
                cluster.hideRecord(ppos.clusterPosition);
                ORecordSerializationContext context = ORecordSerializationContext.getContext();
                if (context != null) {
                    context.executeOperations(this);
                }
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Hide record %s v.%s (thread=%d tx=%s)", rid, this.version, Thread.currentThread().getId(), this.getStorageTransaction() != null);
                }
                this.atomicOperationsManager.endAtomicOperation(false, null, (String)null);
            }
            catch (Exception e) {
                this.atomicOperationsManager.endAtomicOperation(true, e, (String)null);
                OLogManager.instance().error(this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", e, new Object[0]);
                return new OStorageOperationResult<Boolean>(false);
            }
            this.recordDeleted.incrementAndGet();
            return new OStorageOperationResult<Boolean>(true);
        }
        catch (IOException ioe) {
            OLogManager.instance().error(this, "Error on deleting record " + rid + "( cluster: " + cluster + ")", ioe, new Object[0]);
            throw OException.wrapException(new OStorageException("Error on deleting record " + rid + "( cluster: " + cluster + ")"), ioe);
        }
    }

    private ORawBuffer doReadRecord(OCluster clusterSegment, ORecordId rid, boolean prefetchRecords) {
        try {
            ORawBuffer buff = clusterSegment.readRecord(rid.getClusterPosition(), prefetchRecords);
            if (buff != null && OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Read record %s v.%s size=%d bytes (thread=%d tx=%s)", rid, buff.version, buff.buffer != null ? buff.buffer.length : 0, Thread.currentThread().getId(), this.getStorageTransaction() != null);
            }
            this.recordRead.incrementAndGet();
            return buff;
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during read of record with rid = " + rid), e);
        }
    }

    private ORawBuffer doReadRecordIfNotLatest(OCluster cluster, ORecordId rid, int recordVersion) throws ORecordNotFoundException {
        try {
            ORawBuffer buff = cluster.readRecordIfVersionIsNotLatest(rid.getClusterPosition(), recordVersion);
            if (buff != null && OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Read record %s v.%s size=%d bytes (thread=%d tx=%s)", rid, buff.version, buff.buffer != null ? buff.buffer.length : 0, Thread.currentThread().getId(), this.getStorageTransaction() != null);
            }
            this.recordRead.incrementAndGet();
            return buff;
        }
        catch (IOException e) {
            throw OException.wrapException(new OStorageException("Error during read of record with rid = " + rid), e);
        }
    }

    private void addDefaultClusters() throws IOException {
        String storageCompression = this.getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD);
        String storageEncryption = this.getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD);
        String encryptionKey = this.getConfiguration().getContextConfiguration().getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY);
        String stgConflictStrategy = this.getConflictStrategy().getName();
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "internal", null, true, 20.0f, 4.0f, storageCompression, storageEncryption, encryptionKey, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "index", null, false, 1.2f, 1.2f, storageCompression, storageEncryption, encryptionKey, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "manindex", null, false, 1.0f, 1.0f, storageCompression, storageEncryption, encryptionKey, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
        this.defaultClusterId = this.createClusterFromConfig(new OStoragePaginatedClusterConfiguration(this.configuration, this.clusters.size(), "default", null, true, 1.2f, 1.2f, storageCompression, storageEncryption, encryptionKey, stgConflictStrategy, OStorageClusterConfiguration.STATUS.ONLINE));
    }

    private int createClusterFromConfig(OStorageClusterConfiguration config) throws IOException {
        OCluster cluster = this.clusterMap.get(config.getName().toLowerCase(this.configuration.getLocaleInstance()));
        if (cluster != null) {
            cluster.configure(this, config);
            return -1;
        }
        cluster = config.getStatus() == OStorageClusterConfiguration.STATUS.ONLINE ? OPaginatedClusterFactory.INSTANCE.createCluster(config.getName(), this.configuration.getVersion(), this) : new OOfflineCluster(this, config.getId(), config.getName());
        cluster.configure(this, config);
        return this.registerCluster(cluster);
    }

    private void setCluster(int id, OCluster cluster) {
        if (this.clusters.size() <= id) {
            while (this.clusters.size() < id) {
                this.clusters.add(null);
            }
            this.clusters.add(cluster);
        } else {
            this.clusters.set(id, cluster);
        }
    }

    private int registerCluster(OCluster cluster) throws IOException {
        int id;
        if (cluster != null) {
            if (this.clusterMap.containsKey(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()))) {
                throw new OConfigurationException("Cannot add cluster '" + cluster.getName() + "' because it is already registered in database '" + this.name + "'");
            }
            this.clusterMap.put(cluster.getName().toLowerCase(this.configuration.getLocaleInstance()), cluster);
            id = cluster.getId();
        } else {
            id = this.clusters.size();
        }
        this.setCluster(id, cluster);
        return id;
    }

    private int doAddCluster(String clusterName, Object[] parameters) throws IOException {
        int clusterPos = this.clusters.size();
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i) != null) continue;
            clusterPos = i;
            break;
        }
        return this.addClusterInternal(clusterName, clusterPos, parameters);
    }

    private int addClusterInternal(String clusterName, int clusterPos, Object ... parameters) throws IOException {
        OCluster cluster;
        if (clusterName != null) {
            clusterName = clusterName.toLowerCase(this.configuration.getLocaleInstance());
            cluster = OPaginatedClusterFactory.INSTANCE.createCluster(clusterName, this.configuration.getVersion(), this);
            cluster.configure(this, clusterPos, clusterName, parameters);
        } else {
            cluster = null;
        }
        int createdClusterId = this.registerCluster(cluster);
        if (cluster != null) {
            if (!cluster.exists()) {
                cluster.create(-1);
            } else {
                cluster.open();
                ((OPaginatedCluster)cluster).registerInStorageConfig((OStorageConfigurationImpl)this.configuration);
            }
        }
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Created cluster '%s' in database '%s' with id %d. Clusters: %s", clusterName, this.url, createdClusterId, this.clusters);
        }
        return createdClusterId;
    }

    @Override
    public void onException(Throwable e) {
        try {
            this.dataFlushException = e;
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
    }

    private void doClose(boolean force, boolean onDelete) {
        if (!force && !onDelete) {
            return;
        }
        if (this.status == OStorage.STATUS.CLOSED) {
            return;
        }
        long timer = Orient.instance().getProfiler().startChrono();
        this.stateLock.acquireWriteLock();
        try {
            if (this.status == OStorage.STATUS.CLOSED) {
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            this.readCache.storeCacheState(this.writeCache);
            if (!onDelete) {
                this.makeFullCheckpoint();
            }
            this.preCloseSteps();
            this.sbTreeCollectionManager.close();
            this.clusters.clear();
            this.clusterMap.clear();
            for (OIndexEngine engine : this.indexEngines) {
                if (engine == null || engine instanceof OSBTreeIndexEngine || engine instanceof OHashTableIndexEngine) continue;
                if (onDelete) {
                    engine.delete();
                    continue;
                }
                engine.close();
            }
            this.indexEngines.clear();
            this.indexEngineNameMap.clear();
            if (this.configuration != null) {
                if (onDelete) {
                    ((OStorageConfigurationImpl)this.configuration).delete();
                } else {
                    ((OStorageConfigurationImpl)this.configuration).close();
                }
            }
            super.close(force, onDelete);
            if (this.writeCache != null) {
                this.writeCache.removeLowDiskSpaceListener(this);
                this.writeCache.removeBackgroundExceptionListener(this);
                this.writeCache.removePageIsBrokenListener(this);
            }
            if (this.writeAheadLog != null) {
                this.writeAheadLog.removeFullCheckpointListener(this);
                this.writeAheadLog.removeLowDiskSpaceListener(this);
            }
            if (this.readCache != null) {
                if (!onDelete) {
                    this.readCache.closeStorage(this.writeCache);
                } else {
                    this.readCache.deleteStorage(this.writeCache);
                }
            }
            if (this.writeAheadLog != null) {
                this.writeAheadLog.close();
                if (onDelete) {
                    this.writeAheadLog.delete();
                }
            }
            try {
                this.performanceStatisticManager.unregisterMBean(this.name, this.id);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "MBean for write cache cannot be unregistered", e, new Object[0]);
            }
            this.postCloseSteps(onDelete, this.jvmError.get() != null);
            if (this.atomicOperationsManager != null) {
                try {
                    this.atomicOperationsManager.unregisterMBean();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "MBean for atomic opeations manager cannot be unregistered", e, new Object[0]);
                }
            }
            this.status = OStorage.STATUS.CLOSED;
        }
        catch (IOException e) {
            String message = "Error on closing of storage '" + this.name;
            OLogManager.instance().error(this, message, e, new Object[0]);
            throw OException.wrapException(new OStorageException(message), e);
        }
        finally {
            Orient.instance().getProfiler().stopChrono("db." + this.name + ".close", "Close a database", timer, "db.*.close");
            this.stateLock.releaseWriteLock();
        }
    }

    protected void closeClusters(boolean onDelete) throws IOException {
        for (OCluster cluster : this.clusters) {
            if (cluster == null) continue;
            cluster.close(!onDelete);
        }
        this.clusters.clear();
        this.clusterMap.clear();
    }

    protected void closeIndexes(boolean onDelete) {
        for (OIndexEngine engine : this.indexEngines) {
            if (engine == null) continue;
            if (onDelete) {
                engine.delete();
                continue;
            }
            engine.close();
        }
        this.indexEngines.clear();
        this.indexEngineNameMap.clear();
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    private byte[] checkAndIncrementVersion(OCluster iCluster, ORecordId rid, AtomicInteger version, AtomicInteger iDatabaseVersion, byte[] iRecordContent, byte iRecordType) {
        int v = version.get();
        switch (v) {
            case -1: {
                iDatabaseVersion.incrementAndGet();
                break;
            }
            case -2: {
                break;
            }
            default: {
                if (v < -2) {
                    version.set(ORecordVersionHelper.clearRollbackMode(v));
                    iDatabaseVersion.set(version.get());
                    break;
                }
                if (v != iDatabaseVersion.get()) {
                    ORecordConflictStrategy strategy = iCluster.getRecordConflictStrategy() != null ? iCluster.getRecordConflictStrategy() : this.recordConflictStrategy;
                    return strategy.onUpdate(this, iRecordType, rid, v, iRecordContent, iDatabaseVersion);
                }
                iDatabaseVersion.incrementAndGet();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void commitEntry(ORecordOperation txEntry, OPhysicalPosition allocated) throws IOException {
        rec = txEntry.getRecord();
        if (txEntry.type != 2 && !rec.isDirty()) {
            return;
        }
        rid = (ORecordId)rec.getIdentity();
        if (txEntry.type == 1 && rid.isNew()) {
            txEntry.type = (byte)3;
        }
        ORecordSerializationContext.pushContext();
        try {
            cluster = this.getClusterById(rid.getClusterId());
            if (cluster.getName().equals("index") || cluster.getName().equals("manindex")) {
                return;
            }
            if (rec instanceof OTxListener) {
                ((OTxListener)rec).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
            }
            switch (txEntry.type) {
                case 0: {
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                case 3: 
                case 4: {
                    stream = rec.toStream();
                    if (allocated != null) {
                        recordType = ORecordInternal.getRecordType(rec);
                        ppos = this.doCreateRecord(rid, stream, rec.getVersion(), recordType, null, cluster, new OPhysicalPosition(recordType), allocated).getResult();
                        ORecordInternal.setVersion(rec, ppos.recordVersion);
                        ** break;
lbl26:
                        // 1 sources

                    } else {
                        updateRes = this.updateRecord(rid, ORecordInternal.isContentChanged(rec), stream, rec.getVersion(), ORecordInternal.getRecordType(rec), -1, null);
                        ORecordInternal.setVersion(rec, updateRes.getResult());
                        if (updateRes.getModifiedRecordContent() != null) {
                            ORecordInternal.fill(rec, rid, updateRes.getResult(), updateRes.getModifiedRecordContent(), false);
                            ** break;
                        }
                    }
lbl33:
                    // 3 sources

                    break;
                }
                case 1: {
                    stream = rec.toStream();
                    updateRes = this.doUpdateRecord(rid, ORecordInternal.isContentChanged(rec), stream, rec.getVersion(), ORecordInternal.getRecordType(rec), null, cluster);
                    ORecordInternal.setVersion(rec, updateRes.getResult());
                    if (updateRes.getModifiedRecordContent() != null) {
                        ORecordInternal.fill(rec, rid, updateRes.getResult(), updateRes.getModifiedRecordContent(), false);
                        ** break;
                    }
lbl42:
                    // 3 sources

                    break;
                }
                case 2: {
                    if (rec instanceof ODocument) {
                        ORidBagDeleter.deleteAllRidBags((ODocument)rec);
                    }
                    this.deleteRecord(rid, rec.getVersion(), -1, null);
                    ** break;
lbl49:
                    // 1 sources

                    break;
                }
                default: {
                    throw new OStorageException("Unknown record operation " + txEntry.type);
                }
            }
        }
        finally {
            ORecordSerializationContext.pullContext();
        }
        if (rec instanceof ODocument && ((ODocument)rec).isTrackingChanges()) {
            ODocumentInternal.clearTrackData((ODocument)rec);
        }
        ORecordInternal.unsetDirty(rec);
        if (rec instanceof OTxListener) {
            ((OTxListener)rec).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId < 0 || iClusterId > this.clusters.size() - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in database '" + this.name + "'");
        }
    }

    private OLogSequenceNumber restoreFromWAL() throws IOException {
        OWALRecord checkPointRecord;
        OLogSequenceNumber lastCheckPoint;
        if (this.writeAheadLog == null) {
            OLogManager.instance().error(this, "Restore is not possible because write ahead logging is switched off.", null, new Object[0]);
            return null;
        }
        if (this.writeAheadLog.begin() == null) {
            OLogManager.instance().warn((Object)this, "Restore is not possible because write ahead log is empty.", new Object[0]);
            return null;
        }
        OLogManager.instance().info((Object)this, "Looking for last checkpoint...", new Object[0]);
        try {
            lastCheckPoint = this.writeAheadLog.getLastCheckpoint();
        }
        catch (OWALPageBrokenException e) {
            OLogManager.instance().warn((Object)this, "WAL page is broken", e, new Object[0]);
            lastCheckPoint = null;
        }
        if (lastCheckPoint == null) {
            OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
            return this.restoreFromBegging();
        }
        try {
            checkPointRecord = this.writeAheadLog.read(lastCheckPoint);
        }
        catch (OWALPageBrokenException e) {
            OLogManager.instance().warn((Object)this, "WAL page is broken", e, new Object[0]);
            checkPointRecord = null;
        }
        if (checkPointRecord == null) {
            OLogManager.instance().info((Object)this, "Checkpoints are absent, the restore will start from the beginning.", new Object[0]);
            return this.restoreFromBegging();
        }
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            OLogManager.instance().info((Object)this, "Found FUZZY checkpoint.", new Object[0]);
            boolean fuzzyCheckPointIsComplete = this.checkFuzzyCheckPointIsComplete(lastCheckPoint);
            if (!fuzzyCheckPointIsComplete) {
                OLogManager.instance().warn((Object)this, "FUZZY checkpoint is not complete.", new Object[0]);
                OLogSequenceNumber previousCheckpoint = ((OFuzzyCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                checkPointRecord = null;
                if (previousCheckpoint != null) {
                    checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                }
                if (checkPointRecord != null) {
                    OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                    return this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                }
                OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                return this.restoreFromBegging();
            }
            return this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            OLogManager.instance().info((Object)this, "FULL checkpoint found.", new Object[0]);
            boolean fullCheckPointIsComplete = this.checkFullCheckPointIsComplete(lastCheckPoint);
            if (!fullCheckPointIsComplete) {
                OLogManager.instance().warn((Object)this, "FULL checkpoint has not completed.", new Object[0]);
                OLogSequenceNumber previousCheckpoint = ((OFullCheckpointStartRecord)checkPointRecord).getPreviousCheckpoint();
                checkPointRecord = null;
                if (previousCheckpoint != null) {
                    checkPointRecord = this.writeAheadLog.read(previousCheckpoint);
                }
                if (checkPointRecord != null) {
                    OLogManager.instance().warn((Object)this, "Restore will start from the previous checkpoint.", new Object[0]);
                    return this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
                }
                OLogManager.instance().warn((Object)this, "Restore will start from the beginning.", new Object[0]);
                return this.restoreFromBegging();
            }
            return this.restoreFromCheckPoint((OAbstractCheckPointStartRecord)checkPointRecord);
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private boolean checkFullCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OCheckpointEndRecord) {
                    return true;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException e) {
            OLogManager.instance().warn((Object)this, "WAL page is broken", e, new Object[0]);
            return false;
        }
        return false;
    }

    @Override
    public String incrementalBackup(String backupDirectory) {
        throw new IllegalStateException("Incremental backup is supported only in enterprise version");
    }

    @Override
    public void restoreFromIncrementalBackup(String filePath) {
        throw new IllegalStateException("Incremental backup is supported only in enterprise version");
    }

    private boolean checkFuzzyCheckPointIsComplete(OLogSequenceNumber lastCheckPoint) throws IOException {
        try {
            OLogSequenceNumber lsn = this.writeAheadLog.next(lastCheckPoint);
            while (lsn != null) {
                OWALRecord walRecord = this.writeAheadLog.read(lsn);
                if (walRecord instanceof OFuzzyCheckpointEndRecord) {
                    return true;
                }
                lsn = this.writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException e) {
            OLogManager.instance().warn((Object)this, "WAL page is broken", e, new Object[0]);
            return false;
        }
        return false;
    }

    private OLogSequenceNumber restoreFromCheckPoint(OAbstractCheckPointStartRecord checkPointRecord) throws IOException {
        if (checkPointRecord instanceof OFuzzyCheckpointStartRecord) {
            return this.restoreFromFuzzyCheckPoint((OFuzzyCheckpointStartRecord)checkPointRecord);
        }
        if (checkPointRecord instanceof OFullCheckpointStartRecord) {
            return this.restoreFromFullCheckPoint((OFullCheckpointStartRecord)checkPointRecord);
        }
        throw new OStorageException("Unknown checkpoint record type " + checkPointRecord.getClass().getName());
    }

    private OLogSequenceNumber restoreFromFullCheckPoint(OFullCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure from full checkpoint is started. Restore is performed from LSN %s", checkPointRecord.getLsn());
        OLogSequenceNumber lsn = this.writeAheadLog.next(checkPointRecord.getLsn());
        return this.restoreFrom(lsn, this.writeAheadLog);
    }

    private OLogSequenceNumber restoreFromFuzzyCheckPoint(OFuzzyCheckpointStartRecord checkPointRecord) throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure from FUZZY checkpoint is started.", new Object[0]);
        OLogSequenceNumber flushedLsn = checkPointRecord.getFlushedLsn();
        if (flushedLsn.compareTo(this.writeAheadLog.begin()) < 0) {
            flushedLsn = this.writeAheadLog.begin();
        }
        return this.restoreFrom(flushedLsn, this.writeAheadLog);
    }

    private OLogSequenceNumber restoreFromBegging() throws IOException {
        OLogManager.instance().info((Object)this, "Data restore procedure is started.", new Object[0]);
        OLogSequenceNumber lsn = this.writeAheadLog.begin();
        return this.restoreFrom(lsn, this.writeAheadLog);
    }

    protected OLogSequenceNumber restoreFrom(OLogSequenceNumber lsn, OWriteAheadLog writeAheadLog) throws IOException {
        OLogSequenceNumber logSequenceNumber = null;
        OModifiableBoolean atLeastOnePageUpdate = new OModifiableBoolean();
        long recordsProcessed = 0L;
        int reportBatchSize = OGlobalConfiguration.WAL_REPORT_AFTER_OPERATIONS_DURING_RESTORE.getValueAsInteger();
        HashMap operationUnits = new HashMap();
        long lastReportTime = 0L;
        try {
            while (lsn != null) {
                logSequenceNumber = lsn;
                OWALRecord walRecord = writeAheadLog.read(lsn);
                if (walRecord instanceof OAtomicUnitEndRecord) {
                    OAtomicUnitEndRecord atomicUnitEndRecord = (OAtomicUnitEndRecord)walRecord;
                    List atomicUnit = (List)operationUnits.remove(atomicUnitEndRecord.getOperationUnitId());
                    if (atomicUnit != null) {
                        atomicUnit.add(walRecord);
                        this.restoreAtomicUnit(atomicUnit, atLeastOnePageUpdate);
                    }
                } else if (walRecord instanceof OAtomicUnitStartRecord) {
                    ArrayList<OWALRecord> operationList = new ArrayList<OWALRecord>();
                    assert (!operationUnits.containsKey(((OAtomicUnitStartRecord)walRecord).getOperationUnitId()));
                    operationUnits.put(((OAtomicUnitStartRecord)walRecord).getOperationUnitId(), operationList);
                    operationList.add(walRecord);
                } else if (walRecord instanceof OOperationUnitRecord) {
                    OOperationUnitRecord operationUnitRecord = (OOperationUnitRecord)walRecord;
                    ArrayList<OOperationUnitRecord> operationList = (ArrayList<OOperationUnitRecord>)operationUnits.get(operationUnitRecord.getOperationUnitId());
                    if (operationList == null) {
                        operationList = new ArrayList<OOperationUnitRecord>();
                        operationUnits.put(operationUnitRecord.getOperationUnitId(), operationList);
                    }
                    operationList.add(operationUnitRecord);
                } else if (walRecord instanceof ONonTxOperationPerformedWALRecord) {
                    if (!this.isIndexRebuildScheduledInternal()) {
                        OLogManager.instance().warn((Object)this, "Non tx operation was used during data modification we will need index rebuild.", new Object[0]);
                        this.scheduleIndexRebuild();
                    }
                } else {
                    OLogManager.instance().warn((Object)this, "Record %s will be skipped during data restore", walRecord);
                }
                long currentTime = System.currentTimeMillis();
                if (reportBatchSize > 0 && ++recordsProcessed % (long)reportBatchSize == 0L || currentTime - lastReportTime > 30000L) {
                    OLogManager.instance().info((Object)this, "%d operations were processed, current LSN is %s last LSN is %s", recordsProcessed, lsn, writeAheadLog.end());
                    lastReportTime = currentTime;
                }
                lsn = writeAheadLog.next(lsn);
            }
        }
        catch (OWALPageBrokenException e) {
            OLogManager.instance().error(this, "Data restore was paused because broken WAL page was found. The rest of changes will be rolled back.", e, new Object[0]);
        }
        catch (RuntimeException e) {
            OLogManager.instance().error(this, "Data restore was paused because of exception. The rest of changes will be rolled back and WAL files will be backed up. Please report issue about this exception to bug tracker and provide WAL files which are backed up in 'wal_backup' directory.", e, new Object[0]);
            this.backUpWAL(e);
        }
        if (atLeastOnePageUpdate.getValue()) {
            return logSequenceNumber;
        }
        return null;
    }

    private void backUpWAL(Exception e) {
        try {
            boolean created;
            File rootDir = new File(this.configuration.getDirectory());
            File backUpDir = new File(rootDir, "wal_backup");
            if (!backUpDir.exists() && !(created = backUpDir.mkdir())) {
                OLogManager.instance().error(this, "Cannot create directory for backup files " + backUpDir.getAbsolutePath(), null, new Object[0]);
                return;
            }
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd_MM_yy_HH_mm_ss");
            String strDate = dateFormat.format(date);
            String archiveName = "wal_backup_" + strDate + ".zip";
            String metadataName = "wal_metadata_" + strDate + ".txt";
            File archiveFile = new File(backUpDir, archiveName);
            if (!archiveFile.createNewFile()) {
                OLogManager.instance().error(this, "Cannot create backup file " + archiveFile.getAbsolutePath(), null, new Object[0]);
                return;
            }
            FileOutputStream archiveOutputStream = new FileOutputStream(archiveFile);
            ZipOutputStream archiveZipOutputStream = new ZipOutputStream(new BufferedOutputStream(archiveOutputStream));
            ZipEntry metadataEntry = new ZipEntry(metadataName);
            archiveZipOutputStream.putNextEntry(metadataEntry);
            PrintWriter metadataFileWriter = new PrintWriter(new OutputStreamWriter((OutputStream)archiveZipOutputStream, "UTF-8"));
            metadataFileWriter.append("Storage name : ").append(this.getName()).append("\r\n");
            metadataFileWriter.append("Date : ").append(strDate).append("\r\n");
            metadataFileWriter.append("Stacktrace : \r\n");
            e.printStackTrace(metadataFileWriter);
            metadataFileWriter.flush();
            archiveZipOutputStream.closeEntry();
            List<String> walPaths = ((ODiskWriteAheadLog)this.writeAheadLog).getWalFiles();
            for (String walSegment : walPaths) {
                this.archiveEntry(archiveZipOutputStream, walSegment);
            }
            this.archiveEntry(archiveZipOutputStream, ((ODiskWriteAheadLog)this.writeAheadLog).getWMRFile());
            archiveZipOutputStream.close();
        }
        catch (IOException ioe) {
            OLogManager.instance().error(this, "Error during WAL backup", ioe, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveEntry(ZipOutputStream archiveZipOutputStream, String walSegment) throws IOException {
        File walFile = new File(walSegment);
        ZipEntry walZipEntry = new ZipEntry(walFile.getName());
        archiveZipOutputStream.putNextEntry(walZipEntry);
        try {
            FileInputStream walInputStream = new FileInputStream(walFile);
            try {
                BufferedInputStream walBufferedInputStream = new BufferedInputStream(walInputStream);
                try {
                    byte[] buffer = new byte[1024];
                    int readBytes = 0;
                    while ((readBytes = walBufferedInputStream.read(buffer)) > -1) {
                        archiveZipOutputStream.write(buffer, 0, readBytes);
                    }
                }
                finally {
                    walBufferedInputStream.close();
                }
            }
            finally {
                walInputStream.close();
            }
        }
        finally {
            archiveZipOutputStream.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAtomicUnit(List<OWALRecord> atomicUnit, OModifiableBoolean atLeastOnePageUpdate) throws IOException {
        assert (atomicUnit.get(atomicUnit.size() - 1) instanceof OAtomicUnitEndRecord);
        for (OWALRecord walRecord : atomicUnit) {
            if (walRecord instanceof OFileDeletedWALRecord) {
                OFileDeletedWALRecord fileDeletedWALRecord = (OFileDeletedWALRecord)walRecord;
                if (!this.writeCache.exists(fileDeletedWALRecord.getFileId())) continue;
                this.readCache.deleteFile(fileDeletedWALRecord.getFileId(), this.writeCache);
                continue;
            }
            if (walRecord instanceof OFileCreatedWALRecord) {
                OFileCreatedWALRecord fileCreatedCreatedWALRecord = (OFileCreatedWALRecord)walRecord;
                if (this.writeCache.exists(fileCreatedCreatedWALRecord.getFileName())) continue;
                this.readCache.addFile(fileCreatedCreatedWALRecord.getFileName(), fileCreatedCreatedWALRecord.getFileId(), this.writeCache);
                continue;
            }
            if (walRecord instanceof OUpdatePageRecord) {
                OUpdatePageRecord updatePageRecord = (OUpdatePageRecord)walRecord;
                long fileId = updatePageRecord.getFileId();
                if (!this.writeCache.exists(fileId)) {
                    String fileName = this.writeCache.restoreFileById(fileId);
                    if (fileName == null) {
                        throw new OStorageException("File with id " + fileId + " was deleted from storage, the rest of operations can not be restored");
                    }
                    OLogManager.instance().warn((Object)this, "Previously deleted file with name " + fileName + " was deleted but new empty file was added to continue restore process", new Object[0]);
                }
                long pageIndex = updatePageRecord.getPageIndex();
                OCacheEntry cacheEntry = this.readCache.load(fileId = this.writeCache.externalFileId(this.writeCache.internalFileId(fileId)), pageIndex, true, this.writeCache, 1, false);
                if (cacheEntry == null) {
                    do {
                        if (cacheEntry == null) continue;
                        this.readCache.release(cacheEntry, this.writeCache);
                    } while ((cacheEntry = this.readCache.allocateNewPage(fileId, this.writeCache, false)).getPageIndex() != pageIndex);
                }
                OCachePointer cachePointer = cacheEntry.getCachePointer();
                cachePointer.acquireExclusiveLock();
                try {
                    ODurablePage durablePage = new ODurablePage(cacheEntry, null);
                    durablePage.restoreChanges(updatePageRecord.getChanges());
                    durablePage.setLsn(updatePageRecord.getLsn());
                }
                finally {
                    cachePointer.releaseExclusiveLock();
                    this.readCache.release(cacheEntry, this.writeCache);
                }
                atLeastOnePageUpdate.setValue(true);
                continue;
            }
            if (walRecord instanceof OAtomicUnitStartRecord || walRecord instanceof OAtomicUnitEndRecord) continue;
            OLogManager.instance().error(this, "Invalid WAL record type was passed %s. Given record will be skipped.", null, walRecord.getClass());
            assert (false) : "Invalid WAL record type was passed " + walRecord.getClass().getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLowDiskSpaceRequestsAndReadOnlyConditions() {
        if (this.transaction.get() != null) {
            return;
        }
        if (this.lowDiskSpace != null && this.checkpointInProgress.compareAndSet(false, true)) {
            try {
                this.writeCache.makeFuzzyCheckpoint();
                if (this.writeCache.checkLowDiskSpace()) {
                    this.synch();
                    if (this.writeCache.checkLowDiskSpace()) {
                        throw new OLowDiskSpaceException("Error occurred while executing a write operation to database '" + this.name + "' due to limited free space on the disk (" + this.lowDiskSpace.freeSpace / 0x100000L + " MB). The database is now working in read-only mode. Please close the database (or stop OrientDB), make room on your hard drive and then reopen the database. The minimal required space is " + this.lowDiskSpace.requiredSpace / 0x100000L + " MB. Required space is now set to " + OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsInteger() + "MB (you can change it by setting parameter " + OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getKey() + ") .");
                    }
                    this.lowDiskSpace = null;
                } else {
                    this.lowDiskSpace = null;
                }
            }
            finally {
                this.checkpointInProgress.set(false);
            }
        }
        if (this.checkpointRequest && this.writeAheadLog instanceof ODiskWriteAheadLog && this.checkpointInProgress.compareAndSet(false, true)) {
            try {
                ODiskWriteAheadLog diskWriteAheadLog = (ODiskWriteAheadLog)this.writeAheadLog;
                long size = diskWriteAheadLog.size();
                this.writeCache.makeFuzzyCheckpoint();
                if (size <= diskWriteAheadLog.size()) {
                    this.synch();
                }
                this.checkpointRequest = false;
            }
            finally {
                this.checkpointInProgress.set(false);
            }
        }
        if (this.dataFlushException != null) {
            throw OException.wrapException(new OStorageException("Error in data flush background thread, please restart database and send full stack trace inside of bug report"), this.dataFlushException);
        }
        if (!this.brokenPages.isEmpty()) {
            HashMap pagesByFile = new HashMap();
            for (OPair<String, Long> brokenPage : this.brokenPages) {
                TreeSet sortedPages = (TreeSet)pagesByFile.get(brokenPage.key);
                if (sortedPages == null) {
                    sortedPages = new TreeSet();
                    pagesByFile.put(brokenPage.key, sortedPages);
                }
                sortedPages.add(brokenPage.value);
            }
            StringBuilder brokenPagesList = new StringBuilder();
            brokenPagesList.append("[");
            for (String fileName : pagesByFile.keySet()) {
                brokenPagesList.append('\'').append(fileName).append("' :");
                SortedSet pageIndexes = (SortedSet)pagesByFile.get(fileName);
                long lastPage = (Long)pageIndexes.last();
                for (Long pageIndex : (SortedSet)pagesByFile.get(fileName)) {
                    brokenPagesList.append(pageIndex);
                    if (pageIndex == lastPage) continue;
                    brokenPagesList.append(", ");
                }
                brokenPagesList.append(";");
            }
            brokenPagesList.append("]");
            throw new OPageIsBrokenException("Following files and pages are detected to be broken " + brokenPagesList + ", storage is switched to 'read only' mode. Any modification operations are prohibited. To restore database and make it fully operational you may export and import database to and from JSON.");
        }
        if (this.jvmError.get() != null) {
            throw new OJVMErrorException("JVM error '" + this.jvmError.get().getClass().getSimpleName() + " : " + this.jvmError.get().getMessage() + "' occurred during data processing, storage is switched to 'read-only' mode. To prevent this exception please restart the JVM and check data consistency by calling of 'check database' command from database console.");
        }
    }

    protected Map<Integer, List<ORecordId>> getRidsGroupedByCluster(Collection<ORecordId> iRids) {
        HashMap<Integer, List<ORecordId>> ridsPerCluster = new HashMap<Integer, List<ORecordId>>();
        for (ORecordId rid : iRids) {
            ArrayList<ORecordId> rids = (ArrayList<ORecordId>)ridsPerCluster.get(rid.getClusterId());
            if (rids == null) {
                rids = new ArrayList<ORecordId>(iRids.size());
                ridsPerCluster.put(rid.getClusterId(), rids);
            }
            rids.add(rid);
        }
        return ridsPerCluster;
    }

    private void lockIndexKeys(OIndexManagerProxy manager, TreeMap<String, OTransactionIndexChanges> indexes, List<Lock[]> lockList) {
        for (Map.Entry<String, OTransactionIndexChanges> entry : indexes.entrySet()) {
            String indexName = entry.getKey();
            OTransactionIndexChanges changes = entry.getValue();
            OIndexInternal<?> index = changes.resolveAssociatedIndex(indexName, manager);
            if (index == null) {
                throw new OTransactionException("Cannot find index '" + indexName + "' while committing transaction");
            }
            if (!(index instanceof OIndexUnique)) continue;
            if (!changes.nullKeyChanges.entries.isEmpty()) {
                index.lockKeysForUpdate(new Object[]{null});
            }
            lockList.add(index.lockKeysForUpdate(changes.changesPerKey.keySet()));
        }
    }

    private void unlockIndexKeys(TreeMap<String, OTransactionIndexChanges> indexes, List<Lock[]> lockList) {
        for (OTransactionIndexChanges changes : indexes.values()) {
            OIndexInternal<?> index = changes.getAssociatedIndex();
            if (index == null || !(index instanceof OIndexUnique) || changes.nullKeyChanges.entries.isEmpty()) continue;
            index.releaseKeysForUpdate(new Object[]{null});
        }
        Iterator<OTransactionIndexChanges> iterator = lockList.iterator();
        while (iterator.hasNext()) {
            Lock[] locks;
            for (Lock lock : locks = (Lock[])iterator.next()) {
                lock.unlock();
            }
        }
    }

    private void lockIndexes(TreeMap<String, OTransactionIndexChanges> indexes) {
        for (OTransactionIndexChanges changes : indexes.values()) {
            assert (changes.changesPerKey instanceof TreeMap);
            final OIndexInternal<?> index = changes.getAssociatedIndex();
            ArrayList orderedIndexNames = new ArrayList(changes.changesPerKey.keySet());
            if (orderedIndexNames.size() > 1) {
                Collections.sort(orderedIndexNames, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        String i1 = index.getIndexNameByKey(o1);
                        String i2 = index.getIndexNameByKey(o2);
                        return i1.compareTo(i2);
                    }
                });
            }
            boolean fullyLocked = false;
            for (Object key : orderedIndexNames) {
                if (!index.acquireAtomicExclusiveLock(key)) continue;
                fullyLocked = true;
                break;
            }
            if (fullyLocked || changes.nullKeyChanges.entries.isEmpty()) continue;
            index.acquireAtomicExclusiveLock(null);
        }
    }

    private void lockClusters(TreeMap<Integer, OCluster> clustersToLock) {
        for (OCluster cluster : clustersToLock.values()) {
            cluster.acquireAtomicExclusiveLock();
        }
    }

    private void lockRidBags(TreeMap<Integer, OCluster> clusters, TreeMap<String, OTransactionIndexChanges> indexes) {
        OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
        for (Integer n : clusters.keySet()) {
            this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(atomicOperation, OSBTreeCollectionManagerAbstract.generateLockName(n));
        }
        for (Map.Entry entry : indexes.entrySet()) {
            String indexName = (String)entry.getKey();
            OIndexInternal<?> index = ((OTransactionIndexChanges)entry.getValue()).getAssociatedIndex();
            if (index.isUnique()) continue;
            this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(atomicOperation, OIndexRIDContainerSBTree.generateLockName(indexName));
        }
    }

    public AtomicLong getRecordScanned() {
        return this.recordScanned;
    }

    protected RuntimeException logAndPrepareForRethrow(RuntimeException runtimeException) {
        if (!(runtimeException instanceof OHighLevelException) && !(runtimeException instanceof ONeedRetryException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", runtimeException, System.identityHashCode(runtimeException), this.getURL(), OConstants.getVersion());
        }
        return runtimeException;
    }

    protected Error logAndPrepareForRethrow(Error error) {
        return this.logAndPrepareForRethrow(error, true);
    }

    private Error logAndPrepareForRethrow(Error error, boolean swithcInReadOnlyMode) {
        if (!(error instanceof OHighLevelException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", error, System.identityHashCode(error), this.getURL(), OConstants.getVersion());
        }
        if (swithcInReadOnlyMode) {
            this.handleJVMError(error);
        }
        return error;
    }

    protected RuntimeException logAndPrepareForRethrow(Throwable throwable) {
        if (!(throwable instanceof OHighLevelException) && !(throwable instanceof ONeedRetryException)) {
            OLogManager.instance().errorStorage(this, "Exception `%08X` in storage `%s`: %s", throwable, System.identityHashCode(throwable), this.getURL(), OConstants.getVersion());
        }
        return new RuntimeException(throwable);
    }

    @Override
    public void updateConfiguration() {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            ((OStorageConfigurationImpl)this.configuration).update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setRecordSerializer(String recordSerializer, int version) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setRecordSerializer(recordSerializer);
            storageConfiguration.setRecordSerializerVersion(version);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setProperty(String property, String value) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setProperty(property, value);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setDateFormat(String dateFormat) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setDateFormat(dateFormat);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setDateTimeFormat(String dateTimeFormat) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setDateTimeFormat(dateTimeFormat);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setTimeZone(timeZone);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setLocaleCountry(String localeCountry) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setLocaleCountry(localeCountry);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setLocaleLanguage(String localeLanguage) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setLocaleLanguage(localeLanguage);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setCharset(String charset) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setCharset(charset);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setClusterSelection(String clusterSelection) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setClusterSelection(clusterSelection);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setMinimumClusters(int minimumClusters) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setMinimumClusters(minimumClusters);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setValidation(boolean validation) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setValidation(validation);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void clearProperties() {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.clearProperties();
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void removeProperty(String property) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.removeProperty(property);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setSchemaRecordId(String schemaRecordId) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setSchemaRecordId(schemaRecordId);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    @Override
    public void setIndexMgrRecordId(String indexMgrRecordId) {
        this.checkOpeness();
        this.stateLock.acquireWriteLock();
        try {
            this.checkOpeness();
            OStorageConfigurationImpl storageConfiguration = (OStorageConfigurationImpl)this.configuration;
            storageConfiguration.setIndexMgrRecordId(indexMgrRecordId);
            storageConfiguration.update();
        }
        catch (RuntimeException ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Error ee) {
            throw this.logAndPrepareForRethrow(ee);
        }
        catch (Throwable t2) {
            throw this.logAndPrepareForRethrow(t2);
        }
        finally {
            this.stateLock.releaseWriteLock();
        }
    }

    private static class ORIDOLockManager
    extends OComparableLockManager<ORID> {
        public ORIDOLockManager(int amountOfCachedInstances) {
            super(true, -1);
        }

        @Override
        protected ORID getImmutableResourceId(ORID iResourceId) {
            return new ORecordId(iResourceId);
        }
    }
}

