/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.server.OServer;
import java.util.concurrent.ConcurrentHashMap;

public class OSystemDatabase {
    public static final String SYSTEM_DB_NAME = "OSystem";
    private final OServer server;

    public OSystemDatabase(OServer server) {
        this.server = server;
        this.init();
    }

    public String getSystemDatabaseName() {
        return SYSTEM_DB_NAME;
    }

    public String getSystemDatabasePath() {
        return this.server.getDatabaseDirectory() + this.getSystemDatabaseName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCluster(String className, String clusterName) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentInternal sysdb = this.openSystemDatabase();
            try {
                if (!sysdb.existsCluster(clusterName)) {
                    OSchema schema = sysdb.getMetadata().getSchema();
                    OClass cls = schema.getClass(className);
                    if (cls != null) {
                        cls.addCluster(clusterName);
                    } else {
                        OLogManager.instance().error(this, "createCluster() Class name %s does not exist", null, className);
                    }
                }
            }
            finally {
                sysdb.close();
            }
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    public ODatabaseDocumentInternal openSystemDatabase() {
        return this.server.openDatabase(this.getSystemDatabaseName(), "OSuperUser", "", null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(OCallable<Object, Object> callback, String sql, Object ... args) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            Object result;
            ODatabaseDocumentInternal db;
            block10: {
                db = this.openSystemDatabase();
                try {
                    result = db.command(new OCommandSQL(sql)).execute(args);
                    if (callback == null) break block10;
                    Object object = callback.call(result);
                    db.close();
                    return object;
                }
                catch (Throwable throwable) {
                    db.close();
                    throw throwable;
                }
            }
            Object RET = result;
            db.close();
            return RET;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    public ODocument save(ODocument document) {
        return this.save(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument save(ODocument document, String clusterName) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentInternal db;
            block10: {
                ODocument oDocument;
                db = this.openSystemDatabase();
                try {
                    if (clusterName == null) break block10;
                    oDocument = (ODocument)db.save(document, clusterName);
                }
                catch (Throwable throwable) {
                    db.close();
                    throw throwable;
                }
                db.close();
                return oDocument;
            }
            ODocument oDocument = (ODocument)db.save(document);
            db.close();
            return oDocument;
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ODatabaseRecordThreadLocal tl = ODatabaseRecordThreadLocal.instance();
        ODatabaseDocumentInternal oldDbInThread = tl != null ? tl.getIfDefined() : null;
        try {
            ODatabaseDocumentTx sysDB = new ODatabaseDocumentTx("plocal:" + this.getSystemDatabasePath());
            if (!sysDB.exists()) {
                OLogManager.instance().info((Object)this, "Creating the system database '%s' for current server", SYSTEM_DB_NAME);
                ConcurrentHashMap<OGlobalConfiguration, Object> settings = new ConcurrentHashMap<OGlobalConfiguration, Object>();
                settings.put(OGlobalConfiguration.CREATE_DEFAULT_USERS, false);
                settings.put(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, 1);
                sysDB.create(settings);
                sysDB.close();
            }
        }
        finally {
            if (oldDbInThread != null) {
                ODatabaseRecordThreadLocal.instance().set(oldDbInThread);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInDBScope(OCallable<Void, ODatabase> callback) {
        ODatabaseDocumentInternal currentDB = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentInternal db = this.openSystemDatabase();
            try {
                callback.call(db);
            }
            finally {
                db.close();
            }
        }
        finally {
            if (currentDB != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDB);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        ODatabaseDocumentInternal oldDbInThread = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentTx sysDB = new ODatabaseDocumentTx("plocal:" + this.getSystemDatabasePath());
            boolean bl = sysDB.exists();
            return bl;
        }
        finally {
            if (oldDbInThread != null) {
                ODatabaseRecordThreadLocal.instance().set(oldDbInThread);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }
}

