/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OStreamable;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;

public class ODistributedMomentum
implements OStreamable {
    private static final String LAST_OPERATION_TIME_STAMP = "lastOperationTimeStamp";
    private static final String VERSION = "version";
    private final ODocument configuration;

    public ODistributedMomentum() {
        this.configuration = new ODocument();
    }

    public ODistributedMomentum(ODocument document) {
        this.configuration = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber getLSN(String iNode) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            ODocument embedded = (ODocument)this.configuration.field(iNode);
            if (embedded == null) {
                return null;
            }
            return new OLogSequenceNumber((Long)embedded.field("segment"), (Long)embedded.field("position"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLSN(String iNode, OLogSequenceNumber iLSN) {
        ODocument embedded = new ODocument();
        embedded.field("segment", iLSN.getSegment(), OType.LONG);
        embedded.field("position", iLSN.getPosition(), OType.LONG);
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            this.configuration.field(iNode, embedded, OType.EMBEDDED);
            this.incrementVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastOperationTimestamp() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            Long ts = (Long)this.configuration.field(LAST_OPERATION_TIME_STAMP);
            if (ts == null) {
                return -1L;
            }
            return ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastOperationTimestamp(long lastOperationTimestamp) {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            this.configuration.field(LAST_OPERATION_TIME_STAMP, lastOperationTimestamp);
            this.incrementVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return this.configuration.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromJSON(InputStream is) throws IOException {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            this.configuration.fromJSON(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJSON(OutputStream os) throws IOException {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            this.configuration.toJSON(os);
        }
    }

    private void incrementVersion() {
        Integer oldVersion = (Integer)this.configuration.field(VERSION);
        if (oldVersion == null) {
            oldVersion = 0;
        }
        this.configuration.field(VERSION, oldVersion + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toStream(DataOutput out) throws IOException {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            byte[] buffer = this.configuration.toStream();
            out.writeInt(buffer.length);
            out.write(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromStream(DataInput in) throws IOException {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            int length = in.readInt();
            byte[] buffer = new byte[length];
            in.readFully(buffer);
            this.configuration.fromStream(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODistributedMomentum copy() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return new ODistributedMomentum(this.configuration.copy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            return this.configuration.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getServers() {
        ArrayList<String> result = new ArrayList<String>();
        ODocument oDocument = this.configuration;
        synchronized (oDocument) {
            for (String s2 : this.configuration.fieldNames()) {
                if (LAST_OPERATION_TIME_STAMP.equals(s2) || VERSION.equals(s2)) continue;
                result.add(s2);
            }
        }
        return result;
    }
}

