/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerHookConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import java.lang.reflect.Method;
import java.util.List;

public class OConfigurableHooksManager
implements ODatabaseLifecycleListener {
    private List<OServerHookConfiguration> configuredHooks;

    public OConfigurableHooksManager(OServerConfiguration iCfg) {
        this.configuredHooks = iCfg.hooks;
        if (this.configuredHooks != null && !this.configuredHooks.isEmpty()) {
            Orient.instance().addDbLifecycleListener(this);
        }
    }

    @Override
    public ODatabaseLifecycleListener.PRIORITY getPriority() {
        return ODatabaseLifecycleListener.PRIORITY.LAST;
    }

    @Override
    public void onCreate(ODatabaseInternal iDatabase) {
        this.onOpen(iDatabase);
    }

    @Override
    public void onOpen(ODatabaseInternal iDatabase) {
        if (!iDatabase.getStorage().isRemote()) {
            ODatabaseInternal db = iDatabase;
            for (OServerHookConfiguration hook : this.configuredHooks) {
                try {
                    ORecordHook.HOOK_POSITION pos = ORecordHook.HOOK_POSITION.valueOf(hook.position);
                    ORecordHook h2 = (ORecordHook)Class.forName(hook.clazz).newInstance();
                    if (hook.parameters != null && hook.parameters.length > 0) {
                        try {
                            Method m4 = h2.getClass().getDeclaredMethod("config", OServerParameterConfiguration[].class);
                            m4.invoke((Object)h2, new Object[]{hook.parameters});
                        }
                        catch (Exception e) {
                            OLogManager.instance().warn((Object)this, "[configure] Failed to configure hook '%s'. Parameters specified but hook don support parameters. Should have a method config with parameters OServerParameterConfiguration[] ", hook.clazz);
                        }
                    }
                    db.registerHook(h2, pos);
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "[configure] Failed to configure hook '%s' due to the an error : ", e, hook.clazz, e.getMessage());
                }
            }
        }
    }

    @Override
    public void onClose(ODatabaseInternal iDatabase) {
    }

    @Override
    public void onDrop(ODatabaseInternal iDatabase) {
    }

    @Override
    public void onCreateClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    @Override
    public void onDropClass(ODatabaseInternal iDatabase, OClass iClass) {
    }

    @Override
    public void onLocalNodeConfigurationRequest(ODocument iConfiguration) {
    }

    public String getName() {
        return "HookRegisters";
    }
}

