/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.security.OSecurityAuthenticator;
import javax.security.auth.Subject;

public abstract class OSecurityAuthenticatorAbstract
implements OSecurityAuthenticator {
    private String name = "";
    private boolean debug = false;
    private boolean enabled = true;
    private boolean caseSensitive = true;
    private OServer server;
    private OServerConfigurationManager serverConfig;

    protected OServer getServer() {
        return this.server;
    }

    protected OServerConfigurationManager getServerConfig() {
        return this.serverConfig;
    }

    protected boolean isDebug() {
        return this.debug;
    }

    protected boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public void active() {
    }

    @Override
    public void config(OServer oServer, OServerConfigurationManager serverCfg, ODocument jsonConfig) {
        this.server = oServer;
        this.serverConfig = serverCfg;
        if (jsonConfig.containsField("name")) {
            this.name = (String)jsonConfig.field("name");
        }
        if (jsonConfig.containsField("debug")) {
            this.debug = (Boolean)jsonConfig.field("debug");
        }
        if (jsonConfig.containsField("enabled")) {
            this.enabled = (Boolean)jsonConfig.field("enabled");
        }
        if (jsonConfig.containsField("caseSensitive")) {
            this.caseSensitive = (Boolean)jsonConfig.field("caseSensitive");
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getAuthenticationHeader(String databaseName) {
        String header = databaseName != null ? "WWW-Authenticate: Basic realm=\"OrientDB db-" + databaseName + "\"" : "WWW-Authenticate: Basic realm=\"OrientDB Server\"";
        return header;
    }

    @Override
    public Subject getClientSubject() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OServerUserConfiguration getUser(String username) {
        return null;
    }

    @Override
    public boolean isAuthorized(String username, String resource) {
        return false;
    }

    @Override
    public boolean isSingleSignOnSupported() {
        return false;
    }

    protected boolean isPasswordValid(OServerUserConfiguration user) {
        return user != null && user.password != null && !user.password.isEmpty();
    }
}

