/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest.workload;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.ODatabaseRepair;
import com.orientechnologies.orient.core.db.tool.ODatabaseTool;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;
import com.orientechnologies.orient.stresstest.OStressTesterSettings;
import com.orientechnologies.orient.stresstest.workload.OBaseDocumentWorkload;
import com.orientechnologies.orient.stresstest.workload.OBaseWorkload;
import com.orientechnologies.orient.stresstest.workload.OCheckWorkload;
import java.util.List;
import java.util.Locale;

public class OCRUDWorkload
extends OBaseDocumentWorkload
implements OCheckWorkload {
    public static final String CLASS_NAME = "StressTestCRUD";
    public static final String INDEX_NAME = "StressTestCRUD.Index";
    static final String INVALID_FORM_MESSAGE = "CRUD workload must be in form of CxIxUxDxSx where x is a valid number.";
    static final String INVALID_NUMBERS = "Reads, Updates and Deletes must be less or equals to the Creates";
    private int total = 0;
    private OBaseWorkload.OWorkLoadResult createsResult = new OBaseWorkload.OWorkLoadResult(this);
    private OBaseWorkload.OWorkLoadResult readsResult = new OBaseWorkload.OWorkLoadResult(this);
    private OBaseWorkload.OWorkLoadResult updatesResult = new OBaseWorkload.OWorkLoadResult(this);
    private OBaseWorkload.OWorkLoadResult deletesResult = new OBaseWorkload.OWorkLoadResult(this);
    private OBaseWorkload.OWorkLoadResult scansResult = new OBaseWorkload.OWorkLoadResult(this);
    private int creates;
    private int reads;
    private int updates;
    private int deletes;
    private int scans;

    public OCRUDWorkload() {
        this.connectionStrategy = OStorageRemote.CONNECTION_STRATEGY.ROUND_ROBIN_REQUEST;
    }

    @Override
    public String getName() {
        return "CRUD";
    }

    @Override
    public void parseParameters(String args) {
        String ops = args.toUpperCase(Locale.ENGLISH);
        char state = ' ';
        StringBuilder number = new StringBuilder();
        for (int pos = 0; pos < ops.length(); ++pos) {
            char c = ops.charAt(pos);
            if (c == 'C' || c == 'R' || c == 'U' || c == 'D' || c == 'S') {
                state = this.assignState(state, number, c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                number.append(c);
                continue;
            }
            throw new IllegalArgumentException("Character '" + c + "' is not valid on CRUD workload. " + INVALID_FORM_MESSAGE);
        }
        this.assignState(state, number, ' ');
        this.total = this.creates + this.reads + this.updates + this.deletes + this.scans;
        if (this.reads > this.creates || this.updates > this.creates || this.deletes > this.creates) {
            throw new IllegalArgumentException(INVALID_NUMBERS);
        }
        if (this.total == 0) {
            throw new IllegalArgumentException(INVALID_FORM_MESSAGE);
        }
        this.createsResult.total = this.creates;
        this.readsResult.total = this.reads;
        this.updatesResult.total = this.updates;
        this.deletesResult.total = this.deletes;
        this.scansResult.total = this.scans;
    }

    @Override
    public void execute(OStressTesterSettings settings, ODatabaseIdentifier databaseIdentifier) {
        this.createSchema(databaseIdentifier);
        this.connectionStrategy = settings.loadBalancing;
        final ORID[] records = new ORID[this.createsResult.total];
        this.executeOperation(databaseIdentifier, this.createsResult, settings, new OCallable<Void, OBaseWorkload.OBaseWorkLoadContext>(){

            @Override
            public Void call(OBaseWorkload.OBaseWorkLoadContext context) {
                ODocument doc = OCRUDWorkload.this.createOperation(context.currentIdx);
                records[context.currentIdx] = doc.getIdentity();
                ((OCRUDWorkload)OCRUDWorkload.this).createsResult.current.incrementAndGet();
                return null;
            }
        });
        if (records.length != this.createsResult.total) {
            throw new RuntimeException("Error on creating records: found " + records.length + " but expected " + this.createsResult.total);
        }
        this.executeOperation(databaseIdentifier, this.scansResult, settings, new OCallable<Void, OBaseWorkload.OBaseWorkLoadContext>(){

            @Override
            public Void call(OBaseWorkload.OBaseWorkLoadContext context) {
                OCRUDWorkload.this.scanOperation(((OBaseDocumentWorkload.OWorkLoadContext)context).getDb());
                ((OCRUDWorkload)OCRUDWorkload.this).scansResult.current.incrementAndGet();
                return null;
            }
        });
        this.executeOperation(databaseIdentifier, this.readsResult, settings, new OCallable<Void, OBaseWorkload.OBaseWorkLoadContext>(){

            @Override
            public Void call(OBaseWorkload.OBaseWorkLoadContext context) {
                OCRUDWorkload.this.readOperation(((OBaseDocumentWorkload.OWorkLoadContext)context).getDb(), context.currentIdx);
                ((OCRUDWorkload)OCRUDWorkload.this).readsResult.current.incrementAndGet();
                return null;
            }
        });
        this.executeOperation(databaseIdentifier, this.updatesResult, settings, new OCallable<Void, OBaseWorkload.OBaseWorkLoadContext>(){

            @Override
            public Void call(OBaseWorkload.OBaseWorkLoadContext context) {
                OCRUDWorkload.this.updateOperation(((OBaseDocumentWorkload.OWorkLoadContext)context).getDb(), records[context.currentIdx]);
                ((OCRUDWorkload)OCRUDWorkload.this).updatesResult.current.incrementAndGet();
                return null;
            }
        });
        this.executeOperation(databaseIdentifier, this.deletesResult, settings, new OCallable<Void, OBaseWorkload.OBaseWorkLoadContext>(){

            @Override
            public Void call(OBaseWorkload.OBaseWorkLoadContext context) {
                OCRUDWorkload.this.deleteOperation(((OBaseDocumentWorkload.OWorkLoadContext)context).getDb(), records[context.currentIdx]);
                records[context.currentIdx] = null;
                ((OCRUDWorkload)OCRUDWorkload.this).deletesResult.current.incrementAndGet();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSchema(ODatabaseIdentifier databaseIdentifier) {
        ODatabase database = this.getDocumentDatabase(databaseIdentifier, OStorageRemote.CONNECTION_STRATEGY.STICKY);
        try {
            OSchema schema = database.getMetadata().getSchema();
            if (!schema.existsClass(CLASS_NAME)) {
                OClass cls = schema.createClass(CLASS_NAME);
                cls.createProperty("name", OType.STRING);
                cls.createIndex(INDEX_NAME, OClass.INDEX_TYPE.UNIQUE.toString(), (OProgressListener)null, (ODocument)null, "AUTOSHARDING", new String[]{"name"});
            }
        }
        finally {
            database.close();
        }
    }

    @Override
    public String getPartialResult() {
        long current = this.createsResult.current.get() + this.scansResult.current.get() + this.readsResult.current.get() + this.updatesResult.current.get() + this.deletesResult.current.get();
        return String.format("%d%% [Creates: %d%% - Scans: %d%% - Reads: %d%% - Updates: %d%% - Deletes: %d%%]", (int)(100L * current / (long)this.total), this.createsResult.total > 0 ? 100 * this.createsResult.current.get() / this.createsResult.total : 0, this.scansResult.total > 0 ? 100 * this.scansResult.current.get() / this.scansResult.total : 0, this.readsResult.total > 0 ? 100 * this.readsResult.current.get() / this.readsResult.total : 0, this.updatesResult.total > 0 ? 100 * this.updatesResult.current.get() / this.updatesResult.total : 0, this.deletesResult.total > 0 ? 100 * this.deletesResult.current.get() / this.deletesResult.total : 0);
    }

    @Override
    public String getFinalResult() {
        StringBuilder buffer = new StringBuilder(this.getErrors());
        buffer.append(String.format("- Created %d records in %.3f secs%s", this.createsResult.total, Float.valueOf((float)this.createsResult.totalTime / 1000.0f), this.createsResult.toOutput(1)));
        buffer.append(String.format("\n- Scanned %d records in %.3f secs%s", this.scansResult.total, Float.valueOf((float)this.scansResult.totalTime / 1000.0f), this.scansResult.toOutput(1)));
        buffer.append(String.format("\n- Read %d records in %.3f secs%s", this.readsResult.total, Float.valueOf((float)this.readsResult.totalTime / 1000.0f), this.readsResult.toOutput(1)));
        buffer.append(String.format("\n- Updated %d records in %.3f secs%s", this.updatesResult.total, Float.valueOf((float)this.updatesResult.totalTime / 1000.0f), this.updatesResult.toOutput(1)));
        buffer.append(String.format("\n- Deleted %d records in %.3f secs%s", this.deletesResult.total, Float.valueOf((float)this.deletesResult.totalTime / 1000.0f), this.deletesResult.toOutput(1)));
        return buffer.toString();
    }

    @Override
    public String getFinalResultAsJson() {
        ODocument json = new ODocument();
        json.field("type", this.getName());
        json.field("creates", this.createsResult.toJSON(), OType.EMBEDDED);
        json.field("scans", this.scansResult.toJSON(), OType.EMBEDDED);
        json.field("reads", this.readsResult.toJSON(), OType.EMBEDDED);
        json.field("updates", this.updatesResult.toJSON(), OType.EMBEDDED);
        json.field("deletes", this.deletesResult.toJSON(), OType.EMBEDDED);
        return json.toJSON("");
    }

    public ODocument createOperation(final long n) {
        return (ODocument)ODatabaseDocumentTx.executeWithRetries(new OCallable<Object, Integer>(){

            @Override
            public Object call(Integer iArgument) {
                ODocument doc = new ODocument(OCRUDWorkload.CLASS_NAME);
                doc.field("name", "value" + n);
                doc.save();
                return doc;
            }
        }, 10);
    }

    public void readOperation(ODatabase database, long n) {
        String query2 = String.format("SELECT FROM %s WHERE name = ?", CLASS_NAME);
        List result = (List)database.command(new OSQLSynchQuery(query2)).execute("value" + n);
        if (result.size() != 1) {
            throw new RuntimeException(String.format("The query [%s] with value '%s' result size is %d. Expected size is 1.", query2, "value" + n, result.size()));
        }
    }

    public void scanOperation(ODatabase database) {
        String query2 = String.format("SELECT count(*) FROM %s WHERE notexistent is null", CLASS_NAME);
        List result = (List)database.command(new OSQLSynchQuery(query2)).execute(new Object[0]);
        if (result.size() != 1) {
            throw new RuntimeException(String.format("The query [%s] result size is %d. Expected size is 1.", query2, result.size()));
        }
    }

    public void updateOperation(ODatabase database, final OIdentifiable rec) {
        ODatabaseDocumentTx.executeWithRetries(new OCallable<Object, Integer>(){

            @Override
            public Object call(Integer iArgument) {
                ODocument doc = (ODocument)rec.getRecord();
                if (doc == null) {
                    throw new ORecordNotFoundException(rec.getIdentity(), "Record " + rec + " was not found in StressTest for update");
                }
                doc.field("updated", true);
                doc.save();
                return doc;
            }
        }, 10);
    }

    public void deleteOperation(final ODatabase database, final OIdentifiable rec) {
        ODatabaseDocumentTx.executeWithRetries(new OCallable<Object, Integer>(){

            @Override
            public Object call(Integer iArgument) {
                database.delete(rec.getIdentity());
                return null;
            }
        }, 10);
    }

    private char assignState(char state, StringBuilder number, char c) {
        if (number.length() == 0) {
            number.append("0");
        }
        if (state == 'C') {
            this.creates = Integer.parseInt(number.toString());
        } else if (state == 'R') {
            this.reads = Integer.parseInt(number.toString());
        } else if (state == 'U') {
            this.updates = Integer.parseInt(number.toString());
        } else if (state == 'D') {
            this.deletes = Integer.parseInt(number.toString());
        } else if (state == 'S') {
            this.scans = Integer.parseInt(number.toString());
        }
        number.setLength(0);
        return c;
    }

    public int getCreates() {
        return this.createsResult.total;
    }

    public int getReads() {
        return this.readsResult.total;
    }

    public int getScans() {
        return this.scansResult.total;
    }

    public int getUpdates() {
        return this.updatesResult.total;
    }

    public int getDeletes() {
        return this.deletesResult.total;
    }

    @Override
    public void check(ODatabaseIdentifier databaseIdentifier) {
        ODatabaseDocument db = (ODatabaseDocument)this.getDocumentDatabase(databaseIdentifier, OStorageRemote.CONNECTION_STRATEGY.STICKY);
        ODatabaseTool repair = new ODatabaseRepair().setDatabase(db);
        repair.run();
    }
}

