/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator;

import com.google.common.primitives.Ints;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class MigratorApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigratorApplication.class);
    private static final String CONTENT_MIGRATION_JOB_PARAMETER = "--content_migration";
    private static final String EXPORT_JSON_JOB_PARAMETER = "--export_json";
    private static final String HEALTH_CHECK_JOB_PARAMETER = "--healthcheck";
    private static final String FORCE_JOB_PARAMETER = "--force";
    private static final String MIGRATE_DEV_JOB_PARAMETER = "migrate_dev";
    private static final String SAVE_MIGRATION_FILES = "--save_migration_files";
    private static final String YES_PROMPTED = "--yes";
    private static final String Y_PROMPTED = "-y";
    private static final String PASSWORD_PARAMETER = "password=";
    private static final String LOG_INTERVAL_TIME = "--log_interval_time";
    private static final String PASSWORD_PARAMETER_WITH_OBFUSCATED_VALUE = "password=****";
    private static final String URI_PARAMETER_DELIMITER = "&";
    private static boolean isDevMigration = false;

    public static void main(String[] args) {
        Integer time;
        String[] logIntervalTime;
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        boolean yesPrompted = arguments.stream().anyMatch(arg -> arg.contains(YES_PROMPTED) || arg.contains(Y_PROMPTED));
        MigratorApplication.startupWarning(yesPrompted);
        if (arguments.stream().anyMatch(arg -> arg.contains(HEALTH_CHECK_JOB_PARAMETER))) {
            log.info("{} parameter is present. Setting it to true and start health check process", (Object)HEALTH_CHECK_JOB_PARAMETER);
            arguments.remove(HEALTH_CHECK_JOB_PARAMETER);
            arguments.add("--healthcheck=" + Boolean.TRUE);
        }
        if (arguments.stream().anyMatch(arg -> arg.contains("--export_json=" + Boolean.FALSE))) {
            log.info("{} parameter is set to false. Setting {} to true", (Object)EXPORT_JSON_JOB_PARAMETER, (Object)CONTENT_MIGRATION_JOB_PARAMETER);
            arguments.removeIf(arg -> arg.contains(CONTENT_MIGRATION_JOB_PARAMETER));
            arguments.add("--content_migration=" + Boolean.TRUE);
        }
        if (arguments.stream().anyMatch(arg -> arg.contains(SAVE_MIGRATION_FILES))) {
            log.info("{} parameter is present. Setting it to true", (Object)SAVE_MIGRATION_FILES);
            arguments.add("--save_migration_files=" + Boolean.TRUE);
        }
        if (arguments.stream().noneMatch(arg -> arg.contains(CONTENT_MIGRATION_JOB_PARAMETER))) {
            log.info("{} parameter is absent. Setting it to true.", (Object)CONTENT_MIGRATION_JOB_PARAMETER);
            arguments.add("--content_migration=" + Boolean.TRUE.toString());
        }
        if (arguments.stream().noneMatch(arg -> arg.contains(EXPORT_JSON_JOB_PARAMETER))) {
            arguments.add("--export_json=" + Boolean.FALSE.toString());
        }
        if (arguments.stream().noneMatch(arg -> arg.contains("--force=" + Boolean.TRUE.toString()))) {
            log.info("Force parameter wasn't found. Setting it to false by default.");
            arguments.add("--force=" + Boolean.FALSE.toString());
        }
        if (arguments.stream().anyMatch(arg -> arg.contains(LOG_INTERVAL_TIME)) && (logIntervalTime = arguments.stream().filter(arg -> arg.contains(LOG_INTERVAL_TIME)).findFirst().get().split("=")).length > 0 && ((time = Ints.tryParse(logIntervalTime[1])) == null || time <= 0)) {
            log.warn("log_internal_time parameter found, but with invalid value (Integer > 0), default value 10 seconds");
            arguments.removeIf(arg -> arg.contains(LOG_INTERVAL_TIME));
        }
        args = arguments.toArray(new String[0]);
        MigratorApplication.logRuntimeInfo(arguments);
        isDevMigration = arguments.stream().filter(e -> e.contains(MIGRATE_DEV_JOB_PARAMETER)).anyMatch(e -> e.contains(Boolean.TRUE.toString()));
        if (isDevMigration) {
            log.info("This is a dev migration. All supported formats will be migrated.");
        }
        ConfigurableApplicationContext context = SpringApplication.run(MigratorApplication.class, args);
        int status = SpringApplication.exit(context, new ExitCodeGenerator[0]);
        System.exit(status);
    }

    private static void startupWarning(boolean yesPrompted) {
        log.warn("Please ensure any Nexus Repository instance has been gracefully shut down before proceeding.");
        if (yesPrompted) {
            return;
        }
        log.info("Do you want to continue [y/n]?");
        Scanner input = new Scanner(System.in);
        String answer = input.nextLine();
        if (!"y".equalsIgnoreCase(answer)) {
            log.info("Migration was canceled");
            System.exit(0);
        }
    }

    public static boolean isDevMigration() {
        return isDevMigration;
    }

    private static void logRuntimeInfo(List<String> arguments) {
        log.info("------------------------------------------------------------");
        log.info("Java version: {} {}", (Object)System.getProperty("java.vendor"), (Object)System.getProperty("java.version"));
        String anonymizedArguments = arguments.stream().map(MigratorApplication::anonymizeArgument).collect(Collectors.joining(" "));
        List<String> jvmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        log.info("JVM arguments: {}", (Object)String.join((CharSequence)" ", jvmArguments));
        log.info("Migrator arguments: {}", (Object)anonymizedArguments);
        log.info("------------------------------------------------------------");
    }

    private static String anonymizeArgument(String argument) {
        if (argument.contains("db_url") && argument.contains(PASSWORD_PARAMETER)) {
            String passwordParameterAndRemainingUri = argument.substring(argument.indexOf(PASSWORD_PARAMETER));
            int endOfPasswordIndex = passwordParameterAndRemainingUri.contains(URI_PARAMETER_DELIMITER) ? passwordParameterAndRemainingUri.indexOf(URI_PARAMETER_DELIMITER) : passwordParameterAndRemainingUri.length();
            String passwordParameterAndValue = passwordParameterAndRemainingUri.substring(0, endOfPasswordIndex);
            return argument.replace(passwordParameterAndValue, PASSWORD_PARAMETER_WITH_OBFUSCATED_VALUE);
        }
        return argument;
    }
}

