/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.classifier;

import com.sonatype.nexus.db.migrator.entity.RepositoryEntity;
import com.sonatype.nexus.db.migrator.item.record.RepositoryRecord;
import com.sonatype.nexus.db.migrator.utils.RepositoryUtils;
import java.util.Map;
import lombok.Generated;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.classify.Classifier;

public class RepositoryProcessorClassifier
implements Classifier<RepositoryRecord, ItemProcessor<?, ? extends RepositoryEntity>> {
    private final transient Map<String, ItemProcessor<RepositoryRecord, RepositoryEntity>> typeMap;
    private final transient ItemProcessor<RepositoryRecord, RepositoryEntity> defaultRepositoryProcessor;

    @Override
    public ItemProcessor<RepositoryRecord, RepositoryEntity> classify(RepositoryRecord classifiable) {
        String format = RepositoryUtils.getFormatFromRecipe(classifiable.getRecipeName());
        return this.typeMap.getOrDefault(format, this.defaultRepositoryProcessor);
    }

    @Generated
    public RepositoryProcessorClassifier(Map<String, ItemProcessor<RepositoryRecord, RepositoryEntity>> typeMap, ItemProcessor<RepositoryRecord, RepositoryEntity> defaultRepositoryProcessor) {
        this.typeMap = typeMap;
        this.defaultRepositoryProcessor = defaultRepositoryProcessor;
    }
}

