/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.sonatype.nexus.db.migrator.condition.H2ToPostgresComponentCondition;
import com.sonatype.nexus.db.migrator.condition.H2ToPostgresConfigCondition;
import com.sonatype.nexus.db.migrator.condition.InvalidMigrationTypeCondition;
import com.sonatype.nexus.db.migrator.condition.OrientMigrationCondition;
import com.sonatype.nexus.db.migrator.condition.OrientMigrationExportJsonWithContentCondition;
import com.sonatype.nexus.db.migrator.condition.OrientMigrationExportJsonWithoutContentCondition;
import com.sonatype.nexus.db.migrator.condition.OrientMigrationNoExportJsonCondition;
import com.sonatype.nexus.db.migrator.condition.PostgresToH2ComponentCondition;
import com.sonatype.nexus.db.migrator.condition.PostgresToH2Condition;
import com.sonatype.nexus.db.migrator.condition.PostgresToH2ConfigCondition;
import com.sonatype.nexus.db.migrator.config.CipherConfig;
import com.sonatype.nexus.db.migrator.config.MigratorJobLauncherApplicationRunner;
import com.sonatype.nexus.db.migrator.config.ProcessorConfig;
import com.sonatype.nexus.db.migrator.config.ReaderConfig;
import com.sonatype.nexus.db.migrator.config.RunDateIncrementer;
import com.sonatype.nexus.db.migrator.config.SchemaVersionsValidator;
import com.sonatype.nexus.db.migrator.config.WriterConfig;
import com.sonatype.nexus.db.migrator.decider.HealthCheckJobDecider;
import com.sonatype.nexus.db.migrator.decider.OSSDecider;
import com.sonatype.nexus.db.migrator.exception.ProcessingException;
import com.sonatype.nexus.db.migrator.export.JsonFilesExporter;
import com.sonatype.nexus.db.migrator.item.record.RecordItem;
import com.sonatype.nexus.db.migrator.listener.ProcessChunkListener;
import com.sonatype.nexus.db.migrator.listener.ProcessRecordStepListener;
import com.sonatype.nexus.db.migrator.listener.ProvidingJobInfoListener;
import com.sonatype.nexus.db.migrator.reader.OrientDocumentReader;
import com.sonatype.nexus.db.migrator.tasklet.DatabaseFinalizer;
import com.sonatype.nexus.db.migrator.tasklet.DatabaseInitializer;
import com.sonatype.nexus.db.migrator.tasklet.HealthCheckTasklet;
import com.sonatype.nexus.db.migrator.tasklet.ModelVersionsChecker;
import com.sonatype.nexus.db.migrator.tasklet.NoOpTasklet;
import com.sonatype.nexus.db.migrator.tasklet.RebuildRepositoryTaskProducer;
import com.sonatype.nexus.db.migrator.tasklet.UnzipArchivesTasklet;
import com.sonatype.nexus.db.migrator.utils.MigrationFilesPathQualifier;
import com.sonatype.nexus.db.migrator.utils.PathQualifier;
import com.sonatype.nexus.db.migrator.validator.JobParametersValidatorImpl;
import com.sonatype.nexus.db.migrator.validator.PathValidator;
import com.sonatype.nexus.db.migrator.validator.TargetDatabaseValidator;
import java.util.Arrays;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.CompositeJobParametersValidator;
import org.springframework.batch.core.job.builder.FlowBuilder;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.batch.JobLauncherApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.StringUtils;

@Configuration
@EnableBatchProcessing
@PropertySource(value={"classpath:application.properties"})
public class BatchConfig {
    private JobBuilderFactory jobBuilderFactory;
    private StepBuilderFactory stepBuilderFactory;
    private ReaderConfig readerConfig;
    private ProcessorConfig processorConfig;
    private WriterConfig writerConfig;
    private CipherConfig cipherConfig;
    private ObjectProvider<OrientDocumentReader> orientReaderProvider;
    @Value(value="${orient.folder:#{null}}")
    private String orientFolderPath;
    @Value(value="${migration_folder:#{null}}")
    private String migrationFolderPath;
    @Value(value="${chunk.size:10}")
    private int chunkSize;
    @Value(value="${log_interval_time:10}")
    private int logIntervalTime;
    @Value(value="${read.page.size:10000}")
    private int readerPageSize;

    @Bean
    @Conditional(value={InvalidMigrationTypeCondition.class})
    public Job validateMigrationTypeJob() {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("migrationFromOrientJob").validator(this.jobParametersValidator())).incrementer(this.jobParametersIncrementer())).start(this.startHealthCheckDeciderStep()).next(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_START").to(this.startHealthCheckStep()).from(this.startHealthCheckStep()).on("COMPLETED").end().from(this.startHealthCheckStep()).on("FAILED").fail().from(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.initDatabaseStep()).end()).listener(this.jobExecutionListener())).build();
    }

    @Bean
    @Conditional(value={OrientMigrationExportJsonWithContentCondition.class})
    @ConditionalOnProperty(name={"content_migration"}, havingValue="true", matchIfMissing=true)
    public Job migrationFromOrientJob() {
        return ((FlowJobBuilder)((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("migrationFromOrientJob").validator(this.compositeJobParametersValidator())).incrementer(this.jobParametersIncrementer())).start(this.startHealthCheckDeciderStep()).next(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_START").to(this.startHealthCheckStep()).from(this.startHealthCheckStep()).on("COMPLETED").end().from(this.startHealthCheckStep()).on("FAILED").fail().from(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.exportJsonFilesStep()).from(this.exportJsonFilesStep()).on("FAILED").fail().from(this.exportJsonFilesStep()).on("COMPLETED").to(this.readFileStep()).from(this.readFileStep()).on("COMPLETED").to(this.initDatabaseStep()).from(this.initDatabaseStep()).on("COMPLETED").to(this.processConfigStep()).from(this.processConfigStep()).on("COMPLETED").to(this.processRepositoryStep()).from(this.processRepositoryStep()).on("COMPLETED").to(this.processTagStep()).from(this.processTagStep()).on("COMPLETED").to(this.processComponentStep()).from(this.processComponentStep()).on("COMPLETED").to(this.createRebuildRepositoryTasksStep()).from(this.createRebuildRepositoryTasksStep()).on("COMPLETED").to(this.finalizeDatabaseStep()).end()).listener(this.jobExecutionListener())).listener(this.chunkListener())).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Job migrationFromOrientWithoutExportJsonJob() {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("migrationFromOrientNoExportJSONJob").validator(this.compositeJobParametersValidator())).incrementer(this.jobParametersIncrementer())).start(this.startHealthCheckDeciderStep()).next(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_START").to(this.startHealthCheckStep()).from(this.startHealthCheckStep()).on("COMPLETED").end().from(this.startHealthCheckStep()).on("FAILED").fail().from(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.unzipArchivesStep()).from(this.unzipArchivesStep()).on("COMPLETED").to(this.checkModelVersionsStep()).from(this.checkModelVersionsStep()).on("COMPLETED").to(this.initDatabaseStep()).from(this.checkModelVersionsStep()).on("FAILED").fail().from(this.initDatabaseStep()).on("COMPLETED").to(this.processFullDatabaseFlowStep()).from(this.processFullDatabaseFlowStep()).on("COMPLETED").to(this.createRebuildRepositoryTasksStep()).from(this.createRebuildRepositoryTasksStep()).on("COMPLETED").to(this.finalizeDatabaseStep()).end()).listener(this.jobExecutionListener())).build();
    }

    @Bean
    @Conditional(value={OrientMigrationExportJsonWithoutContentCondition.class})
    public Job migrationFromOrientWithoutComponentJob() {
        return ((FlowJobBuilder)((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("migrationFromOrientJob").validator(this.compositeJobParametersValidator())).incrementer(this.jobParametersIncrementer())).start(this.startHealthCheckDeciderStep()).next(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_START").to(this.startHealthCheckStep()).from(this.startHealthCheckStep()).on("COMPLETED").end().from(this.startHealthCheckStep()).on("FAILED").fail().from(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.exportJsonFilesStep()).from(this.exportJsonFilesStep()).on("FAILED").fail().from(this.exportJsonFilesStep()).on("COMPLETED").to(this.readFileStep()).from(this.readFileStep()).on("COMPLETED").to(this.initDatabaseStep()).from(this.initDatabaseStep()).on("COMPLETED").to(this.processConfigStep()).end()).listener(this.jobExecutionListener())).listener(this.chunkListener())).build();
    }

    @Bean
    @Conditional(value={H2ToPostgresComponentCondition.class})
    public Job migrationFromH2ToPostgresJob() {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("migrationFromH2ToPostgresJob").validator(this.compositeJobParametersValidator())).incrementer(this.jobParametersIncrementer())).start(this.startHealthCheckDeciderStep()).next(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_START").to(this.startHealthCheckStep()).from(this.startHealthCheckStep()).on("COMPLETED").end().from(this.startHealthCheckStep()).on("FAILED").fail().from(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.initDatabaseStep()).from(this.initDatabaseStep()).on("FAILED").fail().from(this.initDatabaseStep()).on("COMPLETED").to(this.migrateConfigFromH2ToPostgresStep()).from(this.migrateConfigFromH2ToPostgresStep()).on("COMPLETED").to(this.migrateTagFromH2ToPostgresStep()).from(this.migrateTagFromH2ToPostgresStep()).on("COMPLETED").to(this.migrateComponentFromH2ToPostgresStep()).from(this.migrateComponentFromH2ToPostgresStep()).on("COMPLETED").to(this.createRebuildRepositoryTasksStep()).from(this.createRebuildRepositoryTasksStep()).on("COMPLETED").to(this.finalizeDatabaseStep()).end()).listener(this.jobExecutionListener())).build();
    }

    @Bean
    @Conditional(value={H2ToPostgresConfigCondition.class})
    public Job migrationFromH2ToPostgresWithoutComponentJob() {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("migrationFromH2ToPostgresJob").validator(this.compositeJobParametersValidator())).incrementer(this.jobParametersIncrementer())).start(this.startHealthCheckDeciderStep()).next(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_START").to(this.startHealthCheckStep()).from(this.startHealthCheckStep()).on("COMPLETED").end().from(this.startHealthCheckStep()).on("FAILED").fail().from(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.initDatabaseStep()).from(this.initDatabaseStep()).on("FAILED").fail().from(this.initDatabaseStep()).on("COMPLETED").to(this.migrateConfigFromH2ToPostgresStep()).end()).listener(this.jobExecutionListener())).build();
    }

    @Bean
    @Conditional(value={PostgresToH2ComponentCondition.class})
    public Job migrationFromPostgresToH2Job() {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("migrationFromPostgresToH2Job").validator(this.compositeJobParametersValidator())).incrementer(this.jobParametersIncrementer())).start(this.startHealthCheckDeciderStep()).next(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_START").to(this.startHealthCheckStep()).from(this.startHealthCheckStep()).on("COMPLETED").end().from(this.startHealthCheckStep()).on("FAILED").fail().from(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.initDatabaseStep()).from(this.initDatabaseStep()).on("FAILED").fail().from(this.initDatabaseStep()).on("COMPLETED").to(this.migrateConfigFromPostgresToH2Step()).from(this.migrateConfigFromPostgresToH2Step()).on("COMPLETED").to(this.migrateTagFromPostgresToH2Step()).from(this.migrateTagFromPostgresToH2Step()).on("COMPLETED").to(this.migrateComponentFromPostgresToH2Step()).from(this.migrateComponentFromPostgresToH2Step()).on("COMPLETED").to(this.createRebuildRepositoryTasksStep()).from(this.createRebuildRepositoryTasksStep()).on("COMPLETED").to(this.finalizeDatabaseStep()).end()).listener(this.jobExecutionListener())).build();
    }

    @Bean
    @Conditional(value={PostgresToH2ConfigCondition.class})
    public Job migrationFromPostgresToH2WithoutComponentJob() {
        return ((FlowJobBuilder)((FlowJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("migrationFromPostgresToH2Job").validator(this.compositeJobParametersValidator())).incrementer(this.jobParametersIncrementer())).start(this.startHealthCheckDeciderStep()).next(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_START").to(this.startHealthCheckStep()).from(this.startHealthCheckStep()).on("COMPLETED").end().from(this.startHealthCheckStep()).on("FAILED").fail().from(this.healthCheckDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.initDatabaseStep()).from(this.initDatabaseStep()).on("FAILED").fail().from(this.initDatabaseStep()).on("COMPLETED").to(this.migrateConfigFromPostgresToH2Step()).end()).listener(this.jobExecutionListener())).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Step exportJsonFilesStep() {
        return this.stepBuilderFactory.get("exportFilesStep").tasklet(this.jsonFilesExporter()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Step readFileStep() {
        return this.stepBuilderFactory.get("readFileStep").tasklet(this.readerConfig.fileReader()).build();
    }

    @Bean
    public Step initDatabaseStep() {
        return this.stepBuilderFactory.get("initDatabaseStep").tasklet(this.databaseInitializer()).build();
    }

    @Bean
    public Step finalizeDatabaseStep() {
        return this.stepBuilderFactory.get("finalDatabaseStep").tasklet(this.databaseFinalizer()).build();
    }

    @Bean
    public Step startHealthCheckStep() {
        return this.stepBuilderFactory.get("startHealthCheckStep").tasklet(this.healthCheckTasklet()).build();
    }

    @Bean
    public Step createRebuildRepositoryTasksStep() {
        return this.stepBuilderFactory.get("createRebuildRepositoryTasksStep").tasklet(this.rebuildRepositoryTaskProducer()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Step processConfigStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("processConfigStep").chunk(this.chunkSize).reader(this.readerConfig.configReader()).processor(this.processorConfig.processor()).writer(this.writerConfig.configWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).noRetry(ProcessingException.class).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    @ConditionalOnProperty(name={"content_migration"})
    public Step processRepositoryStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("processRepositoryStep").chunk(this.chunkSize).reader(this.readerConfig.contentRepositoryReader()).processor(this.processorConfig.processor()).writer(this.writerConfig.componentWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    @ConditionalOnProperty(name={"content_migration"})
    public Step processTagStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("processTagStep").chunk(this.chunkSize).reader(this.readerConfig.tagReader()).processor(this.processorConfig.processor()).writer(this.writerConfig.tagsWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    @ConditionalOnProperty(name={"content_migration"})
    public Step processComponentStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("processComponentStep").chunk(this.chunkSize).reader(this.readerConfig.componentReader()).processor(this.processorConfig.processor()).writer(this.writerConfig.componentWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).processorNonTransactional().listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @ConditionalOnProperty(name={"migration_type"}, havingValue="h2_to_postgres")
    public Step migrateConfigFromH2ToPostgresStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateConfigFromH2ToPostgresStep").chunk(this.chunkSize).reader(this.readerConfig.sqlConfigReader()).processor(this.processorConfig.h2ToPostgresProcessor()).writer(this.writerConfig.configWriter()).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={PostgresToH2Condition.class})
    public Step migrateConfigFromPostgresToH2Step() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateConfigFromPostgresToH2Step").chunk(this.chunkSize).reader(this.readerConfig.sqlConfigReader()).processor(this.processorConfig.postgresToH2Processor()).writer(this.writerConfig.configWriter()).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={H2ToPostgresComponentCondition.class})
    public Step migrateTagFromH2ToPostgresStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateTagFromH2ToPostgresStep").chunk(this.chunkSize).reader(this.readerConfig.sqlTagReader()).writer(this.writerConfig.tagWriter()).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={H2ToPostgresComponentCondition.class})
    public Step migrateComponentFromH2ToPostgresStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateComponentFromH2ToPostgresStep").chunk(this.chunkSize).reader(this.readerConfig.sqlComponentReader()).processor(this.processorConfig.h2ToPostgresProcessor()).writer(this.writerConfig.componentWriter()).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={PostgresToH2ComponentCondition.class})
    public Step migrateTagFromPostgresToH2Step() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateTagFromPostgresToH2Step").chunk(this.chunkSize).reader(this.readerConfig.sqlTagReader()).writer(this.writerConfig.tagWriter()).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={PostgresToH2ComponentCondition.class})
    public Step migrateComponentFromPostgresToH2Step() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateComponentFromPostgresToH2Step").chunk(this.chunkSize).reader(this.readerConfig.sqlComponentReader()).writer(this.writerConfig.componentWriter()).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    public Step startHealthCheckDeciderStep() {
        return this.stepBuilderFactory.get("startHealthCheckDeciderStep").tasklet(this.noOpsTasklet()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step checkModelVersionsStep() {
        return this.stepBuilderFactory.get("checkModelVersionsStep").tasklet(this.modelVersionsChecker()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Tasklet modelVersionsChecker() {
        return new ModelVersionsChecker();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step unzipArchivesStep() {
        return this.stepBuilderFactory.get("unzipArchivesStep").tasklet(this.unzipArchivesTasklet(this.pathQualifier())).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step processFullDatabaseFlowStep() {
        return this.stepBuilderFactory.get("processFullDatabase").flow(this.fullDatabaseFlow()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Flow fullDatabaseFlow() {
        return (Flow)new FlowBuilder("processFullDatabaseFlow").start(this.migrateQuartzJobDetailsStep()).from(this.migrateQuartzJobDetailsStep()).on("COMPLETED").to(this.migrateQuartzJobTriggersStep()).from(this.migrateQuartzJobTriggersStep()).on("COMPLETED").to(this.migrateQuartzJobCalendarsStep()).from(this.migrateQuartzJobCalendarsStep()).on("COMPLETED").to(this.migrateUsersStep()).from(this.migrateUsersStep()).on("COMPLETED").to(this.migrateUserRoleMappingsStep()).from(this.migrateUserRoleMappingsStep()).on("COMPLETED").to(this.migrateAnonymousConfigurationStep()).from(this.migrateAnonymousConfigurationStep()).on("COMPLETED").to(this.migratePrivilegesStep()).from(this.migratePrivilegesStep()).on("COMPLETED").to(this.migrateRolesStep()).from(this.migrateRolesStep()).on("COMPLETED").to(this.migrateEmailConfigurationStep()).from(this.migrateEmailConfigurationStep()).on("COMPLETED").to(this.migrateHttpClientConfigurationStep()).from(this.migrateHttpClientConfigurationStep()).on("COMPLETED").to(this.migrateRealmConfigurationStep()).from(this.migrateRealmConfigurationStep()).on("COMPLETED").to(this.migrateDeploymentIdentifierStep()).from(this.migrateDeploymentIdentifierStep()).on("COMPLETED").to(this.migrateScriptsStep()).from(this.migrateScriptsStep()).on("COMPLETED").to(this.migrateHealthCheckConfigurationStep()).from(this.migrateHealthCheckConfigurationStep()).on("COMPLETED").to(this.migrateLdapConfigurationStep()).from(this.migrateLdapConfigurationStep()).on("COMPLETED").to(this.samlStepsDecider()).start(this.samlStepsDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.migrateCapabilitiesStep()).from(this.samlStepsDecider()).on("DECISION_HEALTH_CHECK_START").to(this.migrateSamlConfigurationStep()).from(this.migrateSamlConfigurationStep()).on("COMPLETED").to(this.migrateSamlUsersStep()).from(this.migrateSamlUsersStep()).on("COMPLETED").to(this.migrateCapabilitiesStep()).from(this.migrateCapabilitiesStep()).on("COMPLETED").to(this.migrateCleanupPoliciesStep()).from(this.migrateCleanupPoliciesStep()).on("COMPLETED").to(this.migrateContentSelectorsStep()).from(this.migrateContentSelectorsStep()).on("COMPLETED").to(this.migrateApiKeysStep()).from(this.migrateApiKeysStep()).on("COMPLETED").to(this.migrateRepositoriesStep()).from(this.migrateRepositoriesStep()).on("COMPLETED").to(this.migrateRoutingRulesStep()).from(this.migrateRoutingRulesStep()).on("COMPLETED").to(this.migrateBlobStoresStep()).from(this.migrateBlobStoresStep()).on("COMPLETED").to(this.migrateBucketsStep()).from(this.migrateBucketsStep()).on("COMPLETED").to(this.tagStepsDecider()).start(this.tagStepsDecider()).on("DECISION_HEALTH_CHECK_SKIP").to(this.migrateComponentsStep()).from(this.tagStepsDecider()).on("DECISION_HEALTH_CHECK_START").to(this.migrateTagsStep()).from(this.migrateTagsStep()).on("COMPLETED").to(this.migrateComponentsStep()).from(this.migrateComponentsStep()).on("COMPLETED").to(this.migrateAssetsStep()).from(this.migrateAssetsStep()).on("COMPLETED").to(this.migrateDockerForeignLayersStep()).from(this.migrateDockerForeignLayersStep()).on("COMPLETED").to(this.migrateDeletedBlobIndexStep()).from(this.migrateDeletedBlobIndexStep()).on("COMPLETED").to(this.migrateKeyStoreStep()).end();
    }

    private Step buildDirectMigrationStep(String stepName, String databaseName, String databaseClassName) {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get(stepName).chunk(this.chunkSize).reader(this.orientDocumentReader(databaseName, databaseClassName)).processor(this.processorConfig.processor()).writer(this.writerConfig.configWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).noRetry(ProcessingException.class).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    private Step buildDirectConfigMigrationStep(String stepName, String databaseClassName) {
        return this.buildDirectMigrationStep(stepName, "config", databaseClassName);
    }

    private Step buildDirectSecurityMigrationStep(String stepName, String databaseClassName) {
        return this.buildDirectMigrationStep(stepName, "security", databaseClassName);
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateQuartzJobDetailsStep() {
        return this.buildDirectConfigMigrationStep("migrateQuartzJobDetailsStep", "quartz_job_detail");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateQuartzJobTriggersStep() {
        return this.buildDirectConfigMigrationStep("migrateQuartzJobTriggersStep", "quartz_trigger");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateQuartzJobCalendarsStep() {
        return this.buildDirectConfigMigrationStep("migrateQuartzJobCalendarsStep", "quartz_calendar");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateUsersStep() {
        return this.buildDirectSecurityMigrationStep("migrateUsersStep", "user");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateUserRoleMappingsStep() {
        return this.buildDirectSecurityMigrationStep("migrateUserRoleMappingsStep", "user_role_mapping");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateAnonymousConfigurationStep() {
        return this.buildDirectSecurityMigrationStep("migrateAnonymousConfigurationStep", "anonymous");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migratePrivilegesStep() {
        return this.buildDirectSecurityMigrationStep("migratePrivilegesStep", "privilege");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateRolesStep() {
        return this.buildDirectSecurityMigrationStep("migrateRolesStep", "role");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateEmailConfigurationStep() {
        return this.buildDirectConfigMigrationStep("migrateEmailConfigurationStep", "email");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateHttpClientConfigurationStep() {
        return this.buildDirectConfigMigrationStep("migrateHttpClientConfigurationStep", "http_client");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateRealmConfigurationStep() {
        return this.buildDirectSecurityMigrationStep("migrateRealmConfigurationStep", "realm");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateDeploymentIdentifierStep() {
        return this.buildDirectConfigMigrationStep("migrateDeploymentIdentifierStep", "deploymentidentifier");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateScriptsStep() {
        return this.buildDirectConfigMigrationStep("migrateScriptsStep", "script");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateHealthCheckConfigurationStep() {
        return this.buildDirectConfigMigrationStep("migrateHealthCheckConfigurationStep", "healthcheckconfig");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateKeyStoreStep() {
        return this.buildDirectConfigMigrationStep("migrateKeyStoreStep", "key_store");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateLdapConfigurationStep() {
        return this.buildDirectConfigMigrationStep("migrateLdapConfigurationStep", "ldap");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateSamlConfigurationStep() {
        return this.buildDirectConfigMigrationStep("migrateSamlConfigurationStep", "saml");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateSamlUsersStep() {
        return this.buildDirectSecurityMigrationStep("migrateSamlUsersStep", "saml_user");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateCapabilitiesStep() {
        return this.buildDirectConfigMigrationStep("migrateCapabilitiesStep", "capability");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateCleanupPoliciesStep() {
        return this.buildDirectConfigMigrationStep("migrateCleanupPoliciesStep", "cleanup");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateContentSelectorsStep() {
        return this.buildDirectConfigMigrationStep("migrateContentSelectorsStep", "selector_selector");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateApiKeysStep() {
        return this.buildDirectSecurityMigrationStep("migrateApiKeysStep", "api_key");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateRepositoriesStep() {
        return this.buildDirectConfigMigrationStep("migrateRepositoriesStep", "repository");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateRoutingRulesStep() {
        return this.buildDirectConfigMigrationStep("migrateRoutingRulesStep", "repository_routingrule");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateBlobStoresStep() {
        return this.buildDirectConfigMigrationStep("migrateBlobStoresStep", "repository_blobstore");
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateBucketsStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateBucketsStep").chunk(this.chunkSize).reader(this.orientDocumentReader("component", "bucket")).processor(this.processorConfig.processor()).writer(this.writerConfig.componentWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).noRetry(ProcessingException.class).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateTagsStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateTagsStep").chunk(this.chunkSize).reader(this.orientDocumentReader("component", "tag")).processor(this.processorConfig.processor()).writer(this.writerConfig.tagsWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).noRetry(ProcessingException.class).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateComponentsStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateComponentsStep").chunk(this.chunkSize).reader(this.orientDocumentReader("component", "component")).processor(this.processorConfig.processor()).writer(this.writerConfig.componentWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).noRetry(ProcessingException.class).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateAssetsStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateAssetsStep").chunk(this.chunkSize).reader(this.orientDocumentReader("component", "asset")).processor(this.processorConfig.processor()).writer(this.writerConfig.componentWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).noRetry(ProcessingException.class).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateDockerForeignLayersStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateDockerForeignLayersStep").chunk(this.chunkSize).reader(this.orientDocumentReader("component", "docker_foreign_layers")).processor(this.processorConfig.processor()).writer(this.writerConfig.componentWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).noRetry(ProcessingException.class).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Step migrateDeletedBlobIndexStep() {
        return ((AbstractTaskletStepBuilder)this.stepBuilderFactory.get("migrateDeletedBlobIndexStep").chunk(this.chunkSize).reader(this.orientDocumentReader("component", "deleted_blob_index")).processor(this.processorConfig.processor()).writer(this.writerConfig.componentWriter()).faultTolerant().skipPolicy(this.writerConfig.writerSkipPolicy()).noRetry(ProcessingException.class).listener(this.stepListener())).listener(this.chunkListener()).build();
    }

    @Bean
    public Tasklet noOpsTasklet() {
        return new NoOpTasklet();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Tasklet jsonFilesExporter() {
        return new JsonFilesExporter();
    }

    @Bean
    @Conditional(value={OrientMigrationNoExportJsonCondition.class})
    public Tasklet unzipArchivesTasklet(PathQualifier pathQualifier) {
        return new UnzipArchivesTasklet(this.pathQualifier());
    }

    @Bean
    public Tasklet databaseInitializer() {
        return new DatabaseInitializer();
    }

    @Bean
    public Tasklet healthCheckTasklet() {
        return new HealthCheckTasklet(this.pathQualifier());
    }

    @Bean
    public Tasklet databaseFinalizer() {
        return new DatabaseFinalizer();
    }

    @Bean
    public SchemaVersionsValidator schemaVersionsValidator() {
        return new SchemaVersionsValidator();
    }

    @Bean
    public StepExecutionListener stepListener() {
        return new ProcessRecordStepListener();
    }

    @Bean
    public ChunkListener chunkListener() {
        return new ProcessChunkListener(this.logIntervalTime);
    }

    @Bean
    public JobExecutionListener jobExecutionListener() {
        return new ProvidingJobInfoListener();
    }

    @Bean
    public JobParametersValidator jobParametersValidator() {
        return new JobParametersValidatorImpl();
    }

    @Bean
    public PathValidator pathValidator() {
        return new PathValidator(this.pathQualifier(), this.migrationFilesPathQualifier());
    }

    @Bean
    public TargetDatabaseValidator targetDatabaseValidator() {
        return new TargetDatabaseValidator();
    }

    @Bean
    public PathQualifier pathQualifier() {
        return new PathQualifier(this.orientFolderPath);
    }

    @Bean
    public MigrationFilesPathQualifier migrationFilesPathQualifier() {
        return new MigrationFilesPathQualifier(this.migrationFolderPath);
    }

    @Bean
    public JobParametersIncrementer jobParametersIncrementer() {
        return new RunDateIncrementer();
    }

    @Bean
    public JobParametersValidator compositeJobParametersValidator() {
        CompositeJobParametersValidator compositeJobParametersValidator = new CompositeJobParametersValidator();
        compositeJobParametersValidator.setValidators(Arrays.asList(this.jobParametersValidator(), this.pathValidator(), this.targetDatabaseValidator()));
        return compositeJobParametersValidator;
    }

    @Bean
    public Tasklet rebuildRepositoryTaskProducer() {
        return new RebuildRepositoryTaskProducer(this.writerConfig.quartzJobDetailWriter(), this.writerConfig.compositeQuartzTriggerWriter());
    }

    public ItemReader<RecordItem> orientDocumentReader(String databaseName, String dbClassName) {
        OrientDocumentReader orientDocumentReader = this.orientReaderProvider.getObject(databaseName, dbClassName, this.cipherConfig.pbeCipherFactory(), this.readerPageSize);
        orientDocumentReader.setName("orientDocumentReader-" + dbClassName);
        return orientDocumentReader;
    }

    @Bean
    public JobExecutionDecider healthCheckDecider() {
        return new HealthCheckJobDecider();
    }

    @Bean
    public TaskScheduler taskScheduler() {
        return new ThreadPoolTaskScheduler();
    }

    @Bean
    public JobLauncherApplicationRunner jobLauncherApplicationRunner(JobLauncher jobLauncher, JobExplorer jobExplorer, JobRepository jobRepository, BatchProperties properties) {
        MigratorJobLauncherApplicationRunner runner = new MigratorJobLauncherApplicationRunner(jobLauncher, jobExplorer, jobRepository);
        String jobNames = properties.getJob().getNames();
        if (StringUtils.hasText(jobNames)) {
            runner.setJobNames(jobNames);
        }
        return runner;
    }

    @Bean
    public OSSDecider samlStepsDecider() {
        return new OSSDecider(this.pathQualifier().getOrientFolderPath());
    }

    @Bean
    public OSSDecider tagStepsDecider() {
        return new OSSDecider(this.pathQualifier().getOrientFolderPath());
    }

    @Autowired
    public void setJobBuilderFactory(JobBuilderFactory jobBuilderFactory) {
        this.jobBuilderFactory = jobBuilderFactory;
    }

    @Autowired
    public void setStepBuilderFactory(StepBuilderFactory stepBuilderFactory) {
        this.stepBuilderFactory = stepBuilderFactory;
    }

    @Autowired
    public void setReaderConfig(ReaderConfig readerConfig) {
        this.readerConfig = readerConfig;
    }

    @Autowired(required=false)
    public void setProcessorConfig(ProcessorConfig processorConfig) {
        this.processorConfig = processorConfig;
    }

    @Autowired
    public void setWriterConfig(WriterConfig writerConfig) {
        this.writerConfig = writerConfig;
    }

    @Autowired
    public void setCipherConfig(CipherConfig cipherConfig) {
        this.cipherConfig = cipherConfig;
    }

    @Autowired
    public void setOrientReaderProvider(ObjectProvider<OrientDocumentReader> orientReaderProvider) {
        this.orientReaderProvider = orientReaderProvider;
    }
}

