/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.db.migrator.classifier.AssetProcessorClassifier;
import com.sonatype.nexus.db.migrator.classifier.ComponentProcessorClassifier;
import com.sonatype.nexus.db.migrator.classifier.RepositoryProcessorClassifier;
import com.sonatype.nexus.db.migrator.condition.H2ToPostgresCondition;
import com.sonatype.nexus.db.migrator.condition.OrientMigrationCondition;
import com.sonatype.nexus.db.migrator.condition.PostgresToH2Condition;
import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.entity.AssetEntity;
import com.sonatype.nexus.db.migrator.entity.ComponentEntity;
import com.sonatype.nexus.db.migrator.entity.Entity;
import com.sonatype.nexus.db.migrator.entity.QuartzJobDetailEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzTriggerEntity;
import com.sonatype.nexus.db.migrator.entity.RealmEntity;
import com.sonatype.nexus.db.migrator.entity.ReplicationConnectionEntity;
import com.sonatype.nexus.db.migrator.entity.RepositoryEntity;
import com.sonatype.nexus.db.migrator.item.record.AnonymousConfigurationRecord;
import com.sonatype.nexus.db.migrator.item.record.ApiKeyRecord;
import com.sonatype.nexus.db.migrator.item.record.BlobStoreRecord;
import com.sonatype.nexus.db.migrator.item.record.CapabilityRecord;
import com.sonatype.nexus.db.migrator.item.record.ChangeBlobstoreRecord;
import com.sonatype.nexus.db.migrator.item.record.CleanupPolicyRecord;
import com.sonatype.nexus.db.migrator.item.record.DeploymentIdRecord;
import com.sonatype.nexus.db.migrator.item.record.EmailRecord;
import com.sonatype.nexus.db.migrator.item.record.FirewallIgnorePatternRecord;
import com.sonatype.nexus.db.migrator.item.record.HealthCheckConfigRecord;
import com.sonatype.nexus.db.migrator.item.record.KeyStoreDataRecord;
import com.sonatype.nexus.db.migrator.item.record.PrivilegeRecord;
import com.sonatype.nexus.db.migrator.item.record.RealmRecord;
import com.sonatype.nexus.db.migrator.item.record.RecordItem;
import com.sonatype.nexus.db.migrator.item.record.ReplicationConnectionRecord;
import com.sonatype.nexus.db.migrator.item.record.RepositoryRecord;
import com.sonatype.nexus.db.migrator.item.record.RoleRecord;
import com.sonatype.nexus.db.migrator.item.record.RoutingRuleRecord;
import com.sonatype.nexus.db.migrator.item.record.ScriptRecord;
import com.sonatype.nexus.db.migrator.item.record.SelectorRecord;
import com.sonatype.nexus.db.migrator.item.record.UpgradeModelVersionsRecord;
import com.sonatype.nexus.db.migrator.item.record.UserRecord;
import com.sonatype.nexus.db.migrator.item.record.UserRoleMappingRecord;
import com.sonatype.nexus.db.migrator.item.record.UserTokenRecord;
import com.sonatype.nexus.db.migrator.item.record.content.AssetRecord;
import com.sonatype.nexus.db.migrator.item.record.content.AzureDeletedBlobRecord;
import com.sonatype.nexus.db.migrator.item.record.content.ComponentRecord;
import com.sonatype.nexus.db.migrator.item.record.content.ContentRepositoryRecord;
import com.sonatype.nexus.db.migrator.item.record.content.DockerForeignLayerRecord;
import com.sonatype.nexus.db.migrator.item.record.content.TagRecord;
import com.sonatype.nexus.db.migrator.item.record.httpclient.HttpClientRecord;
import com.sonatype.nexus.db.migrator.item.record.ldap.LdapConfigurationRecord;
import com.sonatype.nexus.db.migrator.item.record.quartz.calendar.QuartzCalendarRecord;
import com.sonatype.nexus.db.migrator.item.record.quartz.job.QuartzJobDetailRecord;
import com.sonatype.nexus.db.migrator.item.record.quartz.trigger.QuartzTriggerRecord;
import com.sonatype.nexus.db.migrator.item.record.saml.SamlConfigurationRecord;
import com.sonatype.nexus.db.migrator.item.record.saml.SamlUserRecord;
import com.sonatype.nexus.db.migrator.processor.AnonymousConfigurationProcessor;
import com.sonatype.nexus.db.migrator.processor.ApiKeyProcessor;
import com.sonatype.nexus.db.migrator.processor.BlobStoreProcessor;
import com.sonatype.nexus.db.migrator.processor.CapabilityProcessor;
import com.sonatype.nexus.db.migrator.processor.ChangeBlobstoreProcessor;
import com.sonatype.nexus.db.migrator.processor.CleanupPolicyProcessor;
import com.sonatype.nexus.db.migrator.processor.DeploymentIdProcessor;
import com.sonatype.nexus.db.migrator.processor.EmailProcessor;
import com.sonatype.nexus.db.migrator.processor.FirewallIgnorePatternProcessor;
import com.sonatype.nexus.db.migrator.processor.H2ToPostgresItemProcessor;
import com.sonatype.nexus.db.migrator.processor.HealthCheckConfigProcessor;
import com.sonatype.nexus.db.migrator.processor.HttpClientProcessor;
import com.sonatype.nexus.db.migrator.processor.KeyStoreDataProcessor;
import com.sonatype.nexus.db.migrator.processor.LdapConfigurationProcessor;
import com.sonatype.nexus.db.migrator.processor.PrivilegeProcessor;
import com.sonatype.nexus.db.migrator.processor.QuartzCalendarProcessor;
import com.sonatype.nexus.db.migrator.processor.QuartzJobDetailH2ToPostgresProcessor;
import com.sonatype.nexus.db.migrator.processor.QuartzJobDetailPostgresToH2Processor;
import com.sonatype.nexus.db.migrator.processor.QuartzJobDetailProcessor;
import com.sonatype.nexus.db.migrator.processor.QuartzTriggerProcessor;
import com.sonatype.nexus.db.migrator.processor.QuartzTriggerSqlProcessor;
import com.sonatype.nexus.db.migrator.processor.RealmProcessor;
import com.sonatype.nexus.db.migrator.processor.RealmSqlProcessor;
import com.sonatype.nexus.db.migrator.processor.ReplicationConnectionProcessor;
import com.sonatype.nexus.db.migrator.processor.ReplicationConnectionSqlProcessor;
import com.sonatype.nexus.db.migrator.processor.RepositoryProcessor;
import com.sonatype.nexus.db.migrator.processor.RoleProcessor;
import com.sonatype.nexus.db.migrator.processor.RoutingRuleProcessor;
import com.sonatype.nexus.db.migrator.processor.SamlConfigurationProcessor;
import com.sonatype.nexus.db.migrator.processor.SamlUserProcessor;
import com.sonatype.nexus.db.migrator.processor.ScriptProcessor;
import com.sonatype.nexus.db.migrator.processor.SelectorProcessor;
import com.sonatype.nexus.db.migrator.processor.UserProcessor;
import com.sonatype.nexus.db.migrator.processor.UserRoleMappingProcessor;
import com.sonatype.nexus.db.migrator.processor.UserTokenProcessor;
import com.sonatype.nexus.db.migrator.processor.content.AssetProcessor;
import com.sonatype.nexus.db.migrator.processor.content.AzureDeletedBlobProcessor;
import com.sonatype.nexus.db.migrator.processor.content.ComponentProcessor;
import com.sonatype.nexus.db.migrator.processor.content.ContentRepositoryProcessor;
import com.sonatype.nexus.db.migrator.processor.content.DockerForeignLayerProcessor;
import com.sonatype.nexus.db.migrator.processor.content.MavenComponentProcessor;
import com.sonatype.nexus.db.migrator.processor.content.NugetAssetProcessor;
import com.sonatype.nexus.db.migrator.processor.content.RawComponentProcessor;
import com.sonatype.nexus.db.migrator.processor.content.TagProcessor;
import com.sonatype.nexus.db.migrator.utils.CipherHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.sonatype.nexus.security.PasswordHelper;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.support.PassThroughItemProcessor;
import org.springframework.batch.item.support.builder.ClassifierCompositeItemProcessorBuilder;
import org.springframework.classify.SubclassClassifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProcessorConfig {
    private final ObjectMapper mapper;
    private final CipherHandler cipherHandler;
    private final PasswordHelper passwordHelper;
    private final PbeCipherFactory.PbeCipher pbeCipher;

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public ItemProcessor<RecordItem, Entity> processor() {
        SubclassClassifier classifier = new SubclassClassifier();
        classifier.setTypeMap(this.processorTypeMap());
        return new ClassifierCompositeItemProcessorBuilder<RecordItem, Entity>().classifier(classifier).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Map<Class<? extends RecordItem>, ItemProcessor<?, ? extends Entity>> processorTypeMap() {
        HashMap map = new HashMap();
        map.put(DeploymentIdRecord.class, new DeploymentIdProcessor(this.mapper));
        map.put(CapabilityRecord.class, new CapabilityProcessor(this.mapper));
        map.put(LdapConfigurationRecord.class, new LdapConfigurationProcessor(this.mapper));
        map.put(SamlConfigurationRecord.class, new SamlConfigurationProcessor(this.mapper, this.cipherHandler, this.passwordHelper));
        map.put(SamlUserRecord.class, new SamlUserProcessor(this.mapper));
        map.put(UserRecord.class, new UserProcessor());
        map.put(RoutingRuleRecord.class, new RoutingRuleProcessor(this.mapper));
        map.put(RepositoryRecord.class, this.classifierCompositeRepositoryProcessor());
        map.put(BlobStoreRecord.class, new BlobStoreProcessor(this.mapper));
        map.put(QuartzJobDetailRecord.class, this.quartzJobDetailProcessor());
        map.put(QuartzTriggerRecord.class, new QuartzTriggerProcessor(this.mapper));
        map.put(QuartzCalendarRecord.class, new QuartzCalendarProcessor(this.mapper));
        map.put(RealmRecord.class, new RealmProcessor(this.mapper));
        map.put(RoleRecord.class, new RoleProcessor(this.mapper));
        map.put(UserRoleMappingRecord.class, new UserRoleMappingProcessor(this.mapper));
        map.put(EmailRecord.class, new EmailProcessor(this.cipherHandler, this.passwordHelper));
        map.put(CleanupPolicyRecord.class, new CleanupPolicyProcessor(this.mapper));
        map.put(FirewallIgnorePatternRecord.class, new FirewallIgnorePatternProcessor(this.mapper));
        map.put(PrivilegeRecord.class, new PrivilegeProcessor(this.mapper));
        map.put(HttpClientRecord.class, new HttpClientProcessor(this.mapper));
        map.put(SelectorRecord.class, new SelectorProcessor(this.mapper));
        map.put(ScriptRecord.class, new ScriptProcessor());
        map.put(AnonymousConfigurationRecord.class, new AnonymousConfigurationProcessor());
        map.put(KeyStoreDataRecord.class, new KeyStoreDataProcessor());
        map.put(ApiKeyRecord.class, new ApiKeyProcessor(this.cipherHandler, this.pbeCipher));
        map.put(UserTokenRecord.class, new UserTokenProcessor(this.cipherHandler, this.pbeCipher));
        map.put(HealthCheckConfigRecord.class, new HealthCheckConfigProcessor(this.mapper));
        map.put(UpgradeModelVersionsRecord.class, new PassThroughItemProcessor());
        map.put(ReplicationConnectionRecord.class, new ReplicationConnectionProcessor(this.mapper));
        map.put(ChangeBlobstoreRecord.class, new ChangeBlobstoreProcessor());
        map.put(ContentRepositoryRecord.class, new ContentRepositoryProcessor(this.mapper));
        map.put(ComponentRecord.class, this.classifierCompositeComponentProcessor());
        map.put(AssetRecord.class, this.classifierCompositeAssetProcessor());
        map.put(DockerForeignLayerRecord.class, new DockerForeignLayerProcessor(this.mapper));
        map.put(AzureDeletedBlobRecord.class, new AzureDeletedBlobProcessor());
        map.put(TagRecord.class, new TagProcessor(this.mapper));
        return map;
    }

    @Bean
    @StepScope
    public ItemProcessor<QuartzJobDetailRecord, QuartzJobDetailEntity> quartzJobDetailProcessor() {
        return new QuartzJobDetailProcessor(this.mapper);
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public ItemProcessor<RepositoryRecord, RepositoryEntity> classifierCompositeRepositoryProcessor() {
        return new ClassifierCompositeItemProcessorBuilder().classifier(new RepositoryProcessorClassifier(this.repositoryProcessorTypeMap(), this.defaultRepositoryProcessor())).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Map<String, ItemProcessor<RepositoryRecord, RepositoryEntity>> repositoryProcessorTypeMap() {
        CaseInsensitiveMap typeMap = new CaseInsensitiveMap();
        Arrays.stream(Format.values()).filter(format -> !typeMap.containsKey(format.name())).forEach(format -> typeMap.put(format.name(), this.defaultRepositoryProcessor()));
        return typeMap;
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public ItemProcessor<RepositoryRecord, RepositoryEntity> defaultRepositoryProcessor() {
        return new RepositoryProcessor(this.mapper);
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public ItemProcessor<ComponentRecord, ComponentEntity> classifierCompositeComponentProcessor() {
        return new ClassifierCompositeItemProcessorBuilder().classifier(new ComponentProcessorClassifier(this.componentProcessorTypeMap(), this.defaultComponentProcessor())).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Map<String, ItemProcessor<ComponentRecord, ComponentEntity>> componentProcessorTypeMap() {
        CaseInsensitiveMap typeMap = new CaseInsensitiveMap();
        typeMap.put(Format.RAW.name(), new RawComponentProcessor(this.mapper));
        typeMap.put(Format.MAVEN2.name(), new MavenComponentProcessor(this.mapper));
        typeMap.put(Format.HELM.name(), this.defaultComponentProcessor());
        typeMap.put(Format.DOCKER.name(), this.defaultComponentProcessor());
        typeMap.put(Format.PYPI.name(), this.defaultComponentProcessor());
        typeMap.put(Format.YUM.name(), this.defaultComponentProcessor());
        typeMap.put(Format.NUGET.name(), this.defaultComponentProcessor());
        typeMap.put(Format.NPM.name(), this.defaultComponentProcessor());
        typeMap.put(Format.APT.name(), this.defaultComponentProcessor());
        typeMap.put(Format.CONDA.name(), this.defaultComponentProcessor());
        typeMap.put(Format.CONAN.name(), this.defaultComponentProcessor());
        typeMap.put(Format.R.name(), this.defaultComponentProcessor());
        typeMap.put(Format.GITLFS.name(), this.defaultComponentProcessor());
        typeMap.put(Format.RUBYGEMS.name(), this.defaultComponentProcessor());
        typeMap.put(Format.COCOAPODS.name(), this.defaultComponentProcessor());
        typeMap.put(Format.P2.name(), this.defaultComponentProcessor());
        typeMap.put(Format.GO.name(), this.defaultComponentProcessor());
        return typeMap;
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public ItemProcessor<ComponentRecord, ComponentEntity> defaultComponentProcessor() {
        return new ComponentProcessor(this.mapper);
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public ItemProcessor<AssetRecord, AssetEntity> classifierCompositeAssetProcessor() {
        return new ClassifierCompositeItemProcessorBuilder().classifier(new AssetProcessorClassifier(this.assetProcessorTypeMap(), this.defaultAssetProcessor())).build();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Map<String, ItemProcessor<AssetRecord, AssetEntity>> assetProcessorTypeMap() {
        CaseInsensitiveMap typeMap = new CaseInsensitiveMap();
        typeMap.put(Format.NUGET.name(), new NugetAssetProcessor(this.mapper));
        typeMap.put(Format.RAW.name(), this.defaultAssetProcessor());
        typeMap.put(Format.MAVEN2.name(), this.defaultAssetProcessor());
        typeMap.put(Format.HELM.name(), this.defaultAssetProcessor());
        typeMap.put(Format.DOCKER.name(), this.defaultAssetProcessor());
        typeMap.put(Format.PYPI.name(), this.defaultAssetProcessor());
        typeMap.put(Format.YUM.name(), this.defaultAssetProcessor());
        typeMap.put(Format.NPM.name(), this.defaultAssetProcessor());
        typeMap.put(Format.APT.name(), this.defaultAssetProcessor());
        typeMap.put(Format.CONDA.name(), this.defaultAssetProcessor());
        typeMap.put(Format.CONAN.name(), this.defaultAssetProcessor());
        typeMap.put(Format.R.name(), this.defaultAssetProcessor());
        typeMap.put(Format.GITLFS.name(), this.defaultAssetProcessor());
        typeMap.put(Format.RUBYGEMS.name(), this.defaultAssetProcessor());
        typeMap.put(Format.COCOAPODS.name(), this.defaultAssetProcessor());
        typeMap.put(Format.P2.name(), this.defaultAssetProcessor());
        typeMap.put(Format.GO.name(), this.defaultAssetProcessor());
        return typeMap;
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public ItemProcessor<AssetRecord, AssetEntity> defaultAssetProcessor() {
        return new AssetProcessor(this.mapper);
    }

    @Bean
    @Conditional(value={H2ToPostgresCondition.class})
    public ItemProcessor<Entity, Entity> h2ToPostgresProcessor() {
        SubclassClassifier<? extends Entity, ItemProcessor<Object, Entity>> classifier = new SubclassClassifier<Entity, ItemProcessor<Object, Entity>>();
        classifier.setTypeMap(this.h2ToPostgresProcessorTypeMap());
        classifier.setDefaultValue(new H2ToPostgresItemProcessor(this.mapper));
        return new ClassifierCompositeItemProcessorBuilder<Entity, Entity>().classifier(classifier).build();
    }

    @Bean
    @Conditional(value={H2ToPostgresCondition.class})
    public Map<Class<? extends Entity>, ItemProcessor<?, ? extends Entity>> h2ToPostgresProcessorTypeMap() {
        HashMap map = new HashMap();
        map.put(RealmEntity.class, new RealmSqlProcessor(this.mapper));
        map.put(QuartzJobDetailEntity.class, this.quartzJobDetailH2ToPostgresProcessor());
        map.put(QuartzTriggerEntity.class, new QuartzTriggerSqlProcessor());
        map.put(ReplicationConnectionEntity.class, new ReplicationConnectionSqlProcessor(this.mapper));
        return map;
    }

    @Bean
    @StepScope
    public ItemProcessor<QuartzJobDetailEntity, QuartzJobDetailEntity> quartzJobDetailH2ToPostgresProcessor() {
        return new QuartzJobDetailH2ToPostgresProcessor();
    }

    @Bean
    @Conditional(value={PostgresToH2Condition.class})
    public ItemProcessor<Entity, Entity> postgresToH2Processor() {
        ImmutableMap<Class<ReplicationConnectionEntity>, ReplicationConnectionSqlProcessor> typeMap = ImmutableMap.of(RealmEntity.class, new RealmSqlProcessor(this.mapper), QuartzJobDetailEntity.class, this.quartzJobDetailPostgresToH2Processor(), QuartzTriggerEntity.class, new QuartzTriggerSqlProcessor(), ReplicationConnectionEntity.class, new ReplicationConnectionSqlProcessor(this.mapper));
        SubclassClassifier<ReplicationConnectionEntity, ItemProcessor<ReplicationConnectionEntity, ReplicationConnectionEntity>> classifier = new SubclassClassifier<ReplicationConnectionEntity, ItemProcessor<ReplicationConnectionEntity, ReplicationConnectionEntity>>();
        classifier.setTypeMap(typeMap);
        classifier.setDefaultValue(new PassThroughItemProcessor());
        return new ClassifierCompositeItemProcessorBuilder<ReplicationConnectionEntity, ReplicationConnectionEntity>().classifier(classifier).build();
    }

    @Bean
    @StepScope
    public ItemProcessor<QuartzJobDetailEntity, QuartzJobDetailEntity> quartzJobDetailPostgresToH2Processor() {
        return new QuartzJobDetailPostgresToH2Processor();
    }

    @Generated
    public ProcessorConfig(ObjectMapper mapper, CipherHandler cipherHandler, PasswordHelper passwordHelper, PbeCipherFactory.PbeCipher pbeCipher) {
        this.mapper = mapper;
        this.cipherHandler = cipherHandler;
        this.passwordHelper = passwordHelper;
        this.pbeCipher = pbeCipher;
    }
}

