/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.db.migrator.condition.OrientMigrationCondition;
import com.sonatype.nexus.db.migrator.condition.SQLSourceCondition;
import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.entity.AnonymousConfigurationEntity;
import com.sonatype.nexus.db.migrator.entity.ApiKeyEntity;
import com.sonatype.nexus.db.migrator.entity.AssetEntity;
import com.sonatype.nexus.db.migrator.entity.AzureDeletedBlobEntity;
import com.sonatype.nexus.db.migrator.entity.BlobStoreEntity;
import com.sonatype.nexus.db.migrator.entity.CapabilityEntity;
import com.sonatype.nexus.db.migrator.entity.ChangeBlobstoreEntity;
import com.sonatype.nexus.db.migrator.entity.CleanupPolicyEntity;
import com.sonatype.nexus.db.migrator.entity.ComponentEntity;
import com.sonatype.nexus.db.migrator.entity.ComponentTagEntity;
import com.sonatype.nexus.db.migrator.entity.ContentRepositoryEntity;
import com.sonatype.nexus.db.migrator.entity.DeploymentIdEntity;
import com.sonatype.nexus.db.migrator.entity.DockerForeignLayerEntity;
import com.sonatype.nexus.db.migrator.entity.EmailEntity;
import com.sonatype.nexus.db.migrator.entity.Entity;
import com.sonatype.nexus.db.migrator.entity.FirewallIgnorePatternEntity;
import com.sonatype.nexus.db.migrator.entity.HealthCheckConfigEntity;
import com.sonatype.nexus.db.migrator.entity.HttpClientEntity;
import com.sonatype.nexus.db.migrator.entity.KeyStoreDataEntity;
import com.sonatype.nexus.db.migrator.entity.LdapConfigurationEntity;
import com.sonatype.nexus.db.migrator.entity.MavenComponentEntity;
import com.sonatype.nexus.db.migrator.entity.PrivilegeEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzCalendarEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzJobDetailEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzTriggerEntity;
import com.sonatype.nexus.db.migrator.entity.RealmEntity;
import com.sonatype.nexus.db.migrator.entity.ReplicationConnectionEntity;
import com.sonatype.nexus.db.migrator.entity.RepositoryEntity;
import com.sonatype.nexus.db.migrator.entity.RoleEntity;
import com.sonatype.nexus.db.migrator.entity.RoutingRuleEntity;
import com.sonatype.nexus.db.migrator.entity.SamlConfigurationEntity;
import com.sonatype.nexus.db.migrator.entity.SamlUserEntity;
import com.sonatype.nexus.db.migrator.entity.ScriptEntity;
import com.sonatype.nexus.db.migrator.entity.SelectorEntity;
import com.sonatype.nexus.db.migrator.entity.TagEntity;
import com.sonatype.nexus.db.migrator.entity.UserEntity;
import com.sonatype.nexus.db.migrator.entity.UserRoleMappingEntity;
import com.sonatype.nexus.db.migrator.entity.UserTokenEntity;
import com.sonatype.nexus.db.migrator.item.record.RecordItem;
import com.sonatype.nexus.db.migrator.property.SelectScriptsAbstract;
import com.sonatype.nexus.db.migrator.reader.ComponentItemReader;
import com.sonatype.nexus.db.migrator.reader.CompositeReader;
import com.sonatype.nexus.db.migrator.reader.ContentRepositoryItemReader;
import com.sonatype.nexus.db.migrator.reader.FileReader;
import com.sonatype.nexus.db.migrator.reader.RecordItemReader;
import com.sonatype.nexus.db.migrator.reader.TagItemReader;
import com.sonatype.nexus.db.migrator.utils.SqlUtils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.batch.item.database.builder.JdbcCursorItemReaderBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.BeanPropertyRowMapper;

@Configuration
public class ReaderConfig {
    private static final String ITEM_READER_NAME_FORMAT = "%sItemReader";
    private DataSource dataSource;
    private SelectScriptsAbstract selectScripts;

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public Tasklet fileReader() {
        return new FileReader();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    public ItemReader<RecordItem> configReader() {
        return new RecordItemReader();
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    @ConditionalOnProperty(name={"content_migration"})
    public ItemReader<RecordItem> contentRepositoryReader() {
        return new ContentRepositoryItemReader(this.objectMapper());
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    @ConditionalOnProperty(name={"content_migration"})
    public ItemReader<RecordItem> tagReader() {
        return new TagItemReader(this.objectMapper());
    }

    @Bean
    @Conditional(value={OrientMigrationCondition.class})
    @ConditionalOnProperty(name={"content_migration"})
    public ItemReader<RecordItem> componentReader() {
        return new ComponentItemReader(this.objectMapper());
    }

    @Bean
    @Conditional(value={SQLSourceCondition.class})
    public ItemReader<Entity> sqlConfigReader() {
        ArrayDeque<JdbcCursorItemReader<JdbcCursorItemReader<? extends Entity>>> delegates = new ArrayDeque<JdbcCursorItemReader<JdbcCursorItemReader<? extends Entity>>>();
        Map<String, Class<? extends Entity>> dbTablesClassesMap = this.configDbTablesClassesMap();
        dbTablesClassesMap.forEach((key, value) -> delegates.add(this.createConfigJdbcCursorItemReader(this.dataSource, (String)key, (Class)value)));
        delegates.add(ReaderConfig.quartzTriggerJdbcCursorItemReader(this.dataSource, this.selectScripts));
        return new CompositeReader<Entity>(delegates);
    }

    @Bean
    @Conditional(value={SQLSourceCondition.class})
    public ItemReader<Entity> sqlTagReader() {
        ArrayDeque<JdbcCursorItemReader<JdbcCursorItemReader<TagEntity>>> delegates = new ArrayDeque<JdbcCursorItemReader<JdbcCursorItemReader<TagEntity>>>();
        delegates.add(this.createItemReader(SqlUtils.readSqlFromFile(this.selectScripts.getTag()), TagEntity.class));
        return new CompositeReader<Entity>(delegates);
    }

    @Bean
    @Conditional(value={SQLSourceCondition.class})
    public ItemReader<Entity> sqlComponentReader() {
        ArrayDeque<JdbcCursorItemReader<JdbcCursorItemReader<Entity>>> delegates = new ArrayDeque<JdbcCursorItemReader<JdbcCursorItemReader<Entity>>>();
        Map<String, Class<? extends ComponentEntity>> componentEntityByFormat = this.componentEntityByFormatMap();
        Format.SUPPORTED_FORMAT_NAMES.forEach(format -> delegates.add(this.createItemReader(ReaderConfig.loadSql(this.selectScripts.getContentRepository(), format), ContentRepositoryEntity.class)));
        Format.SUPPORTED_FORMAT_NAMES.forEach(format -> delegates.add(this.createItemReader(ReaderConfig.loadSql(this.selectScripts.getComponent(), format), componentEntityByFormat.getOrDefault(format, ComponentEntity.class))));
        Format.SUPPORTED_FORMAT_NAMES.forEach(format -> delegates.add(this.createItemReader(ReaderConfig.loadSql(this.selectScripts.getAsset(), format), AssetEntity.class)));
        Format.SUPPORTED_FORMAT_NAMES.forEach(format -> delegates.add(this.createItemReader(ReaderConfig.loadSql(this.selectScripts.getComponentTag(), format), ComponentTagEntity.class)));
        if (Format.SUPPORTED_FORMAT_NAMES.contains(Format.DOCKER.name())) {
            delegates.add(this.createItemReader(ReaderConfig.loadSql(this.selectScripts.getDockerForeignLayers(), Format.DOCKER.name()), DockerForeignLayerEntity.class));
        }
        delegates.add(this.createItemReader(SqlUtils.readSqlFromFile(this.selectScripts.getAzureDeletedBlobs()), AzureDeletedBlobEntity.class));
        return new CompositeReader<Entity>(delegates);
    }

    private Map<String, Class<? extends ComponentEntity>> componentEntityByFormatMap() {
        return ImmutableMap.of(Format.MAVEN2.name(), MavenComponentEntity.class);
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper().registerModule(new JodaModule()).registerModule(new JavaTimeModule());
        mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        return mapper;
    }

    private static final String loadSql(String scriptPath, String format) {
        return String.format(SqlUtils.readSqlFromFile(scriptPath), format);
    }

    private Map<String, Class<? extends Entity>> configDbTablesClassesMap() {
        HashMap<String, Class<? extends Entity>> tablesClassesMap = new HashMap<String, Class<? extends Entity>>();
        tablesClassesMap.put("ANONYMOUS_CONFIGURATION", AnonymousConfigurationEntity.class);
        tablesClassesMap.put("API_KEY", ApiKeyEntity.class);
        tablesClassesMap.put("BLOB_STORE_CONFIGURATION", BlobStoreEntity.class);
        tablesClassesMap.put("CAPABILITY_STORAGE_ITEM", CapabilityEntity.class);
        tablesClassesMap.put("CHANGE_BLOBSTORE", ChangeBlobstoreEntity.class);
        tablesClassesMap.put("CLEANUP_POLICY", CleanupPolicyEntity.class);
        tablesClassesMap.put("DEPLOYMENT_ID", DeploymentIdEntity.class);
        tablesClassesMap.put("EMAIL_CONFIGURATION", EmailEntity.class);
        tablesClassesMap.put("FIREWALL_IGNORE_PATTERNS", FirewallIgnorePatternEntity.class);
        tablesClassesMap.put("HTTP_CLIENT_CONFIGURATION", HttpClientEntity.class);
        tablesClassesMap.put("KEY_STORE_DATA", KeyStoreDataEntity.class);
        tablesClassesMap.put("LDAP_CONFIGURATION", LdapConfigurationEntity.class);
        tablesClassesMap.put("SAML_CONFIGURATION", SamlConfigurationEntity.class);
        tablesClassesMap.put("SAML_USER", SamlUserEntity.class);
        tablesClassesMap.put("PRIVILEGE", PrivilegeEntity.class);
        tablesClassesMap.put("REALM_CONFIGURATION", RealmEntity.class);
        tablesClassesMap.put("REPLICATION_CONNECTION", ReplicationConnectionEntity.class);
        tablesClassesMap.put("REPOSITORY", RepositoryEntity.class);
        tablesClassesMap.put("REPOSITORY_ROUTING_RULE", RoutingRuleEntity.class);
        tablesClassesMap.put("RHC_CONFIGURATION", HealthCheckConfigEntity.class);
        tablesClassesMap.put("ROLE", RoleEntity.class);
        tablesClassesMap.put("SCRIPT", ScriptEntity.class);
        tablesClassesMap.put("SECURITY_USER", UserEntity.class);
        tablesClassesMap.put("SELECTOR_CONFIGURATION", SelectorEntity.class);
        tablesClassesMap.put("USER_ROLE_MAPPING", UserRoleMappingEntity.class);
        tablesClassesMap.put("USER_TOKEN", UserTokenEntity.class);
        tablesClassesMap.put("QRTZ_JOB_DETAILS", QuartzJobDetailEntity.class);
        tablesClassesMap.put("QRTZ_CALENDARS", QuartzCalendarEntity.class);
        return tablesClassesMap;
    }

    private static JdbcCursorItemReader<? extends Entity> quartzTriggerJdbcCursorItemReader(DataSource dataSource, SelectScriptsAbstract selectScriptProperties) {
        return new JdbcCursorItemReaderBuilder().name(String.format(ITEM_READER_NAME_FORMAT, QuartzTriggerEntity.class.getSimpleName())).dataSource(dataSource).sql(SqlUtils.readSqlFromFile(selectScriptProperties.getQuartzTrigger())).rowMapper(new BeanPropertyRowMapper<QuartzTriggerEntity>(QuartzTriggerEntity.class)).build();
    }

    private <E extends Entity> JdbcCursorItemReader<E> createConfigJdbcCursorItemReader(DataSource dataSource, String tableName, Class<E> entityClass) {
        String selectQueryTemplate = "SELECT * FROM ";
        return new JdbcCursorItemReaderBuilder().name(String.format(ITEM_READER_NAME_FORMAT, entityClass.getSimpleName())).dataSource(dataSource).sql(selectQueryTemplate + tableName).rowMapper(new BeanPropertyRowMapper<E>(entityClass)).build();
    }

    private <E extends Entity> JdbcCursorItemReader<E> createItemReader(String sql, Class<E> entityClass) {
        return new JdbcCursorItemReaderBuilder().name(String.format(ITEM_READER_NAME_FORMAT, entityClass.getSimpleName())).dataSource(this.dataSource).sql(sql).rowMapper(new BeanPropertyRowMapper<E>(entityClass)).build();
    }

    @Autowired(required=false)
    @Qualifier(value="sourceDataSource")
    @Conditional(value={SQLSourceCondition.class})
    public void setSourceDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Autowired(required=false)
    @Conditional(value={SQLSourceCondition.class})
    public void setSelectScripts(SelectScriptsAbstract selectScripts) {
        this.selectScripts = selectScripts;
    }
}

