/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.decider;

import com.sonatype.nexus.db.migrator.utils.OrientDocumentUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

public class OSSDecider
implements JobExecutionDecider {
    private String orientFolderPath;

    public OSSDecider(String orientFolderPath) {
        this.orientFolderPath = orientFolderPath;
    }

    @Override
    public FlowExecutionStatus decide(JobExecution jobExecution, StepExecution stepExecution) {
        if (this.isOssDatabase()) {
            return new FlowExecutionStatus("DECISION_HEALTH_CHECK_SKIP");
        }
        return new FlowExecutionStatus("DECISION_HEALTH_CHECK_START");
    }

    private boolean isOssDatabase() {
        OrientDocumentUtils orientDocumentUtils = new OrientDocumentUtils(this.orientFolderPath);
        return !orientDocumentUtils.classExists("config", "saml") && !orientDocumentUtils.classExists("config", "saml_user");
    }
}

