/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.listener;

import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ExecutionContext;

@StepScope
public class ProcessRecordStepListener
implements StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessRecordStepListener.class);

    @Override
    public void beforeStep(StepExecution stepExecution) {
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        int writeCount = executionContext.get("records_number_migrated") == null ? stepExecution.getWriteCount() : executionContext.getInt("records_number_migrated") + stepExecution.getWriteCount();
        int skipCount = executionContext.get("records_number_skipped") == null ? stepExecution.getSkipCount() : executionContext.getInt("records_number_skipped") + stepExecution.getSkipCount();
        int filterCount = executionContext.get("records_number_filtered") == null ? stepExecution.getFilterCount() : executionContext.getInt("records_number_filtered") + stepExecution.getFilterCount();
        boolean isH2ToPostgresMigration = "h2_to_postgres".equals(ProcessRecordStepListener.getMigrationType(stepExecution));
        boolean isPostgresToH2Migration = "postgres_to_h2".equals(ProcessRecordStepListener.getMigrationType(stepExecution));
        if (isH2ToPostgresMigration || isPostgresToH2Migration) {
            int readCount = executionContext.get("records_number_to_process") == null ? stepExecution.getReadCount() : executionContext.getInt("records_number_migrated") + stepExecution.getReadCount();
            executionContext.put("records_number_to_process", readCount);
        }
        executionContext.put("records_number_skipped", skipCount);
        executionContext.put("records_number_migrated", writeCount);
        executionContext.put("records_number_filtered", filterCount);
        log.info("{} migrated {} records, skipped {} records", stepExecution.getStepName(), stepExecution.getWriteCount(), stepExecution.getSkipCount());
        return ExitStatus.COMPLETED;
    }

    private static String getMigrationType(StepExecution stepExecution) {
        return ConvertUtils.convertJobParametersToMap(stepExecution.getJobParameters()).get("migration_type").toString();
    }
}

