/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.sonatype.nexus.db.migrator.entity.ApiKeyEntity;
import com.sonatype.nexus.db.migrator.item.record.ApiKeyRecord;
import com.sonatype.nexus.db.migrator.utils.CipherHandler;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Optional;
import lombok.Generated;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.springframework.batch.item.ItemProcessor;

public class ApiKeyProcessor
implements ItemProcessor<ApiKeyRecord, ApiKeyEntity> {
    private final CipherHandler cipherHandler;
    private final PbeCipherFactory.PbeCipher pbeCipher;

    @Override
    public ApiKeyEntity process(ApiKeyRecord item) {
        return ApiKeyEntity.builder().primaryPrincipal(this.cipherHandler.encrypt(item.getPrimaryPrincipal())).domain(item.getDomain()).principals(this.pbeCipher.encrypt(item.getPrincipals())).token(this.cipherHandler.encrypt(item.getApiKey())).created(this.toLocalDateTime(item.getCreated())).build();
    }

    private OffsetDateTime toLocalDateTime(Long timestamp) {
        return Optional.ofNullable(timestamp).map(Instant::ofEpochMilli).map(created -> OffsetDateTime.ofInstant(created, ZoneId.of("UTC"))).orElseGet(OffsetDateTime::now);
    }

    @Generated
    public ApiKeyProcessor(CipherHandler cipherHandler, PbeCipherFactory.PbeCipher pbeCipher) {
        this.cipherHandler = cipherHandler;
        this.pbeCipher = pbeCipher;
    }
}

