/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.sonatype.nexus.db.migrator.entity.EmailEntity;
import com.sonatype.nexus.db.migrator.item.record.EmailRecord;
import com.sonatype.nexus.db.migrator.utils.CipherHandler;
import java.util.Optional;
import lombok.Generated;
import org.sonatype.nexus.security.PasswordHelper;
import org.springframework.batch.item.ItemProcessor;

public class EmailProcessor
implements ItemProcessor<EmailRecord, EmailEntity> {
    private final CipherHandler cipherHandler;
    private final PasswordHelper passwordHelper;

    @Override
    public EmailEntity process(EmailRecord item) {
        return EmailEntity.builder().enabled(item.isEnabled()).fromAddress(item.getFromAddress()).host(item.getHost()).nexusTrustStoreEnabled(item.isNexusTrustStoreEnabled()).password(this.encryptPassword(item.getPassword())).port(item.getPort()).sslCheckServerIdentityEnabled(item.isSslCheckServerIdentityEnabled()).sslOnConnectEnabled(item.isSslOnConnectEnabled()).startTlsEnabled(item.isStartTlsEnabled()).startTlsRequired(item.isStartTlsRequired()).subjectPrefix(item.getSubjectPrefix()).username(item.getUsername()).build();
    }

    private String encryptPassword(String password) {
        return Optional.ofNullable(password).map(this.passwordHelper::decrypt).map(this.cipherHandler::encrypt).orElse(null);
    }

    @Generated
    public EmailProcessor(CipherHandler cipherHandler, PasswordHelper passwordHelper) {
        this.cipherHandler = cipherHandler;
        this.passwordHelper = passwordHelper;
    }
}

