/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.sonatype.nexus.db.migrator.entity.QuartzJobDetailEntity;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.QuartzFilterUtils;
import java.util.Map;
import lombok.Generated;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Value;

public class QuartzJobDetailH2ToPostgresProcessor
implements ItemProcessor<QuartzJobDetailEntity, QuartzJobDetailEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzJobDetailH2ToPostgresProcessor.class);
    private static final String H2_BACKUP_TASK_ID = "h2.backup.task";
    private static final String TYPE_ID_ATTRIBUTE = ".typeId";
    private boolean contentMigration;

    @Override
    public QuartzJobDetailEntity process(QuartzJobDetailEntity item) throws Exception {
        Object jobData = ConvertUtils.convertBytesToObject(item.getJobData());
        boolean shouldBeFiltered = false;
        if (jobData instanceof JobDataMap) {
            JobDataMap jobDataMap = (JobDataMap)jobData;
            shouldBeFiltered = QuartzFilterUtils.containsFilteredRepository(jobDataMap) || QuartzFilterUtils.shouldTaskBeSkipped(jobDataMap, this.contentMigration) || this.isH2BackupTask(jobDataMap);
        } else if (jobData instanceof Map) {
            Map jobDataMap = (Map)jobData;
            boolean bl = shouldBeFiltered = QuartzFilterUtils.containsFilteredRepository(jobDataMap) || QuartzFilterUtils.shouldTaskBeSkipped(jobDataMap, this.contentMigration);
        }
        if (shouldBeFiltered) {
            log.info("Filtered QuartzJobDetail record {}", (Object)item.getDescription());
            QuartzFilterUtils.addFilteredJobName(item.getJobName());
            return null;
        }
        return item;
    }

    private boolean isH2BackupTask(JobDataMap jobDataMap) {
        return H2_BACKUP_TASK_ID.equals(jobDataMap.getString(TYPE_ID_ATTRIBUTE));
    }

    @Value(value="#{jobParameters['-' + T(com.sonatype.nexus.db.migrator.config.Constants).JOB_PARAMETER_CONTENT_MIGRATION]}")
    public void setContentMigration(boolean contentMigration) {
        this.contentMigration = contentMigration;
    }
}

