/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.sonatype.nexus.db.migrator.entity.QuartzJobDetailEntity;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.QuartzFilterUtils;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Value;

public class QuartzJobDetailPostgresToH2Processor
implements ItemProcessor<QuartzJobDetailEntity, QuartzJobDetailEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzJobDetailPostgresToH2Processor.class);
    private boolean contentMigration;

    @Override
    public QuartzJobDetailEntity process(QuartzJobDetailEntity item) throws Exception {
        if (this.shouldFilter(item)) {
            log.info("Filtered QuartzJobDetail record {}", (Object)item.getDescription());
            QuartzFilterUtils.addFilteredJobName(item.getJobName());
            return null;
        }
        return item;
    }

    private boolean shouldFilter(QuartzJobDetailEntity item) throws IOException, ClassNotFoundException {
        Object jobData = ConvertUtils.convertBytesToObject(item.getJobData());
        if (jobData instanceof JobDataMap) {
            JobDataMap jobDataMap = (JobDataMap)jobData;
            return QuartzFilterUtils.containsFilteredRepository(jobDataMap) || QuartzFilterUtils.shouldTaskBeSkipped(jobDataMap, this.contentMigration);
        }
        if (jobData instanceof Map) {
            Map jobDataMap = (Map)jobData;
            return QuartzFilterUtils.containsFilteredRepository(jobDataMap) || QuartzFilterUtils.shouldTaskBeSkipped(jobDataMap, this.contentMigration);
        }
        return false;
    }

    @Value(value="#{jobParameters['-' + T(com.sonatype.nexus.db.migrator.config.Constants).JOB_PARAMETER_CONTENT_MIGRATION]}")
    public void setContentMigration(boolean contentMigration) {
        this.contentMigration = contentMigration;
    }
}

