/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.entity.QuartzTriggerEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzTriggerType;
import com.sonatype.nexus.db.migrator.item.record.quartz.trigger.QuartzTriggerCron;
import com.sonatype.nexus.db.migrator.item.record.quartz.trigger.QuartzTriggerData;
import com.sonatype.nexus.db.migrator.item.record.quartz.trigger.QuartzTriggerRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.QuartzFilterUtils;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzTriggerProcessor
extends AbstractItemProcessor<QuartzTriggerRecord, QuartzTriggerEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzTriggerProcessor.class);

    public QuartzTriggerProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public QuartzTriggerEntity process(QuartzTriggerRecord item) throws IOException {
        if (QuartzFilterUtils.isJobFiltered(item.getJobName())) {
            log.info("Filtered QuartzTrigger record {}", (Object)item.getTriggerData().getDescription());
            return null;
        }
        if (QuartzFilterUtils.shouldTriggerBeSkipped(item.getState(), item.getTriggerData().getJobDataMap())) {
            log.info("Filtered QuartzTrigger record {} in state {}", (Object)item.getName(), (Object)item.getState());
            return null;
        }
        QuartzTriggerData triggerData = item.getTriggerData();
        QuartzTriggerCron triggerCron = triggerData.getCron();
        boolean isCronTrigger = triggerCron != null;
        QuartzTriggerType triggerType = isCronTrigger ? QuartzTriggerType.CRON : QuartzTriggerType.SIMPLE;
        return QuartzTriggerEntity.builder().triggerName(item.getName()).triggerGroup(item.getGroup()).jobName(item.getJobName()).jobGroup(item.getJobGroup()).description(triggerData.getDescription()).nextFireTime(triggerData.getNextFireTime()).prevFireTime(triggerData.getPreviousFireTime()).priority(triggerData.getPriority()).triggerState(item.getState()).triggerType(triggerType.name()).startTime(triggerData.getStartTime()).calendarName(item.getCalendarName()).misfireInstruction(triggerData.getMisfireInstruction()).jobData(ConvertUtils.convertObjectToBytes(triggerData.getJobDataMap())).repeatCount(triggerData.getRepeatCount()).repeatInterval(triggerData.getRepeatInterval()).timesTriggered(triggerData.getTimesTriggered()).cronExpression(isCronTrigger ? triggerCron.getCronExpression() : null).timeZoneId(isCronTrigger ? triggerCron.getTimeZone() : null).build();
    }
}

