/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.sonatype.nexus.db.migrator.entity.QuartzTriggerEntity;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.QuartzFilterUtils;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemProcessor;

public class QuartzTriggerSqlProcessor
implements ItemProcessor<QuartzTriggerEntity, QuartzTriggerEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzTriggerSqlProcessor.class);

    @Override
    public QuartzTriggerEntity process(QuartzTriggerEntity item) throws IOException, ClassNotFoundException {
        if (QuartzFilterUtils.isJobFiltered(item.getJobName())) {
            log.info("Filtered QuartzTrigger record {}", (Object)item.getDescription());
            return null;
        }
        boolean shouldBeFiltered = false;
        Object jobData = ConvertUtils.convertBytesToObject(item.getJobData());
        if (jobData instanceof JobDataMap) {
            JobDataMap jobDataMap = (JobDataMap)jobData;
            shouldBeFiltered = QuartzFilterUtils.shouldTriggerBeSkipped(item.getTriggerState(), jobDataMap);
        } else if (jobData instanceof Map) {
            Map jobDataMap = (Map)jobData;
            shouldBeFiltered = QuartzFilterUtils.shouldTriggerBeSkipped(item.getTriggerState(), jobDataMap);
        }
        if (shouldBeFiltered) {
            log.info("Filtered QuartzTrigger record {} in state {}", (Object)item.getTriggerName(), (Object)item.getTriggerState());
            return null;
        }
        return item;
    }
}

