/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.entity.ReplicationConnectionEntity;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationConnectionSqlProcessor
extends AbstractItemProcessor<ReplicationConnectionEntity, ReplicationConnectionEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReplicationConnectionSqlProcessor.class);

    public ReplicationConnectionSqlProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ReplicationConnectionEntity process(ReplicationConnectionEntity item) throws IOException {
        List regexList = null;
        if (item.getContentRegexes() != null) {
            String[] regexArray = item.getContentRegexes().split(",");
            regexList = Arrays.stream(regexArray).map(regex -> regex.replaceAll("[\"\\\\\\]\\[\\s+]", "")).collect(Collectors.toList());
        }
        return ReplicationConnectionEntity.builder().id(item.getId()).name(item.getName()).destinationInstancePassword(item.getDestinationInstancePassword()).destinationRepositoryName(item.getDestinationRepositoryName()).destinationInstanceUrl(item.getDestinationInstanceUrl()).destinationInstanceUsername(item.getDestinationInstanceUsername()).sourceRepositoryName(item.getSourceRepositoryName()).includeExistingContent(item.isIncludeExistingContent()).contentRegexes(this.convertObjectToString(regexList)).build();
    }
}

