/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.entity.SamlConfigurationEntity;
import com.sonatype.nexus.db.migrator.item.record.saml.SamlConfigurationRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import com.sonatype.nexus.db.migrator.utils.CipherHandler;
import java.util.Objects;
import org.sonatype.nexus.security.PasswordHelper;

public class SamlConfigurationProcessor
extends AbstractItemProcessor<SamlConfigurationRecord, SamlConfigurationEntity> {
    private final CipherHandler cipherHandler;
    private final PasswordHelper passwordHelper;

    public SamlConfigurationProcessor(ObjectMapper mapper, CipherHandler cipherHandler, PasswordHelper passwordHelper) {
        super(mapper);
        this.cipherHandler = cipherHandler;
        this.passwordHelper = passwordHelper;
    }

    @Override
    public SamlConfigurationEntity process(SamlConfigurationRecord item) throws Exception {
        return SamlConfigurationEntity.builder().entityId(item.getEntityId()).idpMetadata(item.getIdpMetadata()).mapping(this.convertObjectToString(item.getMapping())).validateResponseSignature(item.getValidateResponseSignature()).validateAssertionSignature(item.getValidateAssertionSignature()).keyStorePassword(this.convertPasswordEncryption(item.getKeyStorePassword())).keyStoreBytes(item.getKeyStoreBytes()).build();
    }

    private String convertPasswordEncryption(String password) {
        return this.cipherHandler.encrypt(Objects.requireNonNull(this.passwordHelper.decrypt(password)));
    }
}

