/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.entity.SelectorEntity;
import com.sonatype.nexus.db.migrator.exception.ContentSelectorCoordinateException;
import com.sonatype.nexus.db.migrator.item.record.SelectorRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import java.io.IOException;
import java.util.Map;

public class SelectorProcessor
extends AbstractItemProcessor<SelectorRecord, SelectorEntity> {
    private static final String EXPRESSION = "expression";
    private static final String COORDINATE = "coordinate.";

    public SelectorProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public SelectorEntity process(SelectorRecord item) throws IOException, ContentSelectorCoordinateException {
        return SelectorEntity.builder().name(item.getName()).type(item.getType()).description(item.getDescription()).attributes(this.convertObjectToString(this.failJobIfSelectorContainsCoordinates(item))).build();
    }

    private Map<String, String> failJobIfSelectorContainsCoordinates(SelectorRecord item) throws ContentSelectorCoordinateException {
        String expression;
        Map<String, String> attributes = item.getAttributes();
        if (attributes.containsKey(EXPRESSION) && (expression = attributes.get(EXPRESSION)).contains(COORDINATE)) {
            String errorMessage = System.getProperty("line.separator") + item.getName() + " selector contains \"coordinate\" reference ";
            throw new ContentSelectorCoordinateException(errorMessage);
        }
        return attributes;
    }
}

