/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.sonatype.nexus.db.migrator.entity.UserTokenEntity;
import com.sonatype.nexus.db.migrator.item.record.UserTokenRecord;
import com.sonatype.nexus.db.migrator.utils.CipherHandler;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import lombok.Generated;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.springframework.batch.item.ItemProcessor;

public class UserTokenProcessor
implements ItemProcessor<UserTokenRecord, UserTokenEntity> {
    private final CipherHandler cipherHandler;
    private final PbeCipherFactory.PbeCipher pbeCipher;

    @Override
    public UserTokenEntity process(UserTokenRecord item) {
        return UserTokenEntity.builder().userName(this.cipherHandler.encrypt(item.getUserName())).nameCode(item.getNameCode()).passCode(item.getPassCode()).principals(this.pbeCipher.encrypt(item.getPrincipals())).created(ConvertUtils.convertLongToOffsetDateTime(item.getCreated())).build();
    }

    @Generated
    public UserTokenProcessor(CipherHandler cipherHandler, PbeCipherFactory.PbeCipher pbeCipher) {
        this.cipherHandler = cipherHandler;
        this.pbeCipher = pbeCipher;
    }
}

