/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor.content;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.entity.AssetEntity;
import com.sonatype.nexus.db.migrator.item.record.content.AssetRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import com.sonatype.nexus.db.migrator.utils.ComponentIdUtils;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.DateParserUtil;
import com.sonatype.nexus.db.migrator.utils.ProcessingUtils;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.h2.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetProcessor
extends AbstractItemProcessor<AssetRecord, AssetEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetProcessor.class);
    private static final String ID_MATCHER = "[\\w-]{30,}";
    private static final String CANONICAL_PATTERN = String.format("(?<store>.+)@(?<blobid>%s$)", "[\\w-]{30,}");
    private static final String BLOB_REF_SIMPLE_FORMAT = "%s@%s";
    private static final String ORIENT_PATTERN = String.format("(?<ostore>.+)@(%s):(?<oblobid>%s$)", "[\\w-]{30,}", "[\\w-]{30,}");
    private static final String SQL_PATTERN = String.format("(?<sstore>.+):(?<sblobid>%s)@(%s$)", "[\\w-]{30,}", "[\\w-]{30,}");
    private static final Pattern BLOB_REF_PATTERN = Pattern.compile(String.format("(%s)|(%s)|(%s)", CANONICAL_PATTERN, ORIENT_PATTERN, SQL_PATTERN));
    private static final String ASSET_KIND_ATTRIBUTE = "asset_kind";
    private static final String CHECKSUM_ATTRIBUTE = "checksum";
    private static final String CACHE_ATTRIBUTE = "cache";
    public static final String CONTENT_ATTRIBUTE = "content";
    private static final String LAST_VERIFIED_ATTRIBUTE = "last_verified";
    public static final String LAST_MODIFIED_ATTRIBUTE = "last_modified";
    private static final Random RANDOM = new Random();

    public AssetProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public AssetEntity process(AssetRecord item) throws IOException {
        AssetEntity assetEntity = null;
        try {
            Integer componentId;
            log.trace("Processing: {}", (Object)item);
            AssetProcessor.fixEmptyAssetName(item);
            String format = item.getFormat();
            Integer repositoryId = ComponentIdUtils.getRepositoryId(item.getBucket());
            if (Format.isNotSupportedFormat(format)) {
                log.info("Filtered {} Asset record {}, Reason - Unsupported format", (Object)format, (Object)item);
                return null;
            }
            if (repositoryId == null) {
                log.info("Filtered {} Asset record {}, Reason - Asset has no repositoryId", (Object)format, (Object)item);
                return null;
            }
            if (StringUtils.isNullOrEmpty(item.getBlobRef())) {
                log.warn("Asset {} does not have a blob reference. Skip it.", (Object)item.getName());
                return null;
            }
            if (!ComponentIdUtils.repositoryExists(format, repositoryId)) {
                log.warn("Filtered {} Asset record {}, Repository id {}, Reason - Repository not found", format, item, repositoryId);
                return null;
            }
            Integer n = componentId = item.getComponent() != null ? ComponentIdUtils.getComponentId(item.getComponent()) : null;
            if (componentId != null && !this.componentReferenceExists(format, componentId)) {
                log.warn("Asset {} does not have a component reference. Skip it.", (Object)item.getName());
                return null;
            }
            Integer assetId = ComponentIdUtils.generateAssetId(format);
            Integer assetBlobId = ComponentIdUtils.generateAssetBlobId(format);
            OffsetDateTime lastUpdated = ConvertUtils.convertLongToOffsetDateTime(item.getLastUpdated());
            OffsetDateTime assetCreated = ConvertUtils.convertLongToOffsetDateTime(item.getBlobCreated());
            OffsetDateTime blobCreated = ConvertUtils.convertLongToOffsetDateTime(item.getBlobUpdated());
            OffsetDateTime addedToRepository = ConvertUtils.convertLongToOffsetDateTime(item.getAddedToRepository());
            assetEntity = AssetEntity.builder().format(format).assetId(assetId).repositoryId(repositoryId).path(this.formatPath(item.getName())).kind(ProcessingUtils.getKind(item.getAttributes(), format, ASSET_KIND_ATTRIBUTE)).componentId(componentId).created(assetCreated).lastUpdated(lastUpdated).lastDownloaded(item.getLastDownloaded() == 0L ? null : ConvertUtils.convertLongToOffsetDateTime(item.getLastDownloaded())).attributes(this.convertObjectToString(this.convertAttributesIfNeeded(item.getAttributes()))).assetBlobId(assetBlobId).blobRef(this.reformatBlobRef(item.getBlobRef())).blobSize(item.getSize()).contentType(item.getContentType()).checksums(this.convertObjectToString(item.getAttributes().get(CHECKSUM_ATTRIBUTE))).blobCreated(blobCreated).createdBy(item.getCreatedBy()).createdByIp(item.getCreatedByIp()).addedToRepository(addedToRepository).build();
        }
        catch (Exception e) {
            log.error("Asset failed to process because of {}: {}", (Object)e.getMessage(), (Object)item);
            log.debug("Stack Trace:", e);
        }
        return assetEntity;
    }

    private boolean componentReferenceExists(String format, Integer componentId) {
        Set<Integer> savedComponentIds = ComponentIdUtils.getSavedComponentIds(format);
        return savedComponentIds.contains(componentId);
    }

    private String formatPath(String path) {
        return path.charAt(0) == '/' ? path : '/' + path;
    }

    private String reformatBlobRef(String ref) {
        Matcher matcher = BLOB_REF_PATTERN.matcher(ref);
        if (!matcher.matches()) {
            log.error("Unable to convert {}", (Object)ref);
            return null;
        }
        String store = matcher.group("store");
        if (store != null) {
            return String.format(BLOB_REF_SIMPLE_FORMAT, store, matcher.group("blobid"));
        }
        store = matcher.group("ostore");
        if (store != null) {
            return String.format(BLOB_REF_SIMPLE_FORMAT, store, matcher.group("oblobid"));
        }
        store = matcher.group("sstore");
        if (store != null) {
            return String.format(BLOB_REF_SIMPLE_FORMAT, store, matcher.group("sblobid"));
        }
        return null;
    }

    protected Map<String, Object> convertAttributesIfNeeded(Map<String, Object> attributes) {
        this.findAndConvertDateAttributes(attributes, CACHE_ATTRIBUTE, LAST_VERIFIED_ATTRIBUTE);
        this.findAndConvertDateAttributes(attributes, CONTENT_ATTRIBUTE, LAST_MODIFIED_ATTRIBUTE);
        return attributes;
    }

    protected void findAndConvertDateAttributes(Map<String, Object> attributes, String innerAttributeMapKey, String dateAttributeKey) {
        if (attributes.containsKey(innerAttributeMapKey) && attributes.get(innerAttributeMapKey) instanceof Map) {
            Map innerAttributeMap = (Map)attributes.get(innerAttributeMapKey);
            innerAttributeMap.computeIfPresent(dateAttributeKey, (key, value) -> DateParserUtil.parseDateOrNow(value).toString());
        }
    }

    private static void fixEmptyAssetName(AssetRecord item) {
        String name = item.getName();
        if (StringUtils.isNullOrEmpty(name)) {
            item.setName(String.format("%s%s", Character.valueOf('/'), RANDOM.nextInt()));
        }
    }
}

