/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor.content;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.entity.ComponentEntity;
import com.sonatype.nexus.db.migrator.item.record.content.ComponentRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import com.sonatype.nexus.db.migrator.utils.ComponentIdUtils;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentProcessor
extends AbstractItemProcessor<ComponentRecord, ComponentEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentProcessor.class);

    public ComponentProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ComponentEntity process(ComponentRecord item) throws IOException {
        ComponentEntity componentEntity = null;
        try {
            log.trace("Processing: {}", (Object)item);
            String format = item.getFormat();
            Integer repositoryId = ComponentIdUtils.getRepositoryId(item.getBucket());
            if (Format.isNotSupportedFormat(format)) {
                log.info("Filtered {} Component record {}, Reason - Unsupported format", (Object)format, (Object)item);
                return null;
            }
            if (repositoryId == null) {
                log.info("Filtered {} Component record {}, Reason - Component has no repositoryId", (Object)format, (Object)item);
                return null;
            }
            Integer componentId = ComponentIdUtils.generateComponentId(format, item.getRid());
            OffsetDateTime lastUpdated = ConvertUtils.convertLongToOffsetDateTime(item.getLastUpdated());
            componentEntity = (ComponentEntity)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)((ComponentEntity.ComponentEntityBuilder)this.entityBuilder().componentId(componentId)).repositoryId(repositoryId)).namespace(Optional.ofNullable(item.getGroup()).orElse(""))).name(item.getName())).kind("")).version(Optional.ofNullable(item.getVersion()).orElse(""))).attributes(this.convertObjectToString(item.getAttributes()))).format(format)).tags(ComponentIdUtils.convertTagIds(item.getTags()))).created(lastUpdated)).lastUpdated(lastUpdated)).build();
        }
        catch (Exception e) {
            log.error("Component failed to process because of {}: {}", (Object)e.getMessage(), (Object)item);
            log.debug("Stack Trace:", e);
        }
        return componentEntity;
    }

    protected ComponentEntity.ComponentEntityBuilder<? extends ComponentEntity, ?> entityBuilder() {
        return ComponentEntity.builder();
    }
}

