/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor.content;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.entity.ContentRepositoryEntity;
import com.sonatype.nexus.db.migrator.item.record.content.ContentRepositoryRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import com.sonatype.nexus.db.migrator.utils.ComponentIdUtils;
import com.sonatype.nexus.db.migrator.utils.RepositoryUtils;
import java.io.IOException;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentRepositoryProcessor
extends AbstractItemProcessor<ContentRepositoryRecord, ContentRepositoryEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentRepositoryProcessor.class);

    public ContentRepositoryProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ContentRepositoryEntity process(ContentRepositoryRecord item) throws IOException {
        log.trace("Processing: {}", (Object)item);
        String repositoryName = item.getRepositoryName();
        String format = RepositoryUtils.getFormatByRecord(item);
        if (Format.isNotSupportedFormat(format) || RepositoryUtils.isRepositoryFiltered(repositoryName)) {
            log.info("Filtered {} ContentRepository record {}, Reason - Unsupported format or already filtered repository", (Object)repositoryName, (Object)item);
            return null;
        }
        Integer repositoryId = ComponentIdUtils.generateRepositoryId(format, item.getRid());
        return ContentRepositoryEntity.builder().repositoryId(repositoryId).format(format).configRepositoryId(UUID.nameUUIDFromBytes(repositoryName.getBytes())).attributes(this.convertObjectToString(item.getAttributes())).build();
    }
}

