/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.reader;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.item.record.RecordItem;
import com.sonatype.nexus.db.migrator.item.record.content.ContentRepositoryRecord;
import com.sonatype.nexus.db.migrator.item.record.content.TagRecord;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;

public class ComponentItemReader
implements ItemReader<RecordItem>,
StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentItemReader.class);
    protected ObjectMapper mapper;
    protected JsonParser parser;
    private int processedComponentsCount = 0;

    public ComponentItemReader(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public RecordItem read() throws Exception {
        while (this.parser != null && this.parser.nextToken() != null) {
            RecordItem item = this.mapper.readValue(this.parser, RecordItem.class);
            if (item == null) continue;
            if (!(item instanceof ContentRepositoryRecord) && !(item instanceof TagRecord)) {
                ++this.processedComponentsCount;
                return item;
            }
            ++this.processedComponentsCount;
        }
        return null;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        String componentFilePath = executionContext.getString("file_export_component");
        this.moveTokenToRecordsList(componentFilePath);
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        if (this.parser != null) {
            this.parser.close();
        }
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        int processedCount = executionContext.getInt("records_number_to_process");
        executionContext.put("records_number_to_process", processedCount + this.processedComponentsCount);
        return ExitStatus.COMPLETED;
    }

    private void moveTokenToRecordsList(String componentFilePath) {
        try {
            String currentName;
            this.parser = this.mapper.getFactory().createParser(new File(componentFilePath));
            do {
                this.parser.nextToken();
            } while (!"records".equals(currentName = this.parser.getCurrentName()));
            this.parser.nextToken();
        }
        catch (IOException e) {
            log.error("Unable to parse a component file. {}", (Object)e.getMessage());
        }
    }
}

