/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.config.SchemaVersionsValidator;
import com.sonatype.nexus.db.migrator.item.export.ExportItem;
import com.sonatype.nexus.db.migrator.item.record.RecordItem;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;

@StepScope
public class FileReader
implements Tasklet,
StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileReader.class);
    private String configFilePath;
    private String securityFilePath;
    private String migrationType;
    private List<RecordItem> records;
    private ObjectMapper mapper;
    private SchemaVersionsValidator versionsValidator;

    @Override
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        ExportItem configExportItem = this.calculateExportItem(this.configFilePath);
        log.info("Current migration type is {}.", (Object)this.migrationType);
        this.versionsValidator.checkUpgradeModelVersion(configExportItem, this.migrationType);
        ExportItem securityExportItem = this.calculateExportItem(this.securityFilePath);
        this.records = Stream.concat(configExportItem.getRecords().stream(), securityExportItem.getRecords().stream()).filter(Objects::nonNull).collect(Collectors.toList());
        log.info("Total number of config and security records to be processed = {}", (Object)this.records.size());
        return RepeatStatus.FINISHED;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        this.migrationType = ConvertUtils.convertJobParametersToMap(stepExecution.getJobParameters()).get("migration_type").toString();
        this.configFilePath = String.valueOf(executionContext.get("file_export_config"));
        this.securityFilePath = String.valueOf(executionContext.get("file_export_security"));
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        executionContext.put("records", this.records);
        executionContext.put("records_number_to_process", this.records == null ? 0 : this.records.size());
        return ExitStatus.COMPLETED;
    }

    private ExportItem calculateExportItem(String filePath) throws IOException {
        if ("null".equals(filePath)) {
            return this.getEmptyExportItem();
        }
        return this.mapper.readValue(new File(filePath), ExportItem.class);
    }

    private ExportItem getEmptyExportItem() {
        ExportItem emptyExportItem = new ExportItem();
        emptyExportItem.setRecords(new ArrayList<RecordItem>());
        return emptyExportItem;
    }

    @Autowired
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Autowired
    public void setVersionsValidator(SchemaVersionsValidator versionsValidator) {
        this.versionsValidator = versionsValidator;
    }
}

