/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import com.orientechnologies.orient.core.conflict.OVersionRecordConflictStrategy;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.db.migrator.item.record.RecordItem;
import com.sonatype.nexus.db.migrator.utils.PathQualifier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.sonatype.nexus.orient.internal.PbeCompression;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrientDocumentReader
extends AbstractPagingItemReader<RecordItem>
implements StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrientDocumentReader.class);
    private static final String DB_URL_TEMPLATE = "plocal:%s/%s?mode=r";
    private static final String SELECT = "select from %s where @rid > %s limit %d";
    private static final String CONFLICT_HOOK = "ConflictHook";
    private String dbClassName;
    private String databaseName;
    private String lastRid = ORecordId.EMPTY_RECORD_ID.toString();
    private ObjectMapper mapper;
    private PathQualifier pathQualifier;
    private PbeCipherFactory pbeCipherFactory;
    private int readCount = 0;
    private OPartitionedDatabasePool pool;

    public OrientDocumentReader(String databaseName, String dbClassName, PbeCipherFactory pbeCipherFactory, int pageSize) {
        this.dbClassName = dbClassName;
        this.databaseName = databaseName;
        this.pbeCipherFactory = pbeCipherFactory;
        this.setPageSize(pageSize);
    }

    @PostConstruct
    private void registerCypher() throws Exception {
        if ("security".equals(this.databaseName) && !OCompressionFactory.INSTANCE.getCompressions().contains("pbe")) {
            OCompressionFactory.INSTANCE.register(new PbeCompression(this.pbeCipherFactory, "changeme", "changeme", "0123456789ABCDEF"));
        }
    }

    @PostConstruct
    private void registerConflictHook() {
        if (Orient.instance().getRecordConflictStrategy().getStrategy(CONFLICT_HOOK) == null) {
            Orient.instance().getRecordConflictStrategy().registerImplementation(CONFLICT_HOOK, new OVersionRecordConflictStrategy());
        }
    }

    @Override
    protected void doReadPage() {
        if (this.pool == null) {
            String dbUrl = String.format(DB_URL_TEMPLATE, this.pathQualifier.getOrientFolderPath(), this.databaseName);
            this.pool = new OPartitionedDatabasePool(dbUrl, "admin", "admin");
        }
        try (ODatabaseDocumentTx dbTx = this.pool.acquire();){
            String queryString = String.format(SELECT, this.dbClassName, this.lastRid, this.getPageSize());
            this.results = dbTx.query(new OSQLSynchQuery(queryString), new Object[0]).stream().map(document -> {
                try {
                    String json = document.toJSON("rid,type,version,class,attribSameRow,indent:2,dateAsLong");
                    return this.mapper.readValue(json, RecordItem.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("JSON mapping error", e);
                }
            }).collect(Collectors.toList());
            this.readCount += this.results.size();
            if (this.results.size() > 0) {
                this.lastRid = ((RecordItem)this.results.get(this.results.size() - 1)).getRid().toString();
            }
        }
        catch (Exception e) {
            log.error("Failed to read from table={}", (Object)this.dbClassName, (Object)e);
            throw e;
        }
    }

    @Override
    protected void doJumpToPage(int itemIndex) {
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        int processedCount = executionContext.getInt("records_number_to_process", 0);
        executionContext.put("records_number_to_process", processedCount + this.readCount);
        return ExitStatus.COMPLETED;
    }

    @Autowired
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Autowired
    public void setPathQualifier(PathQualifier pathQualifier) {
        this.pathQualifier = pathQualifier;
    }

    @Generated
    public OrientDocumentReader() {
    }
}

