/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.tasklet;

import com.sonatype.nexus.db.migrator.property.SchemaScriptProperties;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.SqlUtils;
import java.util.Map;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseFinalizer
implements Tasklet {
    @Autowired(required=false)
    @Qualifier(value="destinationJdbcTemplate")
    private JdbcTemplate destinationJdbcTemplate;
    private SchemaScriptProperties schemaScriptProperties;

    @Autowired
    public void setSchemaScriptProperties(SchemaScriptProperties schemaScriptProperties) {
        this.schemaScriptProperties = schemaScriptProperties;
    }

    @Override
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) {
        JobParameters jobParameters = chunkContext.getStepContext().getStepExecution().getJobParameters();
        Map<String, JobParameter> jobParameterMap = ConvertUtils.convertJobParametersToMap(jobParameters);
        String migrationType = jobParameterMap.get("migration_type").toString();
        if ("postgres".equalsIgnoreCase(migrationType) || "h2_to_postgres".equalsIgnoreCase(migrationType)) {
            return this.finalizePostgresDestination(this.destinationJdbcTemplate);
        }
        if ("postgres_to_h2".equalsIgnoreCase(migrationType) || "h2".equalsIgnoreCase(migrationType)) {
            return this.finalizeH2Destination(this.destinationJdbcTemplate);
        }
        throw new IllegalStateException("Unknown migration type:" + migrationType);
    }

    private RepeatStatus finalizePostgresDestination(JdbcTemplate postgresTemplate) {
        postgresTemplate.execute(SqlUtils.readSqlFromFile(this.schemaScriptProperties.getFinalizeComponentPostgresScript()));
        return RepeatStatus.FINISHED;
    }

    private RepeatStatus finalizeH2Destination(JdbcTemplate h2Template) {
        return RepeatStatus.FINISHED;
    }
}

