/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.tasklet;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.sonatype.nexus.db.migrator.config.Constants;
import com.sonatype.nexus.db.migrator.config.DatabaseName;
import com.sonatype.nexus.db.migrator.property.HealthCheckScripts;
import com.sonatype.nexus.db.migrator.utils.PathQualifier;
import com.sonatype.nexus.db.migrator.utils.SqlUtils;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.orient.entity.ConflictHook;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;

@StepScope
public class HealthCheckTasklet
implements Tasklet,
StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthCheckTasklet.class);
    private PathQualifier pathQualifier;
    @Autowired
    private HealthCheckScripts healthCheckScripts;

    public HealthCheckTasklet(PathQualifier pathQualifier) {
        this.pathQualifier = pathQualifier;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        Orient.instance().getRecordConflictStrategy().registerImplementation("ConflictHook", new ConflictHook(false));
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus exitStatus = stepExecution.getExitStatus();
        if (ExitStatus.COMPLETED.equals(exitStatus)) {
            this.printHealthCheckReport(stepExecution);
        }
        return exitStatus;
    }

    @Override
    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        ExecutionContext executionContext = stepContribution.getStepExecution().getExecutionContext();
        String dbLocalConnectionString = "plocal:" + this.pathQualifier.getOrientFolderPath() + Constants.SEPARATOR + (Object)((Object)DatabaseName.COMPONENT);
        try (ODatabaseDocumentTx orientDb = (ODatabaseDocumentTx)new ODatabaseDocumentTx(dbLocalConnectionString).open("admin", "admin");){
            this.checkForDuplicates(orientDb, executionContext);
            this.runCheckStorage(orientDb, executionContext);
            this.runCheckClustersConsistency(orientDb, executionContext);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            stepContribution.getStepExecution().setExitStatus(ExitStatus.FAILED);
        }
        Orient.instance().shutdown();
        return RepeatStatus.FINISHED;
    }

    private void checkForDuplicates(ODatabaseDocumentTx orientDb, ExecutionContext executionContext) {
        log.info("Checking db integrity for component duplicates...");
        int componentDuplicates = this.findDuplicates(orientDb, this.healthCheckScripts.getSelectComponentDuplicates());
        log.info("Checking db integrity for asset duplicates...");
        int assetDuplicates = this.findDuplicates(orientDb, this.healthCheckScripts.getSelectAssetsDuplicates());
        log.info("Checking db integrity for duplicates in browse nodes...");
        int browseNodesDuplicates = this.findDuplicates(orientDb, this.healthCheckScripts.getSelectBrowseNodesDuplicates());
        executionContext.putInt("number_component_duplicates", componentDuplicates);
        executionContext.putInt("number_asset_duplicates", assetDuplicates);
        executionContext.putInt("number_browse_nodes_duplicates", browseNodesDuplicates);
    }

    private void runCheckStorage(ODatabaseDocumentTx orientDb, ExecutionContext executionContext) {
        log.info("Checking db storage for errors...");
        int errors = 0;
        try {
            ((OAbstractPaginatedStorage)orientDb.getStorage()).check(true, log::info);
        }
        catch (ODatabaseImportException e) {
            log.error("Storage error: {}", (Object)e.getMessage(), (Object)(log.isDebugEnabled() ? e : null));
            ++errors;
        }
        executionContext.put("number_storage_errors", errors);
    }

    private void runCheckClustersConsistency(ODatabaseDocumentTx orientDb, ExecutionContext executionContext) {
        log.info("Checking db cluster consistency for errors...");
        int errors = 0;
        try {
            Collection<? extends OCluster> clusters = orientDb.getStorage().getClusterInstances();
            for (OCluster oCluster : clusters) {
                errors += oCluster.checkClusterConsistency();
            }
        }
        catch (Exception e) {
            log.error("Cluster consistency error: {}", (Object)(e.getMessage() != null ? e.getMessage() : e.toString()), (Object)(log.isDebugEnabled() ? e : null));
            log.info("Try to repair the OrientDB by 'REPAIR DATABASE --fix-cluster', more info at https://orientdb.org/docs/2.2.x/Console-Command-Repair-Database.html");
            ++errors;
        }
        executionContext.put("number_cluster_consistency_errors", errors);
    }

    private int findDuplicates(ODatabaseDocumentTx orientDb, String sqlScript) {
        return orientDb.query(new OSQLSynchQuery(SqlUtils.readSqlFromFile(sqlScript)), new Object[0]).size();
    }

    private void printHealthCheckReport(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        int storageErrors = executionContext.getInt("number_storage_errors", 0);
        int clusterConsistencyErrors = executionContext.getInt("number_cluster_consistency_errors", 0);
        int componentDuplicates = executionContext.getInt("number_component_duplicates", 0);
        int assetDuplicates = executionContext.getInt("number_asset_duplicates", 0);
        int browseNodesDuplicates = executionContext.getInt("number_browse_nodes_duplicates", 0);
        log.info("Check storage: {}", (Object)(storageErrors > 0 ? "FAILED" : "OK"));
        log.info("Check clusters consistency: {}", (Object)(clusterConsistencyErrors > 0 ? "FAILED" : "OK"));
        log.info("{} component duplicates found", (Object)componentDuplicates);
        log.info("{} asset duplicates found", (Object)assetDuplicates);
        log.info("{} browse nodes duplicates found", (Object)browseNodesDuplicates);
        boolean integrityIsHealth = this.databaseIntegrityIsHealth(storageErrors, clusterConsistencyErrors, componentDuplicates, assetDuplicates, browseNodesDuplicates);
        log.info("------------------------------------------------------------");
        log.info("Database integrity: {}", (Object)(integrityIsHealth ? "OK" : "BROKEN"));
        log.info("------------------------------------------------------------");
        ExecutionContext jobExecutionContext = stepExecution.getJobExecution().getExecutionContext();
        jobExecutionContext.putInt("db_integrity_health", integrityIsHealth ? 1 : 0);
    }

    private boolean databaseIntegrityIsHealth(int storageErrors, int clusterConsistencyErrors, int componentDuplicates, int assetDuplicates, int browsNodesDuplicates) {
        return storageErrors == 0 && clusterConsistencyErrors == 0 && componentDuplicates == 0 && assetDuplicates == 0 && browsNodesDuplicates == 0;
    }
}

