/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentIdUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentIdUtils.class);
    private static final Map<String, Integer> repositoryIds = new HashMap<String, Integer>();
    private static final Map<String, Integer> componentIds = new HashMap<String, Integer>();
    private static final Map<String, Set<Integer>> savedComponentIds = new HashMap<String, Set<Integer>>();
    private static final Map<String, Integer> repositoryIdsByFormat = new HashMap<String, Integer>();
    private static final Map<String, Integer> componentIdsByFormat = new HashMap<String, Integer>();
    private static final Map<String, Integer> assetIdsByFormat = new HashMap<String, Integer>();
    private static final Map<String, Integer> assetBlobIdsByFormat = new HashMap<String, Integer>();
    private static final Map<String, Integer> tagIds = new HashMap<String, Integer>();

    private ComponentIdUtils() {
    }

    public static Integer generateRepositoryId(String format, String rid) {
        Integer repositoryId = repositoryIdsByFormat.compute(format, (k, v) -> {
            int n;
            if (v != null) {
                v = v + 1;
                n = v;
            } else {
                n = 1;
            }
            return n;
        });
        log.trace("Creating repositoryId '{}', format '{}', rid '{}'", repositoryId, format, rid);
        repositoryIds.put(rid, repositoryId);
        return repositoryId;
    }

    public static Integer generateComponentId(String format, String rid) {
        Integer componentId = componentIdsByFormat.compute(format, (k, v) -> {
            int n;
            if (v != null) {
                v = v + 1;
                n = v;
            } else {
                n = 1;
            }
            return n;
        });
        componentIds.put(rid, componentId);
        return componentId;
    }

    public static Integer generateTagId(String rid) {
        Integer tagId = tagIds.size() + 1;
        tagIds.put(rid, tagId);
        return tagId;
    }

    public static Integer generateAssetId(String format) {
        return assetIdsByFormat.compute(format, (k, v) -> {
            int n;
            if (v != null) {
                v = v + 1;
                n = v;
            } else {
                n = 1;
            }
            return n;
        });
    }

    public static Integer generateAssetBlobId(String format) {
        return assetBlobIdsByFormat.compute(format, (k, v) -> {
            int n;
            if (v != null) {
                v = v + 1;
                n = v;
            } else {
                n = 1;
            }
            return n;
        });
    }

    public static Integer getRepositoryId(String rid) {
        Integer repositoryId = repositoryIds.get(rid);
        log.trace("Getting repositoryId '{}', rid '{}'", (Object)repositoryId, (Object)rid);
        return repositoryId;
    }

    public static Integer getComponentId(String rid) {
        return componentIds.get(rid);
    }

    public static Set<Integer> getSavedComponentIds(String format) {
        return savedComponentIds.getOrDefault(format, new HashSet());
    }

    public static void addSavedComponentIds(String format, List<Integer> newComponentIds) {
        savedComponentIds.compute(format, (k, v) -> {
            if (v == null) {
                v = new HashSet();
            }
            v.addAll(newComponentIds);
            return v;
        });
    }

    public static Integer getTagId(String rid) {
        return tagIds.get(rid);
    }

    public static List<Integer> convertTagIds(List<String> orientTagIds) {
        if (CollectionUtils.isEmpty(orientTagIds)) {
            return Collections.emptyList();
        }
        ArrayList<Integer> tagIds = new ArrayList<Integer>(orientTagIds.size());
        for (String rid : orientTagIds) {
            Integer tagId = ComponentIdUtils.getTagId(rid);
            if (tagId == null) continue;
            tagIds.add(tagId);
        }
        return tagIds;
    }

    public static boolean repositoryExists(String format, Integer repositoryId) {
        return repositoryIdsByFormat.get(format) != null && repositoryIdsByFormat.get(format) >= repositoryId;
    }

    @Generated
    public static Map<String, Set<Integer>> getSavedComponentIds() {
        return savedComponentIds;
    }
}

