/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.utils;

import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.item.record.content.ContentRepositoryRecord;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RepositoryUtils.class);
    private static final Map<String, String> formatByRepositoryName = new HashMap<String, String>();
    private static final Set<String> filteredRepositoryNames = new HashSet<String>();

    private RepositoryUtils() {
    }

    public static void addFormatByRepositoryName(String repositoryName, String format) {
        log.info("Adding repository name '{}' to format '{}'", (Object)repositoryName, (Object)format);
        formatByRepositoryName.put(repositoryName, format);
    }

    public static String getFormatByRecord(ContentRepositoryRecord record) {
        String repositoryName = record.getRepositoryName();
        String format = formatByRepositoryName.get(repositoryName);
        if (format == null && (format = RepositoryUtils.findFormatByName(record.getRepositoryName())) == null) {
            format = RepositoryUtils.findFormatByAttributes(record.getAttributes());
        }
        log.info("Getting format '{}' for repository name '{}'", (Object)format, (Object)repositoryName);
        return format;
    }

    @VisibleForTesting
    static String findFormatByName(String repositoryName) {
        List<String> parts = Arrays.asList(repositoryName.toUpperCase().split("[^a-zA-Z']+"));
        return Format.SUPPORTED_FORMAT_NAMES.stream().filter(format -> parts.contains(format.replace(Format.MAVEN2.name(), "MAVEN"))).findFirst().map(String::toLowerCase).orElse(null);
    }

    @VisibleForTesting
    static String findFormatByAttributes(Map<String, Object> attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.keySet().stream().map(attr -> attr.split("-")).flatMap(parts -> Stream.of(parts).map(RepositoryUtils::findFormatByName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static String getFormatFromRecipe(String repositoryRecipe) {
        return repositoryRecipe.split("-")[0];
    }

    public static void addFilteredRepositoryName(String repositoryName) {
        log.info("Adding filtered repository name '{}'", (Object)repositoryName);
        filteredRepositoryNames.add(repositoryName.toLowerCase());
    }

    public static boolean isEachRepositoryFiltered(List<String> repositoryNames) {
        return filteredRepositoryNames.stream().anyMatch(repositoryNames::contains);
    }

    public static boolean isRepositoryFiltered(String repositoryName) {
        return filteredRepositoryNames.contains(repositoryName);
    }
}

