/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.validator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sonatype.nexus.db.migrator.config.Constants;
import com.sonatype.nexus.db.migrator.exception.InvalidMigrationFilesException;
import com.sonatype.nexus.db.migrator.exception.InvalidMigrationFilesLocationException;
import com.sonatype.nexus.db.migrator.exception.InvalidMigratorLocationException;
import com.sonatype.nexus.db.migrator.utils.JobParameterUtil;
import com.sonatype.nexus.db.migrator.utils.MigrationFilesPathQualifier;
import com.sonatype.nexus.db.migrator.utils.PathQualifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.JobParametersValidator;

public class PathValidator
implements JobParametersValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PathValidator.class);
    public static final String FOLDER = "folder";
    public static final String FILE = "file";
    public static final Set<String> ORIENT_DATABASE_FILE_EXTENSIONS = ImmutableSet.of(".nbt", ".sbt", ".cpm", ".pcl");
    public static final String BACKUP_FILES_MISSING_ERROR = "No backup files (*.bak) found.";
    public static final String INCONSISTENT_VERSIONS_ERROR = "The backup versions are inconsistent.";
    public static final String DATABASE_BACKUP_MISSING_ERROR = "Not all required database names are present.";
    public static final String EXISTING_DATABASE_FOUND_ERROR = "Existing database files found.";
    private final PathQualifier pathQualifier;
    private final MigrationFilesPathQualifier migrationFilesPathQualifier;

    public PathValidator(PathQualifier pathQualifier, MigrationFilesPathQualifier migrationFilesPathQualifier) {
        this.pathQualifier = pathQualifier;
        this.migrationFilesPathQualifier = migrationFilesPathQualifier;
    }

    @Override
    public void validate(JobParameters jobParameters) throws JobParametersInvalidException {
        boolean isExportJson = JobParameterUtil.getExportJsonParameter(jobParameters);
        boolean isOrientMigration = JobParameterUtil.isOrientMigration(jobParameters);
        if (!isExportJson && isOrientMigration) {
            this.validateDirectRequirements(this.pathQualifier);
        } else {
            this.validateExportJsonRequirements(jobParameters);
        }
    }

    private void validateDirectRequirements(PathQualifier pathQualifier) throws JobParametersInvalidException {
        Path orientDirectoryPath = Paths.get(pathQualifier.getOrientFolderPath(), new String[0]);
        File orientDirectory = orientDirectoryPath.toFile();
        if (!orientDirectory.exists()) {
            throw new InvalidMigratorLocationException();
        }
        this.validateContainsBackupFiles(orientDirectory);
        PathValidator.validateDoesNotContainDatabaseFiles(orientDirectory);
    }

    static void validateDoesNotContainDatabaseFiles(File orientDirectory) throws InvalidMigrationFilesException, InvalidMigratorLocationException {
        log.info("Validating Orient directory does not contain database files: {}", (Object)orientDirectory);
        File[] databaseDirectories = orientDirectory.listFiles((file, name) -> file.isDirectory() && Constants.ORIENT_DATABASE_NAMES.contains(name));
        if (databaseDirectories == null) {
            return;
        }
        PathValidator.checkDirectoryForDatabaseFiles(orientDirectory, databaseDirectories);
    }

    static void checkDirectoryForDatabaseFiles(File orientDirectory, File[] databaseDirectories) throws InvalidMigrationFilesException, InvalidMigratorLocationException {
        for (File databaseDirectory : databaseDirectories) {
            try (Stream<Path> pathStream = Files.list(databaseDirectory.toPath());){
                if (PathValidator.pathContainsOrientDatabaseFiles(pathStream)) {
                    throw new InvalidMigrationFilesException(orientDirectory, EXISTING_DATABASE_FOUND_ERROR);
                }
            }
            catch (IOException ex) {
                throw new InvalidMigratorLocationException();
            }
            log.warn("Existing empty database directories found");
        }
    }

    static boolean pathContainsOrientDatabaseFiles(Stream<Path> pathStream) {
        return pathStream.map(Path::getFileName).map(s2 -> s2.toString().split("\\.")).filter(s2 -> ((String[])s2).length >= 2).map(s2 -> s2[((String[])s2).length - 1]).map(s2 -> "." + s2).anyMatch(ORIENT_DATABASE_FILE_EXTENSIONS::contains);
    }

    void validateContainsBackupFiles(File orientDirectory) throws InvalidMigrationFilesLocationException, InvalidMigrationFilesException {
        log.info("Validating Orient directory contains .bak files: {}", (Object)orientDirectory);
        File[] backupFiles = orientDirectory.listFiles((file, name) -> name.endsWith(".bak"));
        if (backupFiles == null || backupFiles.length == 0) {
            throw new InvalidMigrationFilesException(orientDirectory, BACKUP_FILES_MISSING_ERROR);
        }
        Object version = null;
        HashMap<String, Set<String>> versionNamesMap = new HashMap<String, Set<String>>();
        for (File backupFile : backupFiles) {
            this.updateVersionDatabaseMap(backupFile.getName(), versionNamesMap);
        }
        if (versionNamesMap.isEmpty()) {
            throw new InvalidMigrationFilesException(orientDirectory, BACKUP_FILES_MISSING_ERROR);
        }
        if (versionNamesMap.size() != 1) {
            throw new InvalidMigrationFilesException(orientDirectory, INCONSISTENT_VERSIONS_ERROR);
        }
        if (!((Set)versionNamesMap.values().iterator().next()).containsAll(Constants.ORIENT_DATABASE_NAMES)) {
            throw new InvalidMigrationFilesException(orientDirectory, DATABASE_BACKUP_MISSING_ERROR);
        }
    }

    void updateVersionDatabaseMap(String backupFilename, Map<String, Set<String>> versionNamesMap) {
        String[] backupName = backupFilename.substring(0, backupFilename.lastIndexOf(46)).split("-", 2);
        if (backupName.length == 2 && Constants.ORIENT_DATABASE_NAMES.contains(backupName[0])) {
            String databaseName = backupName[0];
            String version = backupName[1];
            Set databaseNames = versionNamesMap.computeIfAbsent(version, v -> new HashSet());
            databaseNames.add(databaseName);
        }
    }

    private void validateExportJsonRequirements(JobParameters jobParameters) throws JobParametersInvalidException {
        String migrationFilesFolder = this.migrationFilesPathQualifier.getMigrationFolderPath();
        if (migrationFilesFolder != null) {
            log.info("Validating exported Orient json files in directory: {}", (Object)migrationFilesFolder);
            this.verifyContainAllRequiredObjects(Paths.get(migrationFilesFolder, new String[0]), FILE);
            return;
        }
        if (JobParameterUtil.isOrientMigration(jobParameters)) {
            Path orientFolderPath = Paths.get(this.pathQualifier.getOrientFolderPath(), new String[0]);
            log.info("Validating Orient directory: {}", (Object)orientFolderPath);
            this.verifyContainAllRequiredObjects(orientFolderPath, FOLDER);
        }
    }

    private void verifyContainAllRequiredObjects(Path objectsPath, String objType) throws JobParametersInvalidException {
        HashSet<String> requiredFiles = Sets.newHashSet(Constants.ORIENT_REQUIRED_DIRECTORIES);
        boolean isContainsAllRequiredObjects = this.dirEntries(objectsPath).stream().filter(path -> this.isRequiredObjectType((Path)path, objType)).map(path -> path.getFileName().toString()).anyMatch(fileName -> requiredFiles.remove(fileName) && requiredFiles.isEmpty());
        if (isContainsAllRequiredObjects) {
            return;
        }
        if (FILE.equals(objType)) {
            throw new InvalidMigrationFilesLocationException(objectsPath.toString());
        }
        if (FOLDER.equals(objType)) {
            throw new InvalidMigratorLocationException();
        }
        throw new JobParametersInvalidException("Neither Orient directory nor export files directory has not been specified");
    }

    private boolean isRequiredObjectType(Path path, String objectType) {
        if (FILE.equals(objectType)) {
            return Files.isRegularFile(path, new LinkOption[0]);
        }
        if (FOLDER.equals(objectType)) {
            return Files.isDirectory(path, new LinkOption[0]);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Path> dirEntries(Path dir) {
        try (Stream<Path> files = Files.list(dir);){
            List<Path> list = files.collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            log.error("Cannot open the directory {}", (Object)dir);
            return Collections.emptyList();
        }
    }
}

