/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.writer;

import com.sonatype.nexus.db.migrator.entity.AssetEntity;
import com.sonatype.nexus.db.migrator.entity.Entity;
import com.sonatype.nexus.db.migrator.utils.AssetAndAssetBlobUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.dao.DuplicateKeyException;

public class AssetAndAssetBlobWriter
implements ItemWriter<Entity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssetAndAssetBlobWriter.class);
    private final JdbcBatchItemWriter<Entity> assetWriter;
    private final JdbcBatchItemWriter<Entity> assetBlobWriter;
    private final String insertAssetSql;
    private final String insertAssetBlobSql;

    @Override
    public void write(List<? extends Entity> items) throws Exception {
        Map<String, List<AssetEntity>> assets = items.stream().map(AssetEntity.class::cast).collect(Collectors.groupingBy(AssetEntity::getFormat));
        HashMap<String, Set<Integer>> chunkSavedAssetIds = new HashMap<String, Set<Integer>>();
        HashMap<String, Set<String>> chunkSavedAssetBlobRefs = new HashMap<String, Set<String>>();
        for (Map.Entry<String, List<AssetEntity>> entry : assets.entrySet()) {
            this.writeByFormat(entry.getKey(), entry.getValue(), chunkSavedAssetIds, chunkSavedAssetBlobRefs);
        }
    }

    private void writeByFormat(String format, List<AssetEntity> items, Map<String, Set<Integer>> chunkSavedAssetIds, Map<String, Set<String>> chunkSavedAssetBlobRefs) throws Exception {
        String formattedInsertAssetSql = this.insertAssetSql.replace("${format}", format);
        String formattedInsertAssetBlobSql = this.insertAssetBlobSql.replace("${format}", format);
        this.assetWriter.setSql(formattedInsertAssetSql);
        this.assetBlobWriter.setSql(formattedInsertAssetBlobSql);
        Set<Integer> savedAssets = AssetAndAssetBlobUtils.getSavedAssets(format);
        Map<String, Integer> savedAssetBlobs = AssetAndAssetBlobUtils.getSavedAssetBlobIds(format);
        Set<Integer> assetIdsWithDuplicatedBlob = AssetAndAssetBlobUtils.getAssetIdsWithDuplicatedBlob(format);
        List<AssetEntity> assetBlobs = items.stream().filter(e -> e.getBlobRef() != null).filter(item -> AssetAndAssetBlobWriter.filterDuplicatedBlobs(item, savedAssetBlobs, assetIdsWithDuplicatedBlob)).collect(Collectors.toList());
        try {
            this.assetBlobWriter.write(assetBlobs);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        AssetAndAssetBlobUtils.saveAssetBlobIds(assetBlobs, format);
        Set<String> newSavedAssetBlobs = AssetAndAssetBlobUtils.getSavedAssetBlobIds(format).keySet();
        List<AssetEntity> assets = items.stream().filter(item -> savedAssets.add(item.getAssetId()) && (item.getAssetBlobId() == null || newSavedAssetBlobs.contains(item.getBlobRef()))).map(AssetAndAssetBlobWriter.updateIdForDuplicatedBlob(assetIdsWithDuplicatedBlob, savedAssetBlobs)).collect(Collectors.toList());
        this.saveChunkSavedAssetIds(chunkSavedAssetIds, assets, format);
        this.saveChunkSavedAssetBlobRefs(chunkSavedAssetBlobRefs, assets, format);
        try {
            this.assetWriter.write(assets);
        }
        catch (DuplicateKeyException e2) {
            chunkSavedAssetIds.forEach(AssetAndAssetBlobUtils::removeSavedAssets);
            chunkSavedAssetBlobRefs.forEach(AssetAndAssetBlobUtils::removeSavedAssetBlobId);
            throw e2;
        }
        AssetAndAssetBlobUtils.saveAssets(assets, format);
    }

    private void saveChunkSavedAssetIds(Map<String, Set<Integer>> chunkSavedAssetIds, List<AssetEntity> assets, String format) {
        Set assetIds = chunkSavedAssetIds.computeIfAbsent(format, k -> new HashSet());
        assets.stream().map(AssetEntity::getAssetId).forEach(assetIds::add);
    }

    private void saveChunkSavedAssetBlobRefs(Map<String, Set<String>> chunkSavedAssetBlobRefs, List<AssetEntity> assets, String format) {
        Set blobRefs = chunkSavedAssetBlobRefs.computeIfAbsent(format, k -> new HashSet());
        assets.stream().filter(asset -> asset.getAssetBlobId() != null && asset.getAssetId() == asset.getAssetBlobId().intValue()).map(AssetEntity::getBlobRef).forEach(blobRefs::add);
    }

    private static Function<AssetEntity, AssetEntity> updateIdForDuplicatedBlob(Set<Integer> assetIdsWithDuplicatedBlob, Map<String, Integer> savedAssetBlobs) {
        return asset -> {
            if (assetIdsWithDuplicatedBlob.contains(asset.getAssetId())) {
                Integer blobId = (Integer)savedAssetBlobs.get(asset.getBlobRef());
                asset.setAssetBlobId(blobId);
            }
            return asset;
        };
    }

    private static boolean filterDuplicatedBlobs(AssetEntity asset, Map<String, Integer> savedAssetBlobs, Set<Integer> assetIdsWithDuplicatedBlob) {
        Integer blobId = savedAssetBlobs.get(asset.getBlobRef());
        if (blobId == null) {
            savedAssetBlobs.put(asset.getBlobRef(), asset.getAssetBlobId());
            return true;
        }
        assetIdsWithDuplicatedBlob.add(asset.getAssetId());
        return false;
    }

    @Generated
    public AssetAndAssetBlobWriter(JdbcBatchItemWriter<Entity> assetWriter, JdbcBatchItemWriter<Entity> assetBlobWriter, String insertAssetSql, String insertAssetBlobSql) {
        this.assetWriter = assetWriter;
        this.assetBlobWriter = assetBlobWriter;
        this.insertAssetSql = insertAssetSql;
        this.insertAssetBlobSql = insertAssetBlobSql;
    }
}

