/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.writer;

import com.sonatype.nexus.db.migrator.entity.ComponentTagEntity;
import com.sonatype.nexus.db.migrator.entity.Entity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcBatchItemWriter;

public class ComponentTagWriter
implements ItemWriter<Entity> {
    private final JdbcBatchItemWriter<Entity> componentTagJdbcWriter;
    private final String insertSql;

    @Override
    public void write(List<? extends Entity> items) throws Exception {
        Map<String, List<ComponentTagEntity>> componentsTags = items.stream().map(ComponentTagEntity.class::cast).collect(Collectors.groupingBy(ComponentTagEntity::getFormat));
        for (Map.Entry<String, List<ComponentTagEntity>> entry : componentsTags.entrySet()) {
            this.writeByFormat(entry.getKey(), entry.getValue());
        }
    }

    private void writeByFormat(String format, List<ComponentTagEntity> items) throws Exception {
        this.componentTagJdbcWriter.setSql(this.insertSql.replace("${format}", format));
        this.componentTagJdbcWriter.write(items);
    }

    @Generated
    public ComponentTagWriter(JdbcBatchItemWriter<Entity> componentTagJdbcWriter, String insertSql) {
        this.componentTagJdbcWriter = componentTagJdbcWriter;
        this.insertSql = insertSql;
    }
}

